/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.domain.solver;

import org.apache.commons.lang3.builder.CompareToBuilder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.TspSolution;
import org.optaplanner.examples.tsp.domain.Visit;

public class DomicileDistanceVisitDifficultyWeightFactory
implements SelectionSorterWeightFactory<TspSolution, Visit> {
    public Comparable createSorterWeight(TspSolution tspSolution, Visit visit) {
        Domicile domicile = tspSolution.getDomicile();
        long domicileRoundTripDistance = domicile.getDistanceTo(visit) + visit.getDistanceTo(domicile);
        return new DomicileDistanceVisitDifficultyWeight(visit, domicileRoundTripDistance);
    }

    public static class DomicileDistanceVisitDifficultyWeight
    implements Comparable<DomicileDistanceVisitDifficultyWeight> {
        private final Visit visit;
        private final long domicileRoundTripDistance;

        public DomicileDistanceVisitDifficultyWeight(Visit visit, long domicileRoundTripDistance) {
            this.visit = visit;
            this.domicileRoundTripDistance = domicileRoundTripDistance;
        }

        @Override
        public int compareTo(DomicileDistanceVisitDifficultyWeight other) {
            return new CompareToBuilder().append(this.domicileRoundTripDistance, other.domicileRoundTripDistance).append(this.visit.getLocation().getLatitude(), other.visit.getLocation().getLatitude()).append((Object)this.visit.getId(), (Object)other.visit.getId()).toComparison();
        }
    }
}

