/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import org.optaplanner.examples.common.persistence.AbstractSolutionDao;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;

public abstract class XStreamSolutionDao<Solution_>
extends AbstractSolutionDao<Solution_> {
    protected XStreamSolutionFileIO<Solution_> xStreamSolutionFileIO;

    public XStreamSolutionDao(String dirName, Class ... xStreamAnnotations) {
        super(dirName);
        this.xStreamSolutionFileIO = new XStreamSolutionFileIO(xStreamAnnotations);
    }

    @Override
    public String getFileExtension() {
        return this.xStreamSolutionFileIO.getOutputFileExtension();
    }

    @Override
    public Solution_ readSolution(File inputSolutionFile) {
        Object solution = this.xStreamSolutionFileIO.read(inputSolutionFile);
        this.logger.info("Opened: {}", (Object)inputSolutionFile);
        return (Solution_)solution;
    }

    @Override
    public void writeSolution(Solution_ solution, File outputSolutionFile) {
        this.xStreamSolutionFileIO.write(solution, outputSolutionFile);
        this.logger.info("Saved: {}", (Object)outputSolutionFile);
    }
}

