/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.coachshuttlegathering.domain.solver;

import org.apache.commons.lang3.builder.CompareToBuilder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.coachshuttlegathering.domain.BusHub;
import org.optaplanner.examples.coachshuttlegathering.domain.BusOrStop;
import org.optaplanner.examples.coachshuttlegathering.domain.CoachShuttleGatheringSolution;

public class DepotAngleBusStopDifficultyWeightFactory
implements SelectionSorterWeightFactory<CoachShuttleGatheringSolution, BusOrStop> {
    public Comparable createSorterWeight(CoachShuttleGatheringSolution solution, BusOrStop busOrStop) {
        BusHub hub = solution.getHub();
        return new DepotAngleBusStopDifficultyWeight(busOrStop, busOrStop.getLocation().getAngle(hub.getLocation()), busOrStop.getLocation().getMaximumDistanceTo(hub.getLocation()) + hub.getLocation().getMaximumDistanceTo(busOrStop.getLocation()));
    }

    public static class DepotAngleBusStopDifficultyWeight
    implements Comparable<DepotAngleBusStopDifficultyWeight> {
        private final BusOrStop busOrStop;
        private final double hubAngle;
        private final int hubRoundTripDistance;

        public DepotAngleBusStopDifficultyWeight(BusOrStop busOrStop, double hubAngle, int hubRoundTripDistance) {
            this.busOrStop = busOrStop;
            this.hubAngle = hubAngle;
            this.hubRoundTripDistance = hubRoundTripDistance;
        }

        @Override
        public int compareTo(DepotAngleBusStopDifficultyWeight other) {
            return new CompareToBuilder().append(this.hubAngle, other.hubAngle).append(this.hubRoundTripDistance, other.hubRoundTripDistance).append((Object)this.busOrStop.getId(), (Object)other.busOrStop.getId()).toComparison();
        }
    }
}

