/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.solver.move;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.NurseRoster;
import org.optaplanner.examples.nurserostering.domain.ShiftAssignment;
import org.optaplanner.examples.nurserostering.solver.move.NurseRosteringMoveHelper;

public class EmployeeMultipleChangeMove
extends AbstractMove<NurseRoster> {
    private Employee fromEmployee;
    private List<ShiftAssignment> shiftAssignmentList;
    private Employee toEmployee;

    public EmployeeMultipleChangeMove(Employee fromEmployee, List<ShiftAssignment> shiftAssignmentList, Employee toEmployee) {
        this.fromEmployee = fromEmployee;
        this.shiftAssignmentList = shiftAssignmentList;
        this.toEmployee = toEmployee;
    }

    public boolean isMoveDoable(ScoreDirector<NurseRoster> scoreDirector) {
        return !Objects.equals(this.fromEmployee, this.toEmployee);
    }

    public EmployeeMultipleChangeMove createUndoMove(ScoreDirector<NurseRoster> scoreDirector) {
        return new EmployeeMultipleChangeMove(this.toEmployee, this.shiftAssignmentList, this.fromEmployee);
    }

    protected void doMoveOnGenuineVariables(ScoreDirector<NurseRoster> scoreDirector) {
        for (ShiftAssignment shiftAssignment : this.shiftAssignmentList) {
            if (!shiftAssignment.getEmployee().equals(this.fromEmployee)) {
                throw new IllegalStateException("The shiftAssignment (" + shiftAssignment + ") should have the same employee (" + this.fromEmployee + ") as the fromEmployee (" + this.fromEmployee + ").");
            }
            NurseRosteringMoveHelper.moveEmployee(scoreDirector, shiftAssignment, this.toEmployee);
        }
    }

    public EmployeeMultipleChangeMove rebase(ScoreDirector<NurseRoster> destinationScoreDirector) {
        return new EmployeeMultipleChangeMove((Employee)destinationScoreDirector.lookUpWorkingObject((Object)this.fromEmployee), EmployeeMultipleChangeMove.rebaseList(this.shiftAssignmentList, destinationScoreDirector), (Employee)destinationScoreDirector.lookUpWorkingObject((Object)this.toEmployee));
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.shiftAssignmentList);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Arrays.asList(this.fromEmployee, this.toEmployee);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EmployeeMultipleChangeMove) {
            EmployeeMultipleChangeMove other = (EmployeeMultipleChangeMove)((Object)o);
            return new EqualsBuilder().append((Object)this.fromEmployee, (Object)other.fromEmployee).append(this.shiftAssignmentList, other.shiftAssignmentList).append((Object)this.toEmployee, (Object)other.toEmployee).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.fromEmployee).append(this.shiftAssignmentList).append((Object)this.toEmployee).toHashCode();
    }

    public String toString() {
        return this.shiftAssignmentList + " {? -> " + this.toEmployee + "}";
    }
}

