/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.optional.move;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;

public class CloudComputerChangeMove
extends AbstractMove<CloudBalance> {
    private CloudProcess cloudProcess;
    private CloudComputer toCloudComputer;

    public CloudComputerChangeMove(CloudProcess cloudProcess, CloudComputer toCloudComputer) {
        this.cloudProcess = cloudProcess;
        this.toCloudComputer = toCloudComputer;
    }

    public boolean isMoveDoable(ScoreDirector<CloudBalance> scoreDirector) {
        return !Objects.equals(this.cloudProcess.getComputer(), this.toCloudComputer);
    }

    public CloudComputerChangeMove createUndoMove(ScoreDirector<CloudBalance> scoreDirector) {
        return new CloudComputerChangeMove(this.cloudProcess, this.cloudProcess.getComputer());
    }

    protected void doMoveOnGenuineVariables(ScoreDirector<CloudBalance> scoreDirector) {
        scoreDirector.beforeVariableChanged((Object)this.cloudProcess, "computer");
        this.cloudProcess.setComputer(this.toCloudComputer);
        scoreDirector.afterVariableChanged((Object)this.cloudProcess, "computer");
    }

    public CloudComputerChangeMove rebase(ScoreDirector<CloudBalance> destinationScoreDirector) {
        return new CloudComputerChangeMove((CloudProcess)destinationScoreDirector.lookUpWorkingObject((Object)this.cloudProcess), (CloudComputer)destinationScoreDirector.lookUpWorkingObject((Object)this.toCloudComputer));
    }

    public String getSimpleMoveTypeDescription() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + CloudProcess.class.getSimpleName() + ".computer)";
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.cloudProcess);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toCloudComputer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CloudComputerChangeMove) {
            CloudComputerChangeMove other = (CloudComputerChangeMove)((Object)o);
            return new EqualsBuilder().append((Object)this.cloudProcess, (Object)other.cloudProcess).append((Object)this.toCloudComputer, (Object)other.toCloudComputer).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.cloudProcess).append((Object)this.toCloudComputer).toHashCode();
    }

    public String toString() {
        return this.cloudProcess + " {" + this.cloudProcess.getComputer() + " -> " + this.toCloudComputer + "}";
    }
}

