/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.optional.realtime;

import java.util.ArrayList;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;

public class AddComputerProblemFactChange
implements ProblemFactChange<CloudBalance> {
    private final CloudComputer computer;

    public AddComputerProblemFactChange(CloudComputer computer) {
        this.computer = computer;
    }

    public void doChange(ScoreDirector<CloudBalance> scoreDirector) {
        CloudBalance cloudBalance = (CloudBalance)scoreDirector.getWorkingSolution();
        long nextComputerId = 0L;
        for (CloudComputer otherComputer : cloudBalance.getComputerList()) {
            if (nextComputerId > otherComputer.getId()) continue;
            nextComputerId = otherComputer.getId() + 1L;
        }
        this.computer.setId(nextComputerId);
        cloudBalance.setComputerList(new ArrayList<CloudComputer>(cloudBalance.getComputerList()));
        scoreDirector.beforeProblemFactAdded((Object)this.computer);
        cloudBalance.getComputerList().add(this.computer);
        scoreDirector.afterProblemFactAdded((Object)this.computer);
    }
}

