/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.taskassigning.domain.solver;

import java.util.Objects;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.taskassigning.domain.Task;
import org.optaplanner.examples.taskassigning.domain.TaskOrEmployee;

public class StartTimeUpdatingVariableListener
implements VariableListener<Task> {
    public void beforeEntityAdded(ScoreDirector scoreDirector, Task task) {
    }

    public void afterEntityAdded(ScoreDirector scoreDirector, Task task) {
        this.updateStartTime(scoreDirector, task);
    }

    public void beforeVariableChanged(ScoreDirector scoreDirector, Task task) {
    }

    public void afterVariableChanged(ScoreDirector scoreDirector, Task task) {
        this.updateStartTime(scoreDirector, task);
    }

    public void beforeEntityRemoved(ScoreDirector scoreDirector, Task task) {
    }

    public void afterEntityRemoved(ScoreDirector scoreDirector, Task task) {
    }

    protected void updateStartTime(ScoreDirector scoreDirector, Task sourceTask) {
        Task shadowTask;
        TaskOrEmployee previous = sourceTask.getPreviousTaskOrEmployee();
        Integer previousEndTime = previous == null ? null : previous.getEndTime();
        Integer startTime = this.calculateStartTime(shadowTask, previousEndTime);
        for (shadowTask = sourceTask; shadowTask != null && !Objects.equals(shadowTask.getStartTime(), startTime); shadowTask = shadowTask.getNextTask()) {
            scoreDirector.beforeVariableChanged((Object)shadowTask, "startTime");
            shadowTask.setStartTime(startTime);
            scoreDirector.afterVariableChanged((Object)shadowTask, "startTime");
            previousEndTime = shadowTask.getEndTime();
            startTime = this.calculateStartTime(shadowTask, previousEndTime);
        }
    }

    private Integer calculateStartTime(Task task, Integer previousEndTime) {
        if (task == null || previousEndTime == null) {
            return null;
        }
        return Math.max(task.getReadyTime(), previousEndTime);
    }
}

