/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.swingui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.examples.common.business.SolutionBusiness;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.swingui.ConstraintMatchesDialog;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.swing.impl.SwingUtils;
import org.optaplanner.swing.impl.TangoColorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolverAndPersistenceFrame<Solution_>
extends JFrame {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final ImageIcon OPTA_PLANNER_ICON = new ImageIcon(SolverAndPersistenceFrame.class.getResource("optaPlannerIcon.png"));
    private final SolutionBusiness<Solution_> solutionBusiness;
    private final ImageIcon indictmentHeatMapTrueIcon;
    private final ImageIcon indictmentHeatMapFalseIcon;
    private final ImageIcon refreshScreenDuringSolvingTrueIcon;
    private final ImageIcon refreshScreenDuringSolvingFalseIcon;
    private SolutionPanel<Solution_> solutionPanel;
    private ConstraintMatchesDialog constraintMatchesDialog;
    private JPanel quickOpenUnsolvedPanel;
    private List<Action> quickOpenUnsolvedActionList;
    private JPanel quickOpenSolvedPanel;
    private List<Action> quickOpenSolvedActionList;
    private Action openAction;
    private Action saveAction;
    private Action importAction;
    private Action exportAction;
    private JToggleButton refreshScreenDuringSolvingToggleButton;
    private JToggleButton indictmentHeatMapToggleButton;
    private Action solveAction;
    private JButton solveButton;
    private Action terminateSolvingEarlyAction;
    private JButton terminateSolvingEarlyButton;
    private JPanel middlePanel;
    private JProgressBar progressBar;
    private JTextField scoreField;
    private ShowConstraintMatchesDialogAction showConstraintMatchesDialogAction;

    public SolverAndPersistenceFrame(SolutionBusiness<Solution_> solutionBusiness, SolutionPanel<Solution_> solutionPanel) {
        super(solutionBusiness.getAppName() + " OptaPlanner example");
        this.solutionBusiness = solutionBusiness;
        this.solutionPanel = solutionPanel;
        this.setIconImage(OPTA_PLANNER_ICON.getImage());
        solutionPanel.setSolutionBusiness(solutionBusiness);
        solutionPanel.setSolverAndPersistenceFrame(this);
        this.indictmentHeatMapTrueIcon = new ImageIcon(this.getClass().getResource("indictmentHeatMapTrueIcon.png"));
        this.indictmentHeatMapFalseIcon = new ImageIcon(this.getClass().getResource("indictmentHeatMapFalseIcon.png"));
        this.refreshScreenDuringSolvingTrueIcon = new ImageIcon(this.getClass().getResource("refreshScreenDuringSolvingTrueIcon.png"));
        this.refreshScreenDuringSolvingFalseIcon = new ImageIcon(this.getClass().getResource("refreshScreenDuringSolvingFalseIcon.png"));
        this.registerListeners();
        this.constraintMatchesDialog = new ConstraintMatchesDialog(this, solutionBusiness);
    }

    private void registerListeners() {
        this.solutionBusiness.registerForBestSolutionChanges(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SolverAndPersistenceFrame.this.solutionBusiness.terminateSolvingEarly();
            }
        });
    }

    public void bestSolutionChanged() {
        Solution_ solution = this.solutionBusiness.getSolution();
        Score score = this.solutionBusiness.getScore();
        if (this.refreshScreenDuringSolvingToggleButton.isSelected()) {
            this.solutionPanel.updatePanel(solution);
            this.validate();
        }
        this.refreshScoreField(score);
    }

    public void init(Component centerForComponent) {
        this.setContentPane(this.createContentPane());
        this.pack();
        this.setLocationRelativeTo(centerForComponent);
    }

    private JComponent createContentPane() {
        JComponent quickOpenPanel = this.createQuickOpenPanel();
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.createToolBar(), "North");
        mainPanel.add((Component)this.createMiddlePanel(), "Center");
        mainPanel.add((Component)this.createScorePanel(), "South");
        JSplitPane splitPane = new JSplitPane(1, quickOpenPanel, mainPanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.2);
        return splitPane;
    }

    private JComponent createQuickOpenPanel() {
        JPanel quickOpenPanel = new JPanel(new BorderLayout());
        JLabel quickOpenLabel = new JLabel("Quick open");
        quickOpenLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        quickOpenPanel.add((Component)quickOpenLabel, "North");
        JSplitPane splitPane = new JSplitPane(0, this.createQuickOpenUnsolvedPanel(), this.createQuickOpenSolvedPanel());
        splitPane.setResizeWeight(0.8);
        splitPane.setBorder(null);
        quickOpenPanel.add((Component)splitPane, "Center");
        return quickOpenPanel;
    }

    private JComponent createQuickOpenUnsolvedPanel() {
        this.quickOpenUnsolvedPanel = new JPanel();
        this.quickOpenUnsolvedActionList = new ArrayList<Action>();
        List<File> unsolvedFileList = this.solutionBusiness.getUnsolvedFileList();
        return this.createQuickOpenPanel(this.quickOpenUnsolvedPanel, "Unsolved dataset", this.quickOpenUnsolvedActionList, unsolvedFileList);
    }

    private JComponent createQuickOpenSolvedPanel() {
        this.quickOpenSolvedPanel = new JPanel();
        this.quickOpenSolvedActionList = new ArrayList<Action>();
        List<File> solvedFileList = this.solutionBusiness.getSolvedFileList();
        return this.createQuickOpenPanel(this.quickOpenSolvedPanel, "Solved dataset", this.quickOpenSolvedActionList, solvedFileList);
    }

    private JComponent createQuickOpenPanel(JPanel panel, String title, List<Action> quickOpenActionList, List<File> fileList) {
        panel.setLayout(new BoxLayout(panel, 1));
        this.refreshQuickOpenPanel(panel, quickOpenActionList, fileList);
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(25);
        scrollPane.setMinimumSize(new Dimension(100, 80));
        scrollPane.setPreferredSize(new Dimension(180, 200));
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.add((Component)scrollPane, "Center");
        titlePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createTitledBorder(title)));
        return titlePanel;
    }

    private void refreshQuickOpenPanel(JPanel panel, List<Action> quickOpenActionList, List<File> fileList) {
        panel.removeAll();
        quickOpenActionList.clear();
        if (fileList.isEmpty()) {
            JLabel noneLabel = new JLabel("None");
            noneLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            panel.add(noneLabel);
        } else {
            for (File file : fileList) {
                QuickOpenAction quickOpenAction = new QuickOpenAction(file);
                quickOpenActionList.add(quickOpenAction);
                JButton quickOpenButton = SwingUtils.makeSmallButton((JButton)new JButton(quickOpenAction));
                quickOpenButton.setHorizontalAlignment(2);
                panel.add(quickOpenButton);
            }
        }
    }

    private JComponent createToolBar() {
        JPanel toolBar = new JPanel();
        GroupLayout toolBarLayout = new GroupLayout(toolBar);
        toolBar.setLayout(toolBarLayout);
        this.importAction = new ImportAction();
        this.importAction.setEnabled(this.solutionBusiness.hasImporter());
        JButton importButton = new JButton(this.importAction);
        this.openAction = new OpenAction();
        this.openAction.setEnabled(true);
        JButton openButton = new JButton(this.openAction);
        this.saveAction = new SaveAction();
        this.saveAction.setEnabled(false);
        JButton saveButton = new JButton(this.saveAction);
        this.exportAction = new ExportAction();
        this.exportAction.setEnabled(false);
        JButton exportButton = new JButton(this.exportAction);
        this.progressBar = new JProgressBar(0, 100);
        JPanel solvePanel = new JPanel(new CardLayout());
        this.solveAction = new SolveAction();
        this.solveAction.setEnabled(false);
        this.solveButton = new JButton(this.solveAction);
        this.terminateSolvingEarlyAction = new TerminateSolvingEarlyAction();
        this.terminateSolvingEarlyAction.setEnabled(false);
        this.terminateSolvingEarlyButton = new JButton(this.terminateSolvingEarlyAction);
        this.terminateSolvingEarlyButton.setVisible(false);
        solvePanel.add((Component)this.solveButton, "solveAction");
        solvePanel.add((Component)this.terminateSolvingEarlyButton, "terminateSolvingEarlyAction");
        this.solveButton.setMinimumSize(this.terminateSolvingEarlyButton.getMinimumSize());
        this.solveButton.setPreferredSize(this.terminateSolvingEarlyButton.getPreferredSize());
        toolBarLayout.setHorizontalGroup(toolBarLayout.createSequentialGroup().addComponent(importButton).addComponent(openButton).addComponent(saveButton).addComponent(exportButton).addGap(10).addComponent(solvePanel, -2, -2, -2).addComponent(this.progressBar, 20, -2, -2));
        toolBarLayout.setVerticalGroup(toolBarLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(importButton).addComponent(openButton).addComponent(saveButton).addComponent(exportButton).addComponent(solvePanel).addComponent(this.progressBar));
        return toolBar;
    }

    private JPanel createMiddlePanel() {
        this.middlePanel = new JPanel(new CardLayout());
        JPanel usageExplanationPanel = new JPanel(new BorderLayout(5, 5));
        ImageIcon usageExplanationIcon = new ImageIcon(this.getClass().getResource(this.solutionPanel.getUsageExplanationPath()));
        JLabel usageExplanationLabel = new JLabel(usageExplanationIcon);
        usageExplanationLabel.setMinimumSize(new Dimension(100, 100));
        usageExplanationPanel.add((Component)usageExplanationLabel, "Center");
        JPanel descriptionPanel = new JPanel(new BorderLayout(2, 2));
        descriptionPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        descriptionPanel.add((Component)new JLabel("Example description"), "North");
        JTextArea descriptionTextArea = new JTextArea(8, 70);
        descriptionTextArea.setEditable(false);
        descriptionTextArea.setText(this.solutionBusiness.getAppDescription());
        descriptionPanel.add((Component)new JScrollPane(descriptionTextArea, 22, 30), "Center");
        usageExplanationPanel.add((Component)descriptionPanel, "South");
        this.middlePanel.add((Component)usageExplanationPanel, "usageExplanationPanel");
        JComponent wrappedSolutionPanel = this.solutionPanel.isWrapInScrollPane() ? new JScrollPane(this.solutionPanel) : this.solutionPanel;
        this.middlePanel.add(wrappedSolutionPanel, "solutionPanel");
        return this.middlePanel;
    }

    private JPanel createScorePanel() {
        JPanel scorePanel = new JPanel(new BorderLayout(5, 0));
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.showConstraintMatchesDialogAction = new ShowConstraintMatchesDialogAction();
        this.showConstraintMatchesDialogAction.setEnabled(false);
        buttonPanel.add(new JButton(this.showConstraintMatchesDialogAction));
        this.indictmentHeatMapToggleButton = new JToggleButton(this.solutionPanel.isUseIndictmentColor() ? this.indictmentHeatMapTrueIcon : this.indictmentHeatMapFalseIcon, this.solutionPanel.isUseIndictmentColor());
        this.indictmentHeatMapToggleButton.setEnabled(false);
        this.indictmentHeatMapToggleButton.setToolTipText("Show indictment heat map");
        this.indictmentHeatMapToggleButton.addActionListener(e -> {
            boolean selected = this.indictmentHeatMapToggleButton.isSelected();
            this.indictmentHeatMapToggleButton.setIcon(selected ? this.indictmentHeatMapTrueIcon : this.indictmentHeatMapFalseIcon);
            this.solutionPanel.setUseIndictmentColor(selected);
            this.resetScreen();
        });
        buttonPanel.add(this.indictmentHeatMapToggleButton);
        scorePanel.add((Component)buttonPanel, "West");
        this.scoreField = new JTextField("Score:");
        this.scoreField.setEditable(false);
        this.scoreField.setForeground(Color.BLACK);
        this.scoreField.setBorder(BorderFactory.createLoweredBevelBorder());
        scorePanel.add((Component)this.scoreField, "Center");
        this.refreshScreenDuringSolvingToggleButton = new JToggleButton(this.refreshScreenDuringSolvingTrueIcon, true);
        this.refreshScreenDuringSolvingToggleButton.setToolTipText("Refresh screen during solving");
        this.refreshScreenDuringSolvingToggleButton.addActionListener(e -> this.refreshScreenDuringSolvingToggleButton.setIcon(this.refreshScreenDuringSolvingToggleButton.isSelected() ? this.refreshScreenDuringSolvingTrueIcon : this.refreshScreenDuringSolvingFalseIcon));
        scorePanel.add((Component)this.refreshScreenDuringSolvingToggleButton, "East");
        return scorePanel;
    }

    private void setSolutionLoaded() {
        this.setTitle(this.solutionBusiness.getAppName() + " - " + this.solutionBusiness.getSolutionFileName());
        ((CardLayout)this.middlePanel.getLayout()).show(this.middlePanel, "solutionPanel");
        this.setSolvingState(false);
        this.resetScreen();
    }

    private void setSolvingState(boolean solving) {
        for (Action action : this.quickOpenUnsolvedActionList) {
            action.setEnabled(!solving);
        }
        for (Action action : this.quickOpenSolvedActionList) {
            action.setEnabled(!solving);
        }
        this.importAction.setEnabled(!solving && this.solutionBusiness.hasImporter());
        this.openAction.setEnabled(!solving);
        this.saveAction.setEnabled(!solving);
        this.exportAction.setEnabled(!solving && this.solutionBusiness.hasExporter());
        this.solveAction.setEnabled(!solving);
        this.solveButton.setVisible(!solving);
        this.terminateSolvingEarlyAction.setEnabled(solving);
        this.terminateSolvingEarlyButton.setVisible(solving);
        if (solving) {
            this.terminateSolvingEarlyButton.requestFocus();
        } else {
            this.solveButton.requestFocus();
        }
        this.solutionPanel.setEnabled(!solving);
        this.progressBar.setIndeterminate(solving);
        this.progressBar.setStringPainted(solving);
        this.progressBar.setString(solving ? "Solving..." : null);
        this.indictmentHeatMapToggleButton.setEnabled(this.solutionPanel.isIndictmentHeatMapEnabled() && !solving);
        this.showConstraintMatchesDialogAction.setEnabled(!solving);
    }

    public void resetScreen() {
        Solution_ solution = this.solutionBusiness.getSolution();
        Score score = this.solutionBusiness.getScore();
        this.solutionPanel.resetPanel(solution);
        this.validate();
        this.refreshScoreField(score);
    }

    public void refreshScoreField(Score score) {
        this.scoreField.setForeground(this.determineScoreFieldForeground(score));
        this.scoreField.setText("Latest best score: " + score);
    }

    private Color determineScoreFieldForeground(Score<?> score) {
        if (!score.isSolutionInitialized()) {
            return TangoColorFactory.SCARLET_3;
        }
        if (!(score instanceof FeasibilityScore)) {
            return Color.BLACK;
        }
        FeasibilityScore feasibilityScore = (FeasibilityScore)score;
        return feasibilityScore.isFeasible() ? TangoColorFactory.CHAMELEON_3 : TangoColorFactory.ORANGE_3;
    }

    private class ShowConstraintMatchesDialogAction
    extends AbstractAction {
        public ShowConstraintMatchesDialogAction() {
            super("Constraint matches", new ImageIcon(SolverAndPersistenceFrame.class.getResource("showConstraintMatchesDialogAction.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SolverAndPersistenceFrame.this.constraintMatchesDialog.resetContentPanel();
            SolverAndPersistenceFrame.this.constraintMatchesDialog.setVisible(true);
        }
    }

    private class ExportAction
    extends AbstractAction {
        private static final String NAME = "Export as...";
        private final JFileChooser fileChooser;

        public ExportAction() {
            super(NAME, new ImageIcon(SolverAndPersistenceFrame.class.getResource("exportAction.png")));
            if (!SolverAndPersistenceFrame.this.solutionBusiness.hasExporter()) {
                this.fileChooser = null;
                return;
            }
            this.fileChooser = new JFileChooser(SolverAndPersistenceFrame.this.solutionBusiness.getExportDataDir());
            this.fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith("." + SolverAndPersistenceFrame.this.solutionBusiness.getExportFileSuffix());
                }

                @Override
                public String getDescription() {
                    return "Export files (*." + SolverAndPersistenceFrame.this.solutionBusiness.getExportFileSuffix() + ")";
                }
            });
            this.fileChooser.setDialogTitle(NAME);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.fileChooser.setSelectedFile(new File(SolverAndPersistenceFrame.this.solutionBusiness.getExportDataDir(), FilenameUtils.getBaseName((String)SolverAndPersistenceFrame.this.solutionBusiness.getSolutionFileName()) + "." + SolverAndPersistenceFrame.this.solutionBusiness.getExportFileSuffix()));
            int approved = this.fileChooser.showSaveDialog(SolverAndPersistenceFrame.this);
            if (approved == 0) {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    SolverAndPersistenceFrame.this.solutionBusiness.exportSolution(this.fileChooser.getSelectedFile());
                }
                finally {
                    SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class ImportAction
    extends AbstractAction {
        private static final String NAME = "Import...";
        private JFileChooser fileChooser;

        public ImportAction() {
            super(NAME, new ImageIcon(SolverAndPersistenceFrame.class.getResource("importAction.png")));
            if (!SolverAndPersistenceFrame.this.solutionBusiness.hasImporter()) {
                this.fileChooser = null;
                return;
            }
            this.fileChooser = new JFileChooser(SolverAndPersistenceFrame.this.solutionBusiness.getImportDataDir());
            boolean firstFilter = true;
            for (final AbstractSolutionImporter importer : SolverAndPersistenceFrame.this.solutionBusiness.getImporters()) {
                FileFilter filter;
                if (importer.isInputFileDirectory()) {
                    filter = new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file.isDirectory();
                        }

                        @Override
                        public String getDescription() {
                            return "Import directory";
                        }
                    };
                    this.fileChooser.setFileSelectionMode(1);
                } else {
                    filter = new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file.isDirectory() || importer.acceptInputFile(file);
                        }

                        @Override
                        public String getDescription() {
                            return "Import files (*." + importer.getInputFileSuffix() + ")";
                        }
                    };
                }
                this.fileChooser.addChoosableFileFilter(filter);
                if (!firstFilter) continue;
                this.fileChooser.setFileFilter(filter);
                firstFilter = false;
            }
            this.fileChooser.setDialogTitle(NAME);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            int approved = this.fileChooser.showOpenDialog(SolverAndPersistenceFrame.this);
            if (approved == 0) {
                File file = this.fileChooser.getSelectedFile();
                SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    SolverAndPersistenceFrame.this.solutionBusiness.importSolution(file);
                    SolverAndPersistenceFrame.this.setSolutionLoaded();
                }
                finally {
                    SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class SaveAction
    extends AbstractAction {
        private static final String NAME = "Save as...";
        private JFileChooser fileChooser;

        public SaveAction() {
            super(NAME, new ImageIcon(SolverAndPersistenceFrame.class.getResource("saveAction.png")));
            this.fileChooser = new JFileChooser(SolverAndPersistenceFrame.this.solutionBusiness.getSolvedDataDir());
            this.fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".xml");
                }

                @Override
                public String getDescription() {
                    return "Solution XStream XML files";
                }
            });
            this.fileChooser.setDialogTitle(NAME);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.fileChooser.setSelectedFile(new File(SolverAndPersistenceFrame.this.solutionBusiness.getSolvedDataDir(), FilenameUtils.getBaseName((String)SolverAndPersistenceFrame.this.solutionBusiness.getSolutionFileName()) + ".xml"));
            int approved = this.fileChooser.showSaveDialog(SolverAndPersistenceFrame.this);
            if (approved == 0) {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    SolverAndPersistenceFrame.this.solutionBusiness.saveSolution(this.fileChooser.getSelectedFile());
                }
                finally {
                    SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
                }
                SolverAndPersistenceFrame.this.refreshQuickOpenPanel(SolverAndPersistenceFrame.this.quickOpenUnsolvedPanel, SolverAndPersistenceFrame.this.quickOpenUnsolvedActionList, SolverAndPersistenceFrame.this.solutionBusiness.getUnsolvedFileList());
                SolverAndPersistenceFrame.this.refreshQuickOpenPanel(SolverAndPersistenceFrame.this.quickOpenSolvedPanel, SolverAndPersistenceFrame.this.quickOpenSolvedActionList, SolverAndPersistenceFrame.this.solutionBusiness.getSolvedFileList());
                SolverAndPersistenceFrame.this.validate();
            }
        }
    }

    private class OpenAction
    extends AbstractAction {
        private static final String NAME = "Open...";
        private JFileChooser fileChooser;

        public OpenAction() {
            super(NAME, new ImageIcon(SolverAndPersistenceFrame.class.getResource("openAction.png")));
            this.fileChooser = new JFileChooser(SolverAndPersistenceFrame.this.solutionBusiness.getSolvedDataDir());
            this.fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".xml");
                }

                @Override
                public String getDescription() {
                    return "Solution XStream XML files";
                }
            });
            this.fileChooser.setDialogTitle(NAME);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int approved = this.fileChooser.showOpenDialog(SolverAndPersistenceFrame.this);
            if (approved == 0) {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    SolverAndPersistenceFrame.this.solutionBusiness.openSolution(this.fileChooser.getSelectedFile());
                    SolverAndPersistenceFrame.this.setSolutionLoaded();
                }
                finally {
                    SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class TerminateSolvingEarlyAction
    extends AbstractAction {
        public TerminateSolvingEarlyAction() {
            super("Terminate solving early", new ImageIcon(SolverAndPersistenceFrame.class.getResource("terminateSolvingEarlyAction.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SolverAndPersistenceFrame.this.terminateSolvingEarlyAction.setEnabled(false);
            SolverAndPersistenceFrame.this.progressBar.setString("Terminating...");
            SolverAndPersistenceFrame.this.solutionBusiness.terminateSolvingEarly();
        }
    }

    protected class SolveWorker
    extends SwingWorker<Solution_, Void> {
        protected final Solution_ problem;

        public SolveWorker(Solution_ problem) {
            this.problem = problem;
        }

        @Override
        protected Solution_ doInBackground() throws Exception {
            return SolverAndPersistenceFrame.this.solutionBusiness.solve(this.problem);
        }

        @Override
        protected void done() {
            try {
                Object bestSolution = this.get();
                SolverAndPersistenceFrame.this.solutionBusiness.setSolution(bestSolution);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Solving was interrupted.", e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Solving failed.", e.getCause());
            }
            finally {
                SolverAndPersistenceFrame.this.setSolvingState(false);
                SolverAndPersistenceFrame.this.resetScreen();
            }
        }
    }

    private class SolveAction
    extends AbstractAction {
        public SolveAction() {
            super("Solve", new ImageIcon(SolverAndPersistenceFrame.class.getResource("solveAction.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SolverAndPersistenceFrame.this.setSolvingState(true);
            Object problem = SolverAndPersistenceFrame.this.solutionBusiness.getSolution();
            new SolveWorker(problem).execute();
        }
    }

    private class QuickOpenAction
    extends AbstractAction {
        private File file;

        public QuickOpenAction(File file) {
            super(file.getName().replaceAll("\\.xml$", ""));
            this.file = file;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                SolverAndPersistenceFrame.this.solutionBusiness.openSolution(this.file);
                SolverAndPersistenceFrame.this.setSolutionLoaded();
            }
            finally {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

