/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.meetingscheduling.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.swingui.components.Labeled;
import org.optaplanner.examples.meetingscheduling.domain.Day;

@XStreamAlias(value="MsTimeGrain")
public class TimeGrain
extends AbstractPersistable
implements Labeled {
    public static final int GRAIN_LENGTH_IN_MINUTES = 15;
    private int grainIndex;
    private Day day;
    private int startingMinuteOfDay;

    public int getGrainIndex() {
        return this.grainIndex;
    }

    public void setGrainIndex(int grainIndex) {
        this.grainIndex = grainIndex;
    }

    public Day getDay() {
        return this.day;
    }

    public void setDay(Day day) {
        this.day = day;
    }

    public int getStartingMinuteOfDay() {
        return this.startingMinuteOfDay;
    }

    public void setStartingMinuteOfDay(int startingMinuteOfDay) {
        this.startingMinuteOfDay = startingMinuteOfDay;
    }

    public String getTimeString() {
        int hourOfDay = this.startingMinuteOfDay / 60;
        int minuteOfHour = this.startingMinuteOfDay % 60;
        return (hourOfDay < 10 ? "0" : "") + hourOfDay + ":" + (minuteOfHour < 10 ? "0" : "") + minuteOfHour;
    }

    public String getDateTimeString() {
        return this.day.getDateString() + " " + this.getTimeString();
    }

    @Override
    public String getLabel() {
        return this.getTimeString();
    }

    @Override
    public String toString() {
        return this.grainIndex + "(" + this.getDateTimeString() + ")";
    }
}

