/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.meetingscheduling.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.optaplanner.examples.common.swingui.CommonIcons;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.components.LabeledComboBoxRenderer;
import org.optaplanner.examples.common.swingui.timetable.TimeTablePanel;
import org.optaplanner.examples.meetingscheduling.domain.Day;
import org.optaplanner.examples.meetingscheduling.domain.MeetingAssignment;
import org.optaplanner.examples.meetingscheduling.domain.MeetingSchedule;
import org.optaplanner.examples.meetingscheduling.domain.Person;
import org.optaplanner.examples.meetingscheduling.domain.PreferredAttendance;
import org.optaplanner.examples.meetingscheduling.domain.RequiredAttendance;
import org.optaplanner.examples.meetingscheduling.domain.Room;
import org.optaplanner.examples.meetingscheduling.domain.TimeGrain;
import org.optaplanner.swing.impl.SwingUtils;
import org.optaplanner.swing.impl.TangoColorFactory;

public class MeetingSchedulingPanel
extends SolutionPanel<MeetingSchedule> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/meetingscheduling/swingui/meetingSchedulingLogo.png";
    private final TimeTablePanel<TimeGrain, Room> roomsPanel;
    private final TimeTablePanel<TimeGrain, Pair<Person, Boolean>> personsPanel;
    private final OvertimeTimeGrain OVERTIME_TIME_GRAIN = new OvertimeTimeGrain();

    public MeetingSchedulingPanel() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        this.roomsPanel = new TimeTablePanel();
        tabbedPane.add("Rooms", new JScrollPane(this.roomsPanel));
        this.personsPanel = new TimeTablePanel();
        tabbedPane.add("Persons", new JScrollPane(this.personsPanel));
        this.add((Component)tabbedPane, "Center");
        this.setPreferredSize(PREFERRED_SCROLLABLE_VIEWPORT_SIZE);
    }

    @Override
    public boolean isWrapInScrollPane() {
        return false;
    }

    @Override
    public void resetPanel(MeetingSchedule meetingSchedule) {
        this.roomsPanel.reset();
        this.personsPanel.reset();
        this.defineGrid(meetingSchedule);
        this.fillCells(meetingSchedule);
        this.repaint();
    }

    private void defineGrid(MeetingSchedule meetingSchedule) {
        this.roomsPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN);
        this.personsPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1);
        this.personsPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN);
        for (TimeGrain timeGrain : meetingSchedule.getTimeGrainList()) {
            this.roomsPanel.defineColumnHeader(timeGrain);
            this.personsPanel.defineColumnHeader(timeGrain);
        }
        this.roomsPanel.defineColumnHeader(this.OVERTIME_TIME_GRAIN);
        this.personsPanel.defineColumnHeader(this.OVERTIME_TIME_GRAIN);
        this.roomsPanel.defineColumnHeader(null);
        this.personsPanel.defineColumnHeader(null);
        this.roomsPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW_GROUP1);
        this.roomsPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW);
        for (Room room : meetingSchedule.getRoomList()) {
            this.roomsPanel.defineRowHeader(room);
        }
        this.roomsPanel.defineRowHeader(null);
        this.personsPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW_GROUP1);
        this.personsPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW);
        for (Person person : meetingSchedule.getPersonList()) {
            this.personsPanel.defineRowHeader((Pair<Person, Boolean>)Pair.of((Object)person, (Object)Boolean.TRUE));
            this.personsPanel.defineRowHeader((Pair<Person, Boolean>)Pair.of((Object)person, (Object)Boolean.FALSE));
        }
    }

    private void fillCells(MeetingSchedule meetingSchedule) {
        this.roomsPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Room")));
        this.fillRoomCells(meetingSchedule);
        this.personsPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Person")));
        this.personsPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Attendance")));
        this.fillPersonCells(meetingSchedule);
        this.fillTimeGrainCells(meetingSchedule);
        this.fillMeetingAssignmentCells(meetingSchedule);
    }

    private void fillRoomCells(MeetingSchedule meetingSchedule) {
        for (Room room : meetingSchedule.getRoomList()) {
            this.roomsPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, room, this.createTableHeader(new JLabel(room.getLabel(), 0)));
        }
        this.roomsPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, null, this.createTableHeader(new JLabel("Unassigned", 0)));
    }

    private void fillPersonCells(MeetingSchedule meetingSchedule) {
        for (Person person : meetingSchedule.getPersonList()) {
            this.personsPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, (Pair<Person, Boolean>)Pair.of((Object)person, (Object)Boolean.TRUE), TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, (Pair<Person, Boolean>)Pair.of((Object)person, (Object)Boolean.FALSE), this.createTableHeader(new JLabel(person.getLabel(), 0)));
            this.personsPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, (Pair<Person, Boolean>)Pair.of((Object)person, (Object)Boolean.TRUE), this.createTableHeader(new JLabel("Required", 0)));
            this.personsPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, (Pair<Person, Boolean>)Pair.of((Object)person, (Object)Boolean.FALSE), this.createTableHeader(new JLabel("Preferred", 0)));
        }
    }

    private void fillTimeGrainCells(MeetingSchedule meetingSchedule) {
        HashMap<Day, TimeGrain> firstTimeGrainMap = new HashMap<Day, TimeGrain>(meetingSchedule.getDayList().size());
        HashMap<Day, TimeGrain> lastTimeGrainMap = new HashMap<Day, TimeGrain>(meetingSchedule.getDayList().size());
        for (TimeGrain timeGrain : meetingSchedule.getTimeGrainList()) {
            TimeGrain lastTimeGrain;
            Day day = timeGrain.getDay();
            TimeGrain firstTimeGrain = (TimeGrain)firstTimeGrainMap.get(day);
            if (firstTimeGrain == null || firstTimeGrain.getGrainIndex() > timeGrain.getGrainIndex()) {
                firstTimeGrainMap.put(day, timeGrain);
            }
            if ((lastTimeGrain = (TimeGrain)lastTimeGrainMap.get(day)) == null || lastTimeGrain.getGrainIndex() < timeGrain.getGrainIndex()) {
                lastTimeGrainMap.put(day, timeGrain);
            }
            this.roomsPanel.addColumnHeader(timeGrain, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel(timeGrain.getLabel())));
            this.personsPanel.addColumnHeader(timeGrain, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel(timeGrain.getLabel())));
        }
        this.roomsPanel.addColumnHeader(this.OVERTIME_TIME_GRAIN, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Overtime")));
        this.personsPanel.addColumnHeader(this.OVERTIME_TIME_GRAIN, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Overtime")));
        this.roomsPanel.addColumnHeader(null, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Unassigned")));
        this.personsPanel.addColumnHeader(null, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Unassigned")));
        for (Day day : meetingSchedule.getDayList()) {
            TimeGrain firstTimeGrain = (TimeGrain)firstTimeGrainMap.get(day);
            TimeGrain lastTimeGrain = (TimeGrain)lastTimeGrainMap.get(day);
            this.roomsPanel.addColumnHeader(firstTimeGrain, TimeTablePanel.HeaderRowKey.HEADER_ROW_GROUP1, lastTimeGrain, TimeTablePanel.HeaderRowKey.HEADER_ROW_GROUP1, this.createTableHeader(new JLabel(day.getLabel())));
            this.personsPanel.addColumnHeader(firstTimeGrain, TimeTablePanel.HeaderRowKey.HEADER_ROW_GROUP1, lastTimeGrain, TimeTablePanel.HeaderRowKey.HEADER_ROW_GROUP1, this.createTableHeader(new JLabel(day.getLabel())));
        }
    }

    private void fillMeetingAssignmentCells(MeetingSchedule meetingSchedule) {
        TangoColorFactory tangoColorFactory = new TangoColorFactory();
        for (MeetingAssignment meetingAssignment : meetingSchedule.getMeetingAssignmentList()) {
            Pair pair;
            TimeGrain lastTimeGrain;
            Color color = tangoColorFactory.pickColor((Object)meetingAssignment.getMeeting());
            TimeGrain startingTimeGrain = meetingAssignment.getStartingTimeGrain();
            if (startingTimeGrain == null) {
                lastTimeGrain = null;
            } else {
                int lastTimeGrainIndex = meetingAssignment.getLastTimeGrainIndex();
                List<TimeGrain> timeGrainList = meetingSchedule.getTimeGrainList();
                lastTimeGrain = lastTimeGrainIndex < meetingSchedule.getTimeGrainList().size() ? timeGrainList.get(lastTimeGrainIndex) : this.OVERTIME_TIME_GRAIN;
            }
            this.roomsPanel.addCell(startingTimeGrain, meetingAssignment.getRoom(), lastTimeGrain, meetingAssignment.getRoom(), this.createButton(meetingAssignment, color));
            for (RequiredAttendance requiredAttendance : meetingAssignment.getMeeting().getRequiredAttendanceList()) {
                pair = Pair.of((Object)requiredAttendance.getPerson(), (Object)Boolean.TRUE);
                this.personsPanel.addCell(startingTimeGrain, (Pair<Person, Boolean>)pair, lastTimeGrain, (Pair<Person, Boolean>)pair, this.createButton(meetingAssignment, color));
            }
            for (PreferredAttendance preferredAttendance : meetingAssignment.getMeeting().getPreferredAttendanceList()) {
                pair = Pair.of((Object)preferredAttendance.getPerson(), (Object)Boolean.FALSE);
                this.personsPanel.addCell(startingTimeGrain, (Pair<Person, Boolean>)pair, lastTimeGrain, (Pair<Person, Boolean>)pair, this.createButton(meetingAssignment, color));
            }
        }
    }

    private JPanel createTableHeader(JLabel label) {
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add((Component)label, "North");
        headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(TangoColorFactory.ALUMINIUM_5), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        return headerPanel;
    }

    private JButton createButton(MeetingAssignment meetingAssignment, Color color) {
        JButton button = SwingUtils.makeSmallButton((JButton)new JButton(new MeetingAssignmentAction(meetingAssignment)));
        button.setBackground(color);
        if (meetingAssignment.isPinned()) {
            button.setIcon(CommonIcons.PINNED_ICON);
        }
        return button;
    }

    private static final class OvertimeTimeGrain
    extends TimeGrain {
        private OvertimeTimeGrain() {
            this.setGrainIndex(-1);
            this.setDay(null);
            this.setStartingMinuteOfDay(-1);
        }

        @Override
        public String getDateTimeString() {
            return "Overtime";
        }
    }

    private class MeetingAssignmentAction
    extends AbstractAction {
        private MeetingAssignment meetingAssignment;

        public MeetingAssignmentAction(MeetingAssignment meetingAssignment) {
            super(meetingAssignment.getLabel());
            this.putValue("ShortDescription", "<html>Topic: " + meetingAssignment.getMeeting().getTopic() + "<br/>Date and time: " + (String)ObjectUtils.defaultIfNull((Object)meetingAssignment.getStartingDateTimeString(), (Object)"unassigned") + "<br/>Duration: " + meetingAssignment.getMeeting().getDurationString() + "<br/>Room: " + ObjectUtils.defaultIfNull((Object)meetingAssignment.getRoom(), (Object)"unassigned") + "</html>");
            this.meetingAssignment = meetingAssignment;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel listFieldsPanel = new JPanel(new GridLayout(3, 2));
            listFieldsPanel.add(new JLabel("Starting time grain:"));
            MeetingSchedule meetingSchedule = (MeetingSchedule)MeetingSchedulingPanel.this.getSolution();
            List<TimeGrain> timeGrainList = meetingSchedule.getTimeGrainList();
            JComboBox<Object> timeGrainListField = new JComboBox<Object>(timeGrainList.toArray(new Object[timeGrainList.size() + 1]));
            LabeledComboBoxRenderer.applyToComboBox(timeGrainListField);
            timeGrainListField.setSelectedItem(this.meetingAssignment.getStartingTimeGrain());
            listFieldsPanel.add(timeGrainListField);
            listFieldsPanel.add(new JLabel("Room:"));
            List<Room> roomList = meetingSchedule.getRoomList();
            JComboBox<Object> roomListField = new JComboBox<Object>(roomList.toArray(new Object[roomList.size() + 1]));
            LabeledComboBoxRenderer.applyToComboBox(roomListField);
            roomListField.setSelectedItem(this.meetingAssignment.getRoom());
            listFieldsPanel.add(roomListField);
            listFieldsPanel.add(new JLabel("Pinned:"));
            JCheckBox pinnedField = new JCheckBox("can not move during solving");
            pinnedField.setSelected(this.meetingAssignment.isPinned());
            listFieldsPanel.add(pinnedField);
            int result = JOptionPane.showConfirmDialog(MeetingSchedulingPanel.this.getRootPane(), listFieldsPanel, "Select time grain and room", 2);
            if (result == 0) {
                TimeGrain toStartingTimeGrain = (TimeGrain)timeGrainListField.getSelectedItem();
                if (this.meetingAssignment.getStartingTimeGrain() != toStartingTimeGrain) {
                    MeetingSchedulingPanel.this.solutionBusiness.doChangeMove(this.meetingAssignment, "startingTimeGrain", toStartingTimeGrain);
                }
                Room toRoom = (Room)roomListField.getSelectedItem();
                if (this.meetingAssignment.getRoom() != toRoom) {
                    MeetingSchedulingPanel.this.solutionBusiness.doChangeMove(this.meetingAssignment, "room", toRoom);
                }
                boolean toPinned = pinnedField.isSelected();
                if (this.meetingAssignment.isPinned() != toPinned) {
                    if (MeetingSchedulingPanel.this.solutionBusiness.isSolving()) {
                        MeetingSchedulingPanel.this.logger.error("Not doing user change because the solver is solving.");
                        return;
                    }
                    this.meetingAssignment.setPinned(toPinned);
                }
                MeetingSchedulingPanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }
}

