/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.taskassigning.solver.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.examples.taskassigning.domain.Priority;
import org.optaplanner.examples.taskassigning.domain.Task;

public final class TaskAssigningConstraintProvider
implements ConstraintProvider {
    private static final int BENDABLE_SCORE_HARD_LEVELS_SIZE = 1;
    private static final int BENDABLE_SCORE_SOFT_LEVELS_SIZE = 4;

    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.noMissingSkills(constraintFactory), this.minimizeMakespan(constraintFactory), this.criticalPriorityBasedTaskEndTime(constraintFactory), this.majorPriorityTaskEndTime(constraintFactory), this.minorPriorityTaskEndTime(constraintFactory)};
    }

    private UniConstraintStream<Task> getTaskWithPriority(ConstraintFactory constraintFactory, Priority priority) {
        return constraintFactory.from(Task.class).filter(task -> task.getPriority() == priority);
    }

    private Constraint noMissingSkills(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Task.class).filter(task -> task.getMissingSkillCount() > 0).penalize("No missing skills", (Score)BendableScore.ofHard((int)1, (int)4, (int)0, (int)1), Task::getMissingSkillCount);
    }

    private Constraint criticalPriorityBasedTaskEndTime(ConstraintFactory constraintFactory) {
        return this.getTaskWithPriority(constraintFactory, Priority.CRITICAL).penalize("Critical priority task end time", (Score)BendableScore.ofSoft((int)1, (int)4, (int)0, (int)1), Task::getEndTime);
    }

    private Constraint minimizeMakespan(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Task.class).filter(task -> task.getNextTask() == null).penalize("Minimize makespan, latest ending employee first", (Score)BendableScore.ofSoft((int)1, (int)4, (int)1, (int)1), task -> task.getEndTime() * task.getEndTime());
    }

    private Constraint majorPriorityTaskEndTime(ConstraintFactory constraintFactory) {
        return this.getTaskWithPriority(constraintFactory, Priority.MAJOR).penalize("Major priority task end time", (Score)BendableScore.ofSoft((int)1, (int)4, (int)2, (int)1), Task::getEndTime);
    }

    private Constraint minorPriorityTaskEndTime(ConstraintFactory constraintFactory) {
        return this.getTaskWithPriority(constraintFactory, Priority.MINOR).penalize("Minor priority task end time", (Score)BendableScore.ofSoft((int)1, (int)4, (int)3, (int)1), Task::getEndTime);
    }
}

