/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.scrabble.persistence;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionConverter;
import org.optaplanner.examples.scrabble.domain.ScrabbleCell;
import org.optaplanner.examples.scrabble.domain.ScrabbleSolution;
import org.optaplanner.examples.scrabble.domain.ScrabbleWordAssignment;

public class ScrabbleImporter
extends AbstractTxtSolutionImporter<ScrabbleSolution> {
    public static void main(String[] args) {
        SolutionConverter<ScrabbleSolution> converter = SolutionConverter.createImportConverter("scrabble", new ScrabbleImporter(), ScrabbleSolution.class);
        converter.convert("jbossProjects.txt", "jbossProjects.xml");
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder<ScrabbleSolution> createTxtInputBuilder() {
        return new ScrabbleInputBuilder();
    }

    public static class ScrabbleInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder<ScrabbleSolution> {
        private ScrabbleSolution solution;
        private Locale locale;

        @Override
        public ScrabbleSolution readSolution() throws IOException {
            this.solution = new ScrabbleSolution();
            this.solution.setId(0L);
            this.locale = Locale.forLanguageTag(this.readStringValue("locale:"));
            this.readCellList();
            this.readWordList();
            BigInteger possibleSolutionSize = BigInteger.valueOf(this.solution.getCellList().size()).pow(this.solution.getWordList().size());
            this.logger.info("ScrabbleSolution {} has {} words and {} cells with a search space of {}.", new Object[]{this.getInputId(), this.solution.getWordList().size(), this.solution.getCellList().size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
            return this.solution;
        }

        private void readCellList() throws IOException {
            int gridWidth = this.readIntegerValue("gridWidth:");
            this.solution.setGridWidth(gridWidth);
            int gridHeight = this.readIntegerValue("gridHeight:");
            this.solution.setGridHeight(gridHeight);
            ArrayList<ScrabbleCell> cellList = new ArrayList<ScrabbleCell>(gridWidth * gridHeight);
            for (int x = 0; x < gridWidth; ++x) {
                for (int y = 0; y < gridHeight; ++y) {
                    ScrabbleCell cell = new ScrabbleCell();
                    cell.setId(Long.valueOf(y * gridWidth + x));
                    cell.setX(x);
                    cell.setY(y);
                    cell.setWordSet(new LinkedHashSet<ScrabbleWordAssignment>());
                    cell.setCharacterCountMap(new LinkedHashMap<Character, Integer>());
                    cellList.add(cell);
                }
            }
            this.solution.setCellList(cellList);
        }

        private void readWordList() throws IOException {
            this.readConstantLine("# Words");
            ArrayList<ScrabbleWordAssignment> wordList = new ArrayList<ScrabbleWordAssignment>();
            String line = this.bufferedReader.readLine();
            long wordId = 0L;
            while (line != null) {
                String word = line.trim();
                if (!word.isEmpty()) {
                    ScrabbleWordAssignment wordAssignment = new ScrabbleWordAssignment();
                    wordAssignment.setId(wordId);
                    ++wordId;
                    wordAssignment.setSolution(this.solution);
                    wordAssignment.setWord(" " + word.toUpperCase(this.locale) + " ");
                    wordList.add(wordAssignment);
                }
                line = this.bufferedReader.readLine();
            }
            this.solution.setWordList(wordList);
        }
    }
}

