/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.pas.domain.Night;
import org.optaplanner.examples.pas.domain.Patient;
import org.optaplanner.examples.pas.domain.Specialism;

@XStreamAlias(value="AdmissionPart")
public class AdmissionPart
extends AbstractPersistable {
    private Patient patient;
    private Night firstNight;
    private Night lastNight;
    private Specialism specialism;

    public Patient getPatient() {
        return this.patient;
    }

    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    public Night getFirstNight() {
        return this.firstNight;
    }

    public void setFirstNight(Night firstNight) {
        this.firstNight = firstNight;
    }

    public Night getLastNight() {
        return this.lastNight;
    }

    public void setLastNight(Night lastNight) {
        this.lastNight = lastNight;
    }

    public Specialism getSpecialism() {
        return this.specialism;
    }

    public void setSpecialism(Specialism specialism) {
        this.specialism = specialism;
    }

    public int getNightCount() {
        return this.lastNight.getIndex() - this.firstNight.getIndex() + 1;
    }

    public int calculateSameNightCount(AdmissionPart other) {
        int firstNightIndex = Math.max(this.getFirstNight().getIndex(), other.getFirstNight().getIndex());
        int lastNightIndex = Math.min(this.getLastNight().getIndex(), other.getLastNight().getIndex());
        return Math.max(0, lastNightIndex - firstNightIndex + 1);
    }

    @Override
    public String toString() {
        return this.patient + "(" + this.firstNight + "-" + this.lastNight + ")";
    }
}

