/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.domain;

import java.util.List;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.drools.ProblemFactCollectionProperty;
import org.optaplanner.core.api.domain.solution.drools.ProblemFactProperty;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceParametrization;
import org.optaplanner.examples.conferencescheduling.domain.Room;
import org.optaplanner.examples.conferencescheduling.domain.Speaker;
import org.optaplanner.examples.conferencescheduling.domain.Talk;
import org.optaplanner.examples.conferencescheduling.domain.Timeslot;

@PlanningSolution
public class ConferenceSolution
extends AbstractPersistable {
    private String conferenceName;
    @ProblemFactProperty
    private ConferenceParametrization parametrization;
    @ValueRangeProvider(id="timeslotRange")
    @ProblemFactCollectionProperty
    private List<Timeslot> timeslotList;
    @ValueRangeProvider(id="roomRange")
    @ProblemFactCollectionProperty
    private List<Room> roomList;
    @ProblemFactCollectionProperty
    private List<Speaker> speakerList;
    @PlanningEntityCollectionProperty
    private List<Talk> talkList;
    @PlanningScore
    private HardSoftScore score = null;

    public ConferenceSolution() {
    }

    public ConferenceSolution(long id) {
        super(id);
    }

    @Override
    public String toString() {
        return this.conferenceName;
    }

    public String getConferenceName() {
        return this.conferenceName;
    }

    public void setConferenceName(String conferenceName) {
        this.conferenceName = conferenceName;
    }

    public ConferenceParametrization getParametrization() {
        return this.parametrization;
    }

    public void setParametrization(ConferenceParametrization parametrization) {
        this.parametrization = parametrization;
    }

    public List<Timeslot> getTimeslotList() {
        return this.timeslotList;
    }

    public void setTimeslotList(List<Timeslot> timeslotList) {
        this.timeslotList = timeslotList;
    }

    public List<Room> getRoomList() {
        return this.roomList;
    }

    public void setRoomList(List<Room> roomList) {
        this.roomList = roomList;
    }

    public List<Speaker> getSpeakerList() {
        return this.speakerList;
    }

    public void setSpeakerList(List<Speaker> speakerList) {
        this.speakerList = speakerList;
    }

    public List<Talk> getTalkList() {
        return this.talkList;
    }

    public void setTalkList(List<Talk> talkList) {
        this.talkList = talkList;
    }

    public HardSoftScore getScore() {
        return this.score;
    }

    public void setScore(HardSoftScore score) {
        this.score = score;
    }

    public ConferenceSolution withTalkList(List<Talk> talkList) {
        this.talkList = talkList;
        return this;
    }

    public ConferenceSolution withTimeslotList(List<Timeslot> timeslotList) {
        this.timeslotList = timeslotList;
        return this;
    }

    public ConferenceSolution withRoomList(List<Room> roomList) {
        this.roomList = roomList;
        return this;
    }

    public ConferenceSolution withSpeakerList(List<Speaker> speakerList) {
        this.speakerList = speakerList;
        return this;
    }

    public ConferenceSolution withParametrization(ConferenceParametrization parametrization) {
        this.parametrization = parametrization;
        return this;
    }
}

