/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.domain;

import java.util.List;
import java.util.Set;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.conferencescheduling.domain.Room;
import org.optaplanner.examples.conferencescheduling.domain.Speaker;
import org.optaplanner.examples.conferencescheduling.domain.Timeslot;
import org.optaplanner.examples.conferencescheduling.domain.solver.MovableTalkFilter;

@PlanningEntity(movableEntitySelectionFilter=MovableTalkFilter.class)
public class Talk
extends AbstractPersistable {
    private String code;
    private String title;
    private String talkType;
    private Set<String> themeTagSet;
    private Set<String> sectorTagSet;
    private String language;
    private List<Speaker> speakerList;
    private Set<String> requiredTimeslotTagSet;
    private Set<String> preferredTimeslotTagSet;
    private Set<String> prohibitedTimeslotTagSet;
    private Set<String> undesiredTimeslotTagSet;
    private Set<String> requiredRoomTagSet;
    private Set<String> preferredRoomTagSet;
    private Set<String> prohibitedRoomTagSet;
    private Set<String> undesiredRoomTagSet;
    private boolean pinnedByUser = false;
    @PlanningVariable(valueRangeProviderRefs={"timeslotRange"})
    private Timeslot timeslot;
    @PlanningVariable(valueRangeProviderRefs={"roomRange"})
    private Room room;

    public Talk() {
    }

    public Talk(long id) {
        super(id);
    }

    public boolean hasUnavailableRoom() {
        if (this.timeslot == null || this.room == null) {
            return false;
        }
        return this.room.getUnavailableTimeslotSet().contains(this.timeslot);
    }

    public int overlappingThemeCount(Talk other) {
        return (int)this.themeTagSet.stream().filter(tag -> other.themeTagSet.contains(tag)).count();
    }

    public int overlappingSectorCount(Talk other) {
        return (int)this.sectorTagSet.stream().filter(tag -> other.sectorTagSet.contains(tag)).count();
    }

    public boolean hasSpeaker(Speaker speaker) {
        return this.speakerList.contains(speaker);
    }

    public boolean hasAnyUnavailableSpeaker() {
        if (this.timeslot == null) {
            return false;
        }
        for (Speaker speaker : this.speakerList) {
            if (!speaker.getUnavailableTimeslotSet().contains(this.timeslot)) continue;
            return true;
        }
        return false;
    }

    public int missingRequiredTimeslotTagCount() {
        if (this.timeslot == null) {
            return 0;
        }
        return (int)this.requiredTimeslotTagSet.stream().filter(tag -> !this.timeslot.hasTag((String)tag)).count();
    }

    public int missingPreferredTimeslotTagCount() {
        if (this.timeslot == null) {
            return 0;
        }
        return (int)this.preferredTimeslotTagSet.stream().filter(tag -> !this.timeslot.hasTag((String)tag)).count();
    }

    public int prevailingProhibitedTimeslotTagCount() {
        if (this.timeslot == null) {
            return 0;
        }
        return (int)this.prohibitedTimeslotTagSet.stream().filter(tag -> this.timeslot.hasTag((String)tag)).count();
    }

    public int prevailingUndesiredTimeslotTagCount() {
        if (this.timeslot == null) {
            return 0;
        }
        return (int)this.undesiredTimeslotTagSet.stream().filter(tag -> this.timeslot.hasTag((String)tag)).count();
    }

    public int missingRequiredRoomTagCount() {
        if (this.room == null) {
            return 0;
        }
        return (int)this.requiredRoomTagSet.stream().filter(tag -> !this.room.hasTag((String)tag)).count();
    }

    public int missingPreferredRoomTagCount() {
        if (this.room == null) {
            return 0;
        }
        return (int)this.preferredRoomTagSet.stream().filter(tag -> !this.room.hasTag((String)tag)).count();
    }

    public int prevailingProhibitedRoomTagCount() {
        if (this.room == null) {
            return 0;
        }
        return (int)this.prohibitedRoomTagSet.stream().filter(tag -> this.room.hasTag((String)tag)).count();
    }

    public int prevailingUndesiredRoomTagCount() {
        if (this.room == null) {
            return 0;
        }
        return (int)this.undesiredRoomTagSet.stream().filter(tag -> this.room.hasTag((String)tag)).count();
    }

    public int missingSpeakerRequiredTimeslotTagCount() {
        if (this.timeslot == null) {
            return 0;
        }
        return (int)this.speakerList.stream().flatMap(speaker -> speaker.getRequiredTimeslotTagSet().stream()).filter(tag -> !this.timeslot.hasTag((String)tag)).count();
    }

    public int missingSpeakerPreferredTimeslotTagCount() {
        if (this.timeslot == null) {
            return 0;
        }
        return (int)this.speakerList.stream().flatMap(speaker -> speaker.getPreferredTimeslotTagSet().stream()).filter(tag -> !this.timeslot.hasTag((String)tag)).count();
    }

    public int prevailingSpeakerProhibitedTimeslotTagCount() {
        if (this.timeslot == null) {
            return 0;
        }
        return (int)this.speakerList.stream().flatMap(speaker -> speaker.getProhibitedTimeslotTagSet().stream()).filter(tag -> this.timeslot.hasTag((String)tag)).count();
    }

    public int prevailingSpeakerUndesiredTimeslotTagCount() {
        if (this.timeslot == null) {
            return 0;
        }
        return (int)this.speakerList.stream().flatMap(speaker -> speaker.getUndesiredTimeslotTagSet().stream()).filter(tag -> this.timeslot.hasTag((String)tag)).count();
    }

    public int missingSpeakerRequiredRoomTagCount() {
        if (this.room == null) {
            return 0;
        }
        return (int)this.speakerList.stream().flatMap(speaker -> speaker.getRequiredRoomTagSet().stream()).filter(tag -> !this.room.hasTag((String)tag)).count();
    }

    public int missingSpeakerPreferredRoomTagCount() {
        if (this.room == null) {
            return 0;
        }
        return (int)this.speakerList.stream().flatMap(speaker -> speaker.getPreferredRoomTagSet().stream()).filter(tag -> !this.room.hasTag((String)tag)).count();
    }

    public int prevailingSpeakerProhibitedRoomTagCount() {
        if (this.room == null) {
            return 0;
        }
        return (int)this.speakerList.stream().flatMap(speaker -> speaker.getProhibitedRoomTagSet().stream()).filter(tag -> this.room.hasTag((String)tag)).count();
    }

    public int prevailingSpeakerUndesiredRoomTagCount() {
        if (this.room == null) {
            return 0;
        }
        return (int)this.speakerList.stream().flatMap(speaker -> speaker.getUndesiredRoomTagSet().stream()).filter(tag -> this.room.hasTag((String)tag)).count();
    }

    @Override
    public String toString() {
        return this.code;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTalkType() {
        return this.talkType;
    }

    public void setTalkType(String talkType) {
        this.talkType = talkType;
    }

    public Set<String> getThemeTagSet() {
        return this.themeTagSet;
    }

    public void setThemeTagSet(Set<String> themeTagSet) {
        this.themeTagSet = themeTagSet;
    }

    public Set<String> getSectorTagSet() {
        return this.sectorTagSet;
    }

    public void setSectorTagSet(Set<String> sectorTagSet) {
        this.sectorTagSet = sectorTagSet;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<Speaker> getSpeakerList() {
        return this.speakerList;
    }

    public void setSpeakerList(List<Speaker> speakerList) {
        this.speakerList = speakerList;
    }

    public Set<String> getRequiredTimeslotTagSet() {
        return this.requiredTimeslotTagSet;
    }

    public void setRequiredTimeslotTagSet(Set<String> requiredTimeslotTagSet) {
        this.requiredTimeslotTagSet = requiredTimeslotTagSet;
    }

    public Set<String> getPreferredTimeslotTagSet() {
        return this.preferredTimeslotTagSet;
    }

    public void setPreferredTimeslotTagSet(Set<String> preferredTimeslotTagSet) {
        this.preferredTimeslotTagSet = preferredTimeslotTagSet;
    }

    public Set<String> getProhibitedTimeslotTagSet() {
        return this.prohibitedTimeslotTagSet;
    }

    public void setProhibitedTimeslotTagSet(Set<String> prohibitedTimeslotTagSet) {
        this.prohibitedTimeslotTagSet = prohibitedTimeslotTagSet;
    }

    public Set<String> getUndesiredTimeslotTagSet() {
        return this.undesiredTimeslotTagSet;
    }

    public void setUndesiredTimeslotTagSet(Set<String> undesiredTimeslotTagSet) {
        this.undesiredTimeslotTagSet = undesiredTimeslotTagSet;
    }

    public Set<String> getRequiredRoomTagSet() {
        return this.requiredRoomTagSet;
    }

    public void setRequiredRoomTagSet(Set<String> requiredRoomTagSet) {
        this.requiredRoomTagSet = requiredRoomTagSet;
    }

    public Set<String> getPreferredRoomTagSet() {
        return this.preferredRoomTagSet;
    }

    public void setPreferredRoomTagSet(Set<String> preferredRoomTagSet) {
        this.preferredRoomTagSet = preferredRoomTagSet;
    }

    public Set<String> getProhibitedRoomTagSet() {
        return this.prohibitedRoomTagSet;
    }

    public void setProhibitedRoomTagSet(Set<String> prohibitedRoomTagSet) {
        this.prohibitedRoomTagSet = prohibitedRoomTagSet;
    }

    public Set<String> getUndesiredRoomTagSet() {
        return this.undesiredRoomTagSet;
    }

    public void setUndesiredRoomTagSet(Set<String> undesiredRoomTagSet) {
        this.undesiredRoomTagSet = undesiredRoomTagSet;
    }

    public boolean isPinnedByUser() {
        return this.pinnedByUser;
    }

    public void setPinnedByUser(boolean pinnedByUser) {
        this.pinnedByUser = pinnedByUser;
    }

    public Timeslot getTimeslot() {
        return this.timeslot;
    }

    public void setTimeslot(Timeslot timeslot) {
        this.timeslot = timeslot;
    }

    public Room getRoom() {
        return this.room;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    public Talk withTalkType(String talkType) {
        this.talkType = talkType;
        return this;
    }

    public Talk withTimeslot(Timeslot timeSlot) {
        this.timeslot = timeSlot;
        return this;
    }

    public Talk withRoom(Room room) {
        this.room = room;
        return this;
    }

    public Talk withLanguage(String language) {
        this.language = language;
        return this;
    }

    public Talk withSpeakerList(List<Speaker> speakerList) {
        this.speakerList = speakerList;
        return this;
    }

    public Talk withRequiredRoomTagSet(Set<String> requiredRoomTagSet) {
        this.requiredRoomTagSet = requiredRoomTagSet;
        return this;
    }

    public Talk withPreferredRoomTagSet(Set<String> preferredRoomTagSet) {
        this.preferredRoomTagSet = preferredRoomTagSet;
        return this;
    }

    public Talk withProhibitedRoomTagSet(Set<String> prohibitedRoomTagSet) {
        this.prohibitedRoomTagSet = prohibitedRoomTagSet;
        return this;
    }

    public Talk withUndesiredRoomTagSet(Set<String> undesiredRoomTagSet) {
        this.undesiredRoomTagSet = undesiredRoomTagSet;
        return this;
    }

    public Talk withRequiredTimeslotTagSet(Set<String> requiredTimeslotTagSet) {
        this.requiredTimeslotTagSet = requiredTimeslotTagSet;
        return this;
    }

    public Talk withProhibitedTimeslotTagSet(Set<String> prohibitedTimeslotTagSet) {
        this.prohibitedTimeslotTagSet = prohibitedTimeslotTagSet;
        return this;
    }

    public Talk withPreferredTimeslotTagSet(Set<String> preferredTimslotTagSet) {
        this.preferredTimeslotTagSet = preferredTimslotTagSet;
        return this;
    }

    public Talk withUndesiredTimeslotTagSet(Set<String> undesiredTimeslotTagSet) {
        this.undesiredTimeslotTagSet = undesiredTimeslotTagSet;
        return this;
    }

    public Talk withThemeTagSet(Set<String> themeTagSet) {
        this.themeTagSet = themeTagSet;
        return this;
    }

    public Talk withSectorTagSet(Set<String> sectorTagSet) {
        this.sectorTagSet = sectorTagSet;
        return this;
    }
}

