/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.solver.score;

import java.util.HashMap;
import java.util.List;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.calculator.EasyScoreCalculator;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.examples.nqueens.domain.Queen;

public class NQueensMapBasedEasyScoreCalculator
implements EasyScoreCalculator<NQueens, SimpleScore> {
    public SimpleScore calculateScore(NQueens nQueens) {
        int n = nQueens.getN();
        List<Queen> queenList = nQueens.getQueenList();
        HashMap<Integer, Integer> rowIndexCountMap = new HashMap<Integer, Integer>(n);
        HashMap<Integer, Integer> ascendingDiagonalIndexCountMap = new HashMap<Integer, Integer>(n);
        HashMap<Integer, Integer> descendingDiagonalIndexCountMap = new HashMap<Integer, Integer>(n);
        int score = 0;
        for (Queen queen : queenList) {
            if (queen.getRow() == null) continue;
            int rowIndex = queen.getRowIndex();
            Integer rowIndexCount = (Integer)rowIndexCountMap.get(rowIndex);
            if (rowIndexCount != null) {
                score -= rowIndexCount.intValue();
                Integer n2 = rowIndexCount;
                Integer n3 = rowIndexCount = Integer.valueOf(rowIndexCount + 1);
            } else {
                rowIndexCount = 1;
            }
            rowIndexCountMap.put(rowIndex, rowIndexCount);
            int ascendingDiagonalIndex = queen.getAscendingDiagonalIndex();
            Integer ascendingDiagonalIndexCount = (Integer)ascendingDiagonalIndexCountMap.get(ascendingDiagonalIndex);
            if (ascendingDiagonalIndexCount != null) {
                score -= ascendingDiagonalIndexCount.intValue();
                Integer n4 = ascendingDiagonalIndexCount;
                Integer n5 = ascendingDiagonalIndexCount = Integer.valueOf(ascendingDiagonalIndexCount + 1);
            } else {
                ascendingDiagonalIndexCount = 1;
            }
            ascendingDiagonalIndexCountMap.put(ascendingDiagonalIndex, ascendingDiagonalIndexCount);
            int descendingDiagonalIndex = queen.getDescendingDiagonalIndex();
            Integer descendingDiagonalIndexCount = (Integer)descendingDiagonalIndexCountMap.get(descendingDiagonalIndex);
            if (descendingDiagonalIndexCount != null) {
                score -= descendingDiagonalIndexCount.intValue();
                Integer n6 = descendingDiagonalIndexCount;
                Integer n7 = descendingDiagonalIndexCount = Integer.valueOf(descendingDiagonalIndexCount + 1);
            } else {
                descendingDiagonalIndexCount = 1;
            }
            descendingDiagonalIndexCountMap.put(descendingDiagonalIndex, descendingDiagonalIndexCount);
        }
        return SimpleScore.of((int)score);
    }
}

