/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.optional.move;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;

public class CloudProcessSwapMove
extends AbstractMove<CloudBalance> {
    private CloudProcess leftCloudProcess;
    private CloudProcess rightCloudProcess;

    public CloudProcessSwapMove(CloudProcess leftCloudProcess, CloudProcess rightCloudProcess) {
        this.leftCloudProcess = leftCloudProcess;
        this.rightCloudProcess = rightCloudProcess;
    }

    public boolean isMoveDoable(ScoreDirector<CloudBalance> scoreDirector) {
        return !Objects.equals(this.leftCloudProcess.getComputer(), this.rightCloudProcess.getComputer());
    }

    public CloudProcessSwapMove createUndoMove(ScoreDirector<CloudBalance> scoreDirector) {
        return new CloudProcessSwapMove(this.rightCloudProcess, this.leftCloudProcess);
    }

    protected void doMoveOnGenuineVariables(ScoreDirector<CloudBalance> scoreDirector) {
        CloudComputer oldLeftCloudComputer = this.leftCloudProcess.getComputer();
        CloudComputer oldRightCloudComputer = this.rightCloudProcess.getComputer();
        scoreDirector.beforeVariableChanged((Object)this.leftCloudProcess, "computer");
        this.leftCloudProcess.setComputer(oldRightCloudComputer);
        scoreDirector.afterVariableChanged((Object)this.leftCloudProcess, "computer");
        scoreDirector.beforeVariableChanged((Object)this.rightCloudProcess, "computer");
        this.rightCloudProcess.setComputer(oldLeftCloudComputer);
        scoreDirector.afterVariableChanged((Object)this.rightCloudProcess, "computer");
    }

    public CloudProcessSwapMove rebase(ScoreDirector<CloudBalance> destinationScoreDirector) {
        return new CloudProcessSwapMove((CloudProcess)destinationScoreDirector.lookUpWorkingObject((Object)this.leftCloudProcess), (CloudProcess)destinationScoreDirector.lookUpWorkingObject((Object)this.rightCloudProcess));
    }

    public String getSimpleMoveTypeDescription() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + CloudProcess.class.getSimpleName() + ".computer)";
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftCloudProcess, this.rightCloudProcess);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Arrays.asList(this.leftCloudProcess.getComputer(), this.rightCloudProcess.getComputer());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CloudProcessSwapMove other = (CloudProcessSwapMove)((Object)o);
        return Objects.equals(this.leftCloudProcess, other.leftCloudProcess) && Objects.equals(this.rightCloudProcess, other.rightCloudProcess);
    }

    public int hashCode() {
        return Objects.hash(this.leftCloudProcess, this.rightCloudProcess);
    }

    public String toString() {
        return this.leftCloudProcess + " {" + this.leftCloudProcess.getComputer() + "} <-> " + this.rightCloudProcess + " {" + this.rightCloudProcess.getComputer() + "}";
    }
}

