/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.solver.solution.initializer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.phase.custom.CustomPhaseCommand;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuoyVehicleRoutingSolutionInitializer
implements CustomPhaseCommand<VehicleRoutingSolution> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public void changeWorkingSolution(ScoreDirector<VehicleRoutingSolution> scoreDirector) {
        VehicleRoutingSolution solution = (VehicleRoutingSolution)scoreDirector.getWorkingSolution();
        List<Vehicle> vehicleList = solution.getVehicleList();
        List<Customer> customerList = solution.getCustomerList();
        ArrayList<AbstractPersistable> standstillList = new ArrayList<AbstractPersistable>(vehicleList.size() + customerList.size());
        standstillList.addAll(vehicleList);
        standstillList.addAll(customerList);
        this.logger.info("Starting sorting");
        HashMap<Standstill, Customer[]> nearbyMap = new HashMap<Standstill, Customer[]>(standstillList.size());
        for (final Standstill standstill : standstillList) {
            Customer[] nearbyCustomers = customerList.toArray(new Customer[0]);
            Arrays.sort(nearbyCustomers, new Comparator<Standstill>(){

                @Override
                public int compare(Standstill a, Standstill b) {
                    double aDistance = standstill.getLocation().getDistanceTo(a.getLocation());
                    double bDistance = standstill.getLocation().getDistanceTo(b.getLocation());
                    return Double.compare(aDistance, bDistance);
                }
            });
            nearbyMap.put(standstill, nearbyCustomers);
        }
        this.logger.info("Done sorting");
        ArrayList<Vehicle> buoyList = new ArrayList<Vehicle>(vehicleList);
        int n = 40;
        while (true) {
            Score stepScore = null;
            int stepBuoyIndex = -1;
            Customer stepEntity = null;
            block2: for (int i = 0; i < buoyList.size(); ++i) {
                Standstill buoy = (Standstill)buoyList.get(i);
                Customer[] nearbyCustomers = (Customer[])nearbyMap.get(buoy);
                int j = 0;
                for (Customer customer : nearbyCustomers) {
                    if (customer.getPreviousStandstill() != null) continue;
                    scoreDirector.beforeVariableChanged((Object)customer, "previousStandstill");
                    customer.setPreviousStandstill(buoy);
                    scoreDirector.afterVariableChanged((Object)customer, "previousStandstill");
                    scoreDirector.triggerVariableListeners();
                    Score score = ((InnerScoreDirector)scoreDirector).calculateScore();
                    scoreDirector.beforeVariableChanged((Object)customer, "previousStandstill");
                    customer.setPreviousStandstill(null);
                    scoreDirector.afterVariableChanged((Object)customer, "previousStandstill");
                    scoreDirector.triggerVariableListeners();
                    if (stepScore == null || score.withInitScore(0).compareTo((Object)stepScore.withInitScore(0)) > 0) {
                        stepScore = score;
                        stepBuoyIndex = i;
                        stepEntity = customer;
                    }
                    if (j >= n) continue block2;
                    ++j;
                }
            }
            if (stepEntity == null) break;
            Standstill stepValue = buoyList.set(stepBuoyIndex, (Vehicle)((Object)stepEntity));
            scoreDirector.beforeVariableChanged(stepEntity, "previousStandstill");
            stepEntity.setPreviousStandstill(stepValue);
            scoreDirector.afterVariableChanged((Object)stepEntity, "previousStandstill");
            scoreDirector.triggerVariableListeners();
            this.logger.debug("    Score ({}), assigned customer ({}) to stepValue ({}).", new Object[]{stepScore, stepEntity, stepValue});
        }
    }
}

