/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.flightcrewscheduling.domain;

import java.util.Map;
import org.optaplanner.examples.common.domain.AbstractPersistable;

public class Airport
extends AbstractPersistable
implements Comparable<Airport> {
    private String code;
    private String name;
    private double latitude;
    private double longitude;
    private Map<Airport, Long> taxiTimeInMinutesMap;

    public Long getTaxiTimeInMinutesTo(Airport other) {
        return this.taxiTimeInMinutesMap.get(other);
    }

    public double getHaversineDistanceInKmTo(Airport other) {
        if (this == other) {
            return 0.0;
        }
        int EARTH_RADIUS_IN_KM = 6371;
        int TWICE_EARTH_RADIUS_IN_KM = 12742;
        double latitudeInRads = Math.toRadians(this.latitude);
        double longitudeInRads = Math.toRadians(this.longitude);
        double cartesianX = 0.5 * Math.cos(latitudeInRads) * Math.sin(longitudeInRads);
        double cartesianY = 0.5 * Math.cos(latitudeInRads) * Math.cos(longitudeInRads);
        double cartesianZ = 0.5 * Math.sin(latitudeInRads);
        double otherLatitudeInRads = Math.toRadians(other.latitude);
        double otherLongitudeInRads = Math.toRadians(other.longitude);
        double otherCartesianX = 0.5 * Math.cos(otherLatitudeInRads) * Math.sin(otherLongitudeInRads);
        double otherCartesianY = 0.5 * Math.cos(otherLatitudeInRads) * Math.cos(otherLongitudeInRads);
        double otherCartesianZ = 0.5 * Math.sin(otherLatitudeInRads);
        double dX = cartesianX - otherCartesianX;
        double dY = cartesianY - otherCartesianY;
        double dZ = cartesianZ - otherCartesianZ;
        double r = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        return 12742.0 * Math.asin(r);
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public Map<Airport, Long> getTaxiTimeInMinutesMap() {
        return this.taxiTimeInMinutesMap;
    }

    public void setTaxiTimeInMinutesMap(Map<Airport, Long> taxiTimeInMinutesMap) {
        this.taxiTimeInMinutesMap = taxiTimeInMinutesMap;
    }

    @Override
    public int compareTo(Airport o) {
        return this.code.compareTo(o.code);
    }
}

