/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.flightcrewscheduling.score;

import java.time.LocalDate;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.flightcrewscheduling.domain.Employee;
import org.optaplanner.examples.flightcrewscheduling.domain.FlightAssignment;
import org.optaplanner.examples.flightcrewscheduling.domain.Skill;

public class FlightCrewSchedulingConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.requiredSkill(constraintFactory), this.flightConflict(constraintFactory), this.transferBetweenTwoFlights(constraintFactory), this.employeeUnavailability(constraintFactory), this.firstAssignmentDepartingFromHome(constraintFactory), this.lastAssignmentArrivingAtHome(constraintFactory)};
    }

    private Constraint requiredSkill(ConstraintFactory constraintFactory) {
        return constraintFactory.from(FlightAssignment.class).filter(flightAssignment -> {
            Skill requiredSkill = flightAssignment.getRequiredSkill();
            return !flightAssignment.getEmployee().hasSkill(requiredSkill);
        }).penalize("Required skill", (Score)HardSoftLongScore.ofHard((long)100L));
    }

    private Constraint flightConflict(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUniquePair(FlightAssignment.class, Joiners.equal(FlightAssignment::getEmployee), Joiners.overlapping(fa -> fa.getFlight().getDepartureUTCDateTime(), fa -> fa.getFlight().getArrivalUTCDateTime())).penalize("Flight conflict", (Score)HardSoftLongScore.ofHard((long)10L));
    }

    private Constraint transferBetweenTwoFlights(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Employee.class).filter(employee -> employee.countInvalidConnections() > 0L).penalizeLong("Transfer between two flights", (Score)HardSoftLongScore.ofHard((long)1L), Employee::countInvalidConnections);
    }

    private Constraint employeeUnavailability(ConstraintFactory constraintFactory) {
        return constraintFactory.from(FlightAssignment.class).filter(flightAssignment -> {
            LocalDate departureUTCDate = flightAssignment.getFlight().getDepartureUTCDate();
            return !flightAssignment.getEmployee().isAvailable(departureUTCDate);
        }).penalize("Employee unavailable", (Score)HardSoftLongScore.ofHard((long)10L));
    }

    private Constraint firstAssignmentDepartingFromHome(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Employee.class).filter(employee -> !employee.isFirstAssignmentDepartingFromHome()).penalize("First assignment departing from home", (Score)HardSoftLongScore.ofSoft((long)1000000L));
    }

    private Constraint lastAssignmentArrivingAtHome(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Employee.class).filter(employee -> !employee.isLastAssignmentArrivingAtHome()).penalize("Last assignment arriving at home", (Score)HardSoftLongScore.ofSoft((long)1000000L));
    }
}

