/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.score;

import java.util.function.Function;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.examination.domain.Exam;
import org.optaplanner.examples.examination.domain.ExaminationConstraintConfiguration;
import org.optaplanner.examples.examination.domain.Period;
import org.optaplanner.examples.examination.domain.PeriodPenalty;
import org.optaplanner.examples.examination.domain.PeriodPenaltyType;
import org.optaplanner.examples.examination.domain.Room;
import org.optaplanner.examples.examination.domain.RoomPenalty;
import org.optaplanner.examples.examination.domain.RoomPenaltyType;
import org.optaplanner.examples.examination.domain.solver.TopicConflict;

public class ExaminationConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.conflictingExamsInSamePeriod(constraintFactory), this.periodDurationTooShort(constraintFactory), this.roomCapacityTooSmall(constraintFactory), this.periodPenaltyExamCoincidence(constraintFactory), this.periodPenaltyExclusion(constraintFactory), this.periodPenaltyAfter(constraintFactory), this.roomPenaltyExclusive(constraintFactory), this.twoExamsInARow(constraintFactory), this.twoExamsInADay(constraintFactory), this.periodSpread(constraintFactory), this.mixedDurations(constraintFactory), this.frontLoad(constraintFactory), this.periodPenalty(constraintFactory), this.roomPenalty(constraintFactory)};
    }

    protected Constraint conflictingExamsInSamePeriod(ConstraintFactory constraintFactory) {
        return constraintFactory.from(TopicConflict.class).join(Exam.class, Joiners.equal(TopicConflict::getLeftTopic, Exam::getTopic), Joiners.filtering((topicConflict, leftExam) -> leftExam.getPeriod() != null)).ifExists(Exam.class, Joiners.equal((topicConflict, leftExam) -> topicConflict.getRightTopic(), Exam::getTopic), Joiners.equal((topicConflict, leftExam) -> leftExam.getPeriod(), Exam::getPeriod)).penalizeConfigurable("conflictingExamsInSamePeriod", (topicConflict, leftExam) -> topicConflict.getStudentSize());
    }

    protected Constraint periodDurationTooShort(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Exam.class).filter(exam -> exam.getTopicDuration() > exam.getPeriodDuration()).penalizeConfigurable("periodDurationTooShort", Exam::getTopicStudentSize);
    }

    protected Constraint roomCapacityTooSmall(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Exam.class).filter(exam -> exam.getPeriod() != null).groupBy(Exam::getRoom, Exam::getPeriod, ConstraintCollectors.sum(Exam::getTopicStudentSize)).filter((room, period, totalStudentSize) -> totalStudentSize > room.getCapacity()).penalizeConfigurable("roomCapacityTooSmall", (room, period, totalStudentSize) -> totalStudentSize - room.getCapacity());
    }

    protected Constraint periodPenaltyExamCoincidence(ConstraintFactory constraintFactory) {
        return constraintFactory.from(PeriodPenalty.class).filter(periodPenalty -> periodPenalty.getPeriodPenaltyType() == PeriodPenaltyType.EXAM_COINCIDENCE).join(Exam.class, Joiners.equal(PeriodPenalty::getLeftTopic, Exam::getTopic), Joiners.filtering((periodPenalty, leftExam) -> leftExam.getPeriod() != null)).join(Exam.class, Joiners.equal((periodPenalty, leftExam) -> periodPenalty.getRightTopic(), Exam::getTopic), Joiners.filtering((periodPenalty, leftExam, rightExam) -> rightExam.getPeriod() != null), Joiners.filtering((periodPenalty, leftExam, rightExam) -> leftExam.getPeriod() != rightExam.getPeriod())).penalizeConfigurable("periodPenaltyExamCoincidence", (periodPenalty, leftExam, rightExam) -> leftExam.getTopic().getStudentSize() + rightExam.getTopic().getStudentSize());
    }

    protected Constraint periodPenaltyExclusion(ConstraintFactory constraintFactory) {
        return constraintFactory.from(PeriodPenalty.class).filter(periodPenalty -> periodPenalty.getPeriodPenaltyType() == PeriodPenaltyType.EXCLUSION).join(Exam.class, Joiners.equal(PeriodPenalty::getLeftTopic, Exam::getTopic), Joiners.filtering((periodPenalty, leftExam) -> leftExam.getPeriod() != null)).join(Exam.class, Joiners.equal((periodPenalty, leftExam) -> periodPenalty.getRightTopic(), Exam::getTopic), Joiners.equal((periodPenalty, leftExam) -> leftExam.getPeriod(), Exam::getPeriod)).penalizeConfigurable("periodPenaltyExclusion", (periodPenalty, leftExam, rightExam) -> leftExam.getTopic().getStudentSize() + rightExam.getTopic().getStudentSize());
    }

    protected Constraint periodPenaltyAfter(ConstraintFactory constraintFactory) {
        return constraintFactory.from(PeriodPenalty.class).filter(periodPenalty -> periodPenalty.getPeriodPenaltyType() == PeriodPenaltyType.AFTER).join(Exam.class, Joiners.equal(PeriodPenalty::getLeftTopic, Exam::getTopic), Joiners.filtering((periodPenalty, leftExam) -> leftExam.getPeriod() != null)).join(Exam.class, Joiners.equal((periodPenalty, leftExam) -> periodPenalty.getRightTopic(), Exam::getTopic), Joiners.lessThanOrEqual((periodPenalty, leftExam) -> leftExam.getPeriodIndex(), Exam::getPeriodIndex)).penalizeConfigurable("periodPenaltyAfter", (periodPenalty, leftExam, rightExam) -> leftExam.getTopic().getStudentSize() + rightExam.getTopic().getStudentSize());
    }

    protected Constraint roomPenaltyExclusive(ConstraintFactory constraintFactory) {
        return constraintFactory.from(RoomPenalty.class).filter(roomPenalty -> roomPenalty.getRoomPenaltyType() == RoomPenaltyType.ROOM_EXCLUSIVE).join(Exam.class, Joiners.equal(RoomPenalty::getTopic, Exam::getTopic), Joiners.filtering((roomPenalty, leftExam) -> leftExam.getPeriod() != null && leftExam.getRoom() != null)).join(Exam.class, Joiners.equal((roomPenalty, leftExam) -> leftExam.getRoom(), Exam::getRoom), Joiners.equal((roomPenalty, leftExam) -> leftExam.getPeriod(), Exam::getPeriod), Joiners.filtering((roomPenalty, leftExam, rightExam) -> leftExam.getTopic() != rightExam.getTopic())).penalizeConfigurable("roomPenaltyExclusive", (periodPenalty, leftExam, rightExam) -> leftExam.getTopic().getStudentSize() + rightExam.getTopic().getStudentSize());
    }

    protected Constraint twoExamsInARow(ConstraintFactory constraintFactory) {
        return constraintFactory.from(TopicConflict.class).join(Exam.class, Joiners.equal(TopicConflict::getLeftTopic, Exam::getTopic), Joiners.filtering((topicConflict, leftExam) -> leftExam.getPeriod() != null)).join(Exam.class, Joiners.equal((topicConflict, leftExam) -> topicConflict.getRightTopic(), Exam::getTopic), Joiners.equal((topicConflict, leftExam) -> leftExam.getDayIndex(), Exam::getDayIndex), Joiners.filtering((topicConflict, leftExam, rightExam) -> this.getPeriodIndexDifferenceBetweenExams((Exam)leftExam, (Exam)rightExam) == 1)).penalizeConfigurable("twoExamsInARow", (topicConflict, leftExam, rightExam) -> topicConflict.getStudentSize());
    }

    protected Constraint twoExamsInADay(ConstraintFactory constraintFactory) {
        return constraintFactory.from(TopicConflict.class).join(Exam.class, Joiners.equal(TopicConflict::getLeftTopic, Exam::getTopic), Joiners.filtering((topicConflict, leftExam) -> leftExam.getPeriod() != null)).join(Exam.class, Joiners.equal((topicConflict, leftExam) -> topicConflict.getRightTopic(), Exam::getTopic), Joiners.equal((topicConflict, leftExam) -> leftExam.getDayIndex(), Exam::getDayIndex), Joiners.filtering((topicConflict, leftExam, rightExam) -> this.getPeriodIndexDifferenceBetweenExams((Exam)leftExam, (Exam)rightExam) > 1)).penalizeConfigurable("twoExamsInADay", (topicConflict, leftExam, rightExam) -> topicConflict.getStudentSize());
    }

    protected Constraint periodSpread(ConstraintFactory constraintFactory) {
        return constraintFactory.from(ExaminationConstraintConfiguration.class).join(TopicConflict.class).join(Exam.class, Joiners.equal((config, topicConflict) -> topicConflict.getLeftTopic(), Exam::getTopic), Joiners.filtering((config, topicConflict, leftExam) -> leftExam.getPeriod() != null)).join(Exam.class, Joiners.equal((config, topicConflict, leftExam) -> topicConflict.getRightTopic(), Exam::getTopic), Joiners.filtering((config, topicConflict, leftExam, rightExam) -> rightExam.getPeriod() != null), Joiners.filtering((config, topicConflict, leftExam, rightExam) -> this.getPeriodIndexDifferenceBetweenExams((Exam)leftExam, (Exam)rightExam) < config.getPeriodSpreadLength() + 1)).penalizeConfigurable("periodSpread", (config, topicConflict, leftExam, rightExam) -> topicConflict.getStudentSize());
    }

    protected Constraint mixedDurations(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Exam.class).filter(leftExam -> leftExam.getPeriod() != null).ifNotExistsOther(Exam.class, Joiners.equal(Exam::getPeriod), Joiners.equal(Exam::getRoom), Joiners.greaterThan(AbstractPersistable::getId)).join(Exam.class, Joiners.equal(Exam::getPeriod), Joiners.equal(Exam::getRoom), Joiners.lessThan(AbstractPersistable::getId), Joiners.filtering((leftExam, rightExam) -> leftExam.getTopicDuration() != rightExam.getTopicDuration())).ifNotExists(Exam.class, Joiners.equal((leftExam, rightExam) -> leftExam.getPeriod(), Exam::getPeriod), Joiners.equal((leftExam, rightExam) -> leftExam.getRoom(), Exam::getRoom), Joiners.equal((leftExam, rightExam) -> rightExam.getTopicDuration(), Exam::getTopicDuration), Joiners.greaterThan((leftExam, rightExam) -> rightExam.getId(), AbstractPersistable::getId)).penalizeConfigurable("mixedDurations");
    }

    protected Constraint frontLoad(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Exam.class).filter(exam -> exam.isTopicFrontLoadLarge() && exam.isPeriodFrontLoadLast()).penalizeConfigurable("frontLoad");
    }

    protected Constraint periodPenalty(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Period.class).filter(period -> period.getPenalty() != 0).join(Exam.class, Joiners.equal(Function.identity(), Exam::getPeriod)).penalizeConfigurable("periodPenalty", (period, exam) -> period.getPenalty());
    }

    protected Constraint roomPenalty(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Room.class).filter(room -> room.getPenalty() != 0).join(Exam.class, Joiners.equal(Function.identity(), Exam::getRoom)).penalizeConfigurable("roomPenalty", (room, exam) -> room.getPenalty());
    }

    private int getPeriodIndexDifferenceBetweenExams(Exam leftExam, Exam rightExam) {
        return Math.abs(leftExam.getPeriodIndex() - rightExam.getPeriodIndex());
    }
}

