/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investment.solver.move.factory;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.heuristic.selector.move.factory.MoveIteratorFactory;
import org.optaplanner.core.impl.solver.random.RandomUtils;
import org.optaplanner.examples.investment.domain.AssetClassAllocation;
import org.optaplanner.examples.investment.domain.InvestmentSolution;
import org.optaplanner.examples.investment.solver.move.InvestmentQuantityTransferMove;

public class InvestmentQuantityTransferMoveIteratorFactory
implements MoveIteratorFactory<InvestmentSolution, InvestmentQuantityTransferMove> {
    public long getSize(ScoreDirector<InvestmentSolution> scoreDirector) {
        InvestmentSolution solution = (InvestmentSolution)scoreDirector.getWorkingSolution();
        int size = solution.getAssetClassAllocationList().size();
        return 1000L * (long)(size - 1);
    }

    public Iterator<InvestmentQuantityTransferMove> createOriginalMoveIterator(ScoreDirector<InvestmentSolution> scoreDirector) {
        throw new UnsupportedOperationException();
    }

    public RandomInvestmentQuantityTransferMoveIterator createRandomMoveIterator(ScoreDirector<InvestmentSolution> scoreDirector, Random workingRandom) {
        InvestmentSolution solution = (InvestmentSolution)scoreDirector.getWorkingSolution();
        List<AssetClassAllocation> allocationList = solution.getAssetClassAllocationList();
        TreeMap<Long, AssetClassAllocation> quantityMillisIncrementToAllocationMap = new TreeMap<Long, AssetClassAllocation>();
        long quantityIncrementMillis = 0L;
        for (AssetClassAllocation allocation : allocationList) {
            long quantityMillis = allocation.getQuantityMillis();
            if (quantityMillis <= 0L) continue;
            quantityMillisIncrementToAllocationMap.put(quantityIncrementMillis += quantityMillis, allocation);
        }
        if (quantityIncrementMillis != 1000L) {
            throw new IllegalStateException("The quantityIncrementMillis (" + quantityIncrementMillis + ") must always be total to MAXIMUM_QUANTITY_MILLIS (1000).");
        }
        return new RandomInvestmentQuantityTransferMoveIterator(allocationList, quantityMillisIncrementToAllocationMap, workingRandom);
    }

    public static class RandomInvestmentQuantityTransferMoveIterator
    implements Iterator<InvestmentQuantityTransferMove> {
        private final List<AssetClassAllocation> allocationList;
        private final NavigableMap<Long, AssetClassAllocation> quantityMillisIncrementToAllocationMap;
        private final Random workingRandom;

        public RandomInvestmentQuantityTransferMoveIterator(List<AssetClassAllocation> allocationList, NavigableMap<Long, AssetClassAllocation> quantityMillisIncrementToAllocationMap, Random workingRandom) {
            this.allocationList = allocationList;
            this.quantityMillisIncrementToAllocationMap = quantityMillisIncrementToAllocationMap;
            this.workingRandom = workingRandom;
        }

        @Override
        public boolean hasNext() {
            return this.allocationList.size() >= 2;
        }

        @Override
        public InvestmentQuantityTransferMove next() {
            long transferMillis = RandomUtils.nextLong((Random)this.workingRandom, (long)1000L) + 1L;
            Map.Entry<Long, AssetClassAllocation> lowerEntry = this.quantityMillisIncrementToAllocationMap.lowerEntry(transferMillis);
            Map.Entry<Long, AssetClassAllocation> ceilingEntry = this.quantityMillisIncrementToAllocationMap.ceilingEntry(transferMillis);
            transferMillis -= lowerEntry == null ? 0L : lowerEntry.getKey();
            AssetClassAllocation fromAllocation = ceilingEntry.getValue();
            AssetClassAllocation toAllocation = this.allocationList.get(this.workingRandom.nextInt(this.allocationList.size() - 1));
            if (toAllocation == fromAllocation) {
                toAllocation = this.allocationList.get(this.allocationList.size() - 1);
            }
            return new InvestmentQuantityTransferMove(fromAllocation, toAllocation, transferMillis);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The optional operation remove() is not supported.");
        }
    }
}

