/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.score;

import java.util.function.Function;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.pas.domain.BedDesignation;
import org.optaplanner.examples.pas.domain.Department;
import org.optaplanner.examples.pas.domain.DepartmentSpecialism;
import org.optaplanner.examples.pas.domain.Gender;
import org.optaplanner.examples.pas.domain.GenderLimitation;
import org.optaplanner.examples.pas.domain.PreferredPatientEquipment;
import org.optaplanner.examples.pas.domain.RequiredPatientEquipment;
import org.optaplanner.examples.pas.domain.RoomEquipment;
import org.optaplanner.examples.pas.domain.RoomSpecialism;

public class PatientAdmissionScheduleConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.sameBedInSameNightConstraint(constraintFactory), this.femaleInMaleRoomConstraint(constraintFactory), this.maleInFemaleRoomConstraint(constraintFactory), this.differentGenderInSameGenderRoomInSameNightConstraint(constraintFactory), this.departmentMinimumAgeConstraint(constraintFactory), this.departmentMaximumAgeConstraint(constraintFactory), this.requiredPatientEquipmentConstraint(constraintFactory), this.assignEveryPatientToABedConstraint(constraintFactory), this.preferredMaximumRoomCapacityConstraint(constraintFactory), this.departmentSpecialismConstraint(constraintFactory), this.roomSpecialismNotExistsConstraint(constraintFactory), this.roomSpecialismNotFirstPriorityConstraint(constraintFactory), this.preferredPatientEquipmentConstraint(constraintFactory)};
    }

    public Constraint sameBedInSameNightConstraint(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUniquePair(BedDesignation.class, Joiners.equal(BedDesignation::getBed)).filter((left, right) -> left.getBed() != null && left.getAdmissionPart().calculateSameNightCount(right.getAdmissionPart()) > 0).penalize("sameBedInSameNight", (Score)HardMediumSoftScore.ofHard((int)1000), (left, right) -> left.getAdmissionPart().calculateSameNightCount(right.getAdmissionPart()));
    }

    public Constraint femaleInMaleRoomConstraint(ConstraintFactory constraintFactory) {
        return constraintFactory.from(BedDesignation.class).filter(bd -> bd.getPatientGender() == Gender.FEMALE && bd.getRoomGenderLimitation() == GenderLimitation.MALE_ONLY).penalize("femaleInMaleRoom", (Score)HardMediumSoftScore.ofHard((int)50), BedDesignation::getAdmissionPartNightCount);
    }

    public Constraint maleInFemaleRoomConstraint(ConstraintFactory constraintFactory) {
        return constraintFactory.from(BedDesignation.class).filter(bd -> bd.getPatientGender() == Gender.MALE && bd.getRoomGenderLimitation() == GenderLimitation.FEMALE_ONLY).penalize("maleInFemaleRoom", (Score)HardMediumSoftScore.ofHard((int)50), BedDesignation::getAdmissionPartNightCount);
    }

    public Constraint differentGenderInSameGenderRoomInSameNightConstraint(ConstraintFactory constraintFactory) {
        return constraintFactory.from(BedDesignation.class).filter(bd -> bd.getRoomGenderLimitation() == GenderLimitation.SAME_GENDER && bd.getBed() != null).join(BedDesignation.class, Joiners.equal(BedDesignation::getRoom), Joiners.lessThan(AbstractPersistable::getId), Joiners.filtering((left, right) -> right.getRoomGenderLimitation() == GenderLimitation.SAME_GENDER && left.getPatient().getGender() != right.getPatient().getGender() && left.getAdmissionPart().calculateSameNightCount(right.getAdmissionPart()) > 0)).penalize("differentGenderInSameGenderRoomInSameNight", (Score)HardMediumSoftScore.ofHard((int)1000), (left, right) -> left.getAdmissionPart().calculateSameNightCount(right.getAdmissionPart()));
    }

    public Constraint departmentMinimumAgeConstraint(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Department.class).filter(d -> d.getMinimumAge() != null).join(BedDesignation.class, Joiners.equal(Function.identity(), BedDesignation::getDepartment), Joiners.greaterThan(Department::getMinimumAge, BedDesignation::getPatientAge)).penalize("departmentMinimumAge", (Score)HardMediumSoftScore.ofHard((int)100), (d, bd) -> bd.getAdmissionPartNightCount());
    }

    public Constraint departmentMaximumAgeConstraint(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Department.class).filter(d -> d.getMaximumAge() != null).join(BedDesignation.class, Joiners.equal(Function.identity(), BedDesignation::getDepartment), Joiners.lessThan(Department::getMaximumAge, BedDesignation::getPatientAge)).penalize("departmentMaximumAge", (Score)HardMediumSoftScore.ofHard((int)100), (d, bd) -> bd.getAdmissionPartNightCount());
    }

    public Constraint requiredPatientEquipmentConstraint(ConstraintFactory constraintFactory) {
        return constraintFactory.from(RequiredPatientEquipment.class).join(BedDesignation.class, Joiners.equal(RequiredPatientEquipment::getPatient, BedDesignation::getPatient), Joiners.filtering((rpe, bd) -> bd.getBed() != null)).ifNotExists(RoomEquipment.class, Joiners.equal((rpe, bd) -> bd.getRoom(), RoomEquipment::getRoom), Joiners.equal((rpe, bd) -> rpe.getEquipment(), RoomEquipment::getEquipment)).penalize("requiredPatientEquipment", (Score)HardMediumSoftScore.ofHard((int)50), (rpe, bd) -> bd.getAdmissionPartNightCount());
    }

    public Constraint assignEveryPatientToABedConstraint(ConstraintFactory constraintFactory) {
        return constraintFactory.from(BedDesignation.class).filter(bd -> bd.getBed() == null).penalize("assignEveryPatientToABed", (Score)HardMediumSoftScore.ONE_MEDIUM, BedDesignation::getAdmissionPartNightCount);
    }

    public Constraint preferredMaximumRoomCapacityConstraint(ConstraintFactory constraintFactory) {
        return constraintFactory.from(BedDesignation.class).filter(bd -> bd.getBed() != null && bd.getPatient().getPreferredMaximumRoomCapacity() != null && bd.getPatient().getPreferredMaximumRoomCapacity() < bd.getRoom().getCapacity()).penalize("preferredMaximumRoomCapacity", (Score)HardMediumSoftScore.ofSoft((int)8), BedDesignation::getAdmissionPartNightCount);
    }

    public Constraint departmentSpecialismConstraint(ConstraintFactory constraintFactory) {
        return constraintFactory.from(BedDesignation.class).filter(bd -> bd.getBed() != null).ifNotExists(DepartmentSpecialism.class, Joiners.equal(BedDesignation::getDepartment, DepartmentSpecialism::getDepartment), Joiners.equal(BedDesignation::getAdmissionPartSpecialism, DepartmentSpecialism::getSpecialism)).penalize("departmentSpecialism", (Score)HardMediumSoftScore.ofSoft((int)10), BedDesignation::getAdmissionPartNightCount);
    }

    public Constraint roomSpecialismNotExistsConstraint(ConstraintFactory constraintFactory) {
        return constraintFactory.from(BedDesignation.class).filter(bd -> bd.getBed() != null && bd.getAdmissionPartSpecialism() != null).ifNotExists(RoomSpecialism.class, Joiners.equal(BedDesignation::getRoom, RoomSpecialism::getRoom), Joiners.equal(BedDesignation::getAdmissionPartSpecialism, RoomSpecialism::getSpecialism)).penalize("roomSpecialismNotExists", (Score)HardMediumSoftScore.ofSoft((int)20), BedDesignation::getAdmissionPartNightCount);
    }

    public Constraint roomSpecialismNotFirstPriorityConstraint(ConstraintFactory constraintFactory) {
        return constraintFactory.from(BedDesignation.class).filter(bd -> bd.getBed() != null && bd.getAdmissionPartSpecialism() != null).join(RoomSpecialism.class, Joiners.equal(BedDesignation::getRoom, RoomSpecialism::getRoom), Joiners.equal(BedDesignation::getAdmissionPartSpecialism, RoomSpecialism::getSpecialism), Joiners.filtering((bd, rs) -> rs.getPriority() > 1)).penalize("roomSpecialismNotFirstPriority", (Score)HardMediumSoftScore.ofSoft((int)10), (bd, rs) -> (rs.getPriority() - 1) * bd.getAdmissionPartNightCount());
    }

    public Constraint preferredPatientEquipmentConstraint(ConstraintFactory constraintFactory) {
        return constraintFactory.from(PreferredPatientEquipment.class).join(BedDesignation.class, Joiners.equal(PreferredPatientEquipment::getPatient, BedDesignation::getPatient), Joiners.filtering((ppe, bd) -> bd.getBed() != null)).ifNotExists(RoomEquipment.class, Joiners.equal((re, bd) -> bd.getRoom(), RoomEquipment::getRoom), Joiners.equal((re, bd) -> re.getEquipment(), RoomEquipment::getEquipment)).penalize("preferredPatientEquipment", (Score)HardMediumSoftScore.ofSoft((int)20), (re, bd) -> bd.getAdmissionPartNightCount());
    }
}

