/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.persistence;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionConverter;
import org.optaplanner.examples.curriculumcourse.domain.Course;
import org.optaplanner.examples.curriculumcourse.domain.CourseSchedule;
import org.optaplanner.examples.curriculumcourse.domain.Curriculum;
import org.optaplanner.examples.curriculumcourse.domain.Day;
import org.optaplanner.examples.curriculumcourse.domain.Lecture;
import org.optaplanner.examples.curriculumcourse.domain.Period;
import org.optaplanner.examples.curriculumcourse.domain.Room;
import org.optaplanner.examples.curriculumcourse.domain.Teacher;
import org.optaplanner.examples.curriculumcourse.domain.Timeslot;
import org.optaplanner.examples.curriculumcourse.domain.UnavailablePeriodPenalty;

public class CurriculumCourseImporter
extends AbstractTxtSolutionImporter<CourseSchedule> {
    private static final String INPUT_FILE_SUFFIX = "ctt";

    public static void main(String[] args) {
        SolutionConverter<CourseSchedule> converter = SolutionConverter.createImportConverter("curriculumcourse", new CurriculumCourseImporter(), CourseSchedule.class);
        converter.convertAll();
    }

    @Override
    public String getInputFileSuffix() {
        return INPUT_FILE_SUFFIX;
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder<CourseSchedule> createTxtInputBuilder() {
        return new CurriculumCourseInputBuilder();
    }

    public static class CurriculumCourseInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder<CourseSchedule> {
        @Override
        public CourseSchedule readSolution() throws IOException {
            CourseSchedule schedule = new CourseSchedule();
            schedule.setId(0L);
            schedule.setName(this.readStringValue("Name:"));
            int courseListSize = this.readIntegerValue("Courses:");
            int roomListSize = this.readIntegerValue("Rooms:");
            int dayListSize = this.readIntegerValue("Days:");
            int timeslotListSize = this.readIntegerValue("Periods_per_day:");
            int curriculumListSize = this.readIntegerValue("Curricula:");
            int unavailablePeriodPenaltyListSize = this.readIntegerValue("Constraints:");
            Map<String, Course> courseMap = this.readCourseListAndTeacherList(schedule, courseListSize);
            this.readRoomList(schedule, roomListSize);
            Map<List<Integer>, Period> periodMap = this.createPeriodListAndDayListAndTimeslotList(schedule, dayListSize, timeslotListSize);
            this.readCurriculumList(schedule, courseMap, curriculumListSize);
            this.readUnavailablePeriodPenaltyList(schedule, courseMap, periodMap, unavailablePeriodPenaltyListSize);
            this.readEmptyLine();
            this.readConstantLine("END\\.");
            this.createLectureList(schedule);
            int possibleForOneLectureSize = schedule.getPeriodList().size() * schedule.getRoomList().size();
            BigInteger possibleSolutionSize = BigInteger.valueOf(possibleForOneLectureSize).pow(schedule.getLectureList().size());
            this.logger.info("CourseSchedule {} has {} teachers, {} curricula, {} courses, {} lectures, {} periods, {} rooms and {} unavailable period constraints with a search space of {}.", new Object[]{this.getInputId(), schedule.getTeacherList().size(), schedule.getCurriculumList().size(), schedule.getCourseList().size(), schedule.getLectureList().size(), schedule.getPeriodList().size(), schedule.getRoomList().size(), schedule.getUnavailablePeriodPenaltyList().size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
            return schedule;
        }

        private Map<String, Course> readCourseListAndTeacherList(CourseSchedule schedule, int courseListSize) throws IOException {
            HashMap<String, Course> courseMap = new HashMap<String, Course>(courseListSize);
            HashMap<String, Teacher> teacherMap = new HashMap<String, Teacher>();
            ArrayList<Course> courseList = new ArrayList<Course>(courseListSize);
            this.readEmptyLine();
            this.readConstantLine("COURSES:");
            for (int i = 0; i < courseListSize; ++i) {
                Course course = new Course();
                course.setId(Long.valueOf(i));
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpacesOrTabs(line, 5);
                course.setCode(lineTokens[0]);
                course.setTeacher(this.findOrCreateTeacher(teacherMap, lineTokens[1]));
                course.setLectureSize(Integer.parseInt(lineTokens[2]));
                course.setMinWorkingDaySize(Integer.parseInt(lineTokens[3]));
                course.setCurriculumSet(new LinkedHashSet<Curriculum>());
                course.setStudentSize(Integer.parseInt(lineTokens[4]));
                courseList.add(course);
                courseMap.put(course.getCode(), course);
            }
            schedule.setCourseList(courseList);
            ArrayList<Teacher> teacherList = new ArrayList<Teacher>(teacherMap.values());
            schedule.setTeacherList(teacherList);
            return courseMap;
        }

        private Teacher findOrCreateTeacher(Map<String, Teacher> teacherMap, String code) {
            Teacher teacher = teacherMap.get(code);
            if (teacher == null) {
                teacher = new Teacher();
                int id = teacherMap.size();
                teacher.setId(Long.valueOf(id));
                teacher.setCode(code);
                teacherMap.put(code, teacher);
            }
            return teacher;
        }

        private void readRoomList(CourseSchedule schedule, int roomListSize) throws IOException {
            this.readEmptyLine();
            this.readConstantLine("ROOMS:");
            ArrayList<Room> roomList = new ArrayList<Room>(roomListSize);
            for (int i = 0; i < roomListSize; ++i) {
                Room room = new Room();
                room.setId(Long.valueOf(i));
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpacesOrTabs(line, 2);
                room.setCode(lineTokens[0]);
                room.setCapacity(Integer.parseInt(lineTokens[1]));
                roomList.add(room);
            }
            schedule.setRoomList(roomList);
        }

        private Map<List<Integer>, Period> createPeriodListAndDayListAndTimeslotList(CourseSchedule schedule, int dayListSize, int timeslotListSize) throws IOException {
            int periodListSize = dayListSize * timeslotListSize;
            HashMap<List<Integer>, Period> periodMap = new HashMap<List<Integer>, Period>(periodListSize);
            ArrayList<Day> dayList = new ArrayList<Day>(dayListSize);
            for (int i = 0; i < dayListSize; ++i) {
                Day day = new Day();
                day.setId(Long.valueOf(i));
                day.setDayIndex(i);
                day.setPeriodList(new ArrayList<Period>(timeslotListSize));
                dayList.add(day);
            }
            schedule.setDayList(dayList);
            ArrayList<Timeslot> timeslotList = new ArrayList<Timeslot>(timeslotListSize);
            for (int i = 0; i < timeslotListSize; ++i) {
                Timeslot timeslot = new Timeslot(i);
                timeslotList.add(timeslot);
            }
            schedule.setTimeslotList(timeslotList);
            ArrayList<Period> periodList = new ArrayList<Period>(periodListSize);
            for (int i = 0; i < dayListSize; ++i) {
                Day day = (Day)dayList.get(i);
                for (int j = 0; j < timeslotListSize; ++j) {
                    Period period = new Period();
                    period.setId((long)i * (long)timeslotListSize + (long)j);
                    period.setDay(day);
                    period.setTimeslot((Timeslot)timeslotList.get(j));
                    periodList.add(period);
                    periodMap.put(Arrays.asList(i, j), period);
                    day.getPeriodList().add(period);
                }
            }
            schedule.setPeriodList(periodList);
            return periodMap;
        }

        private void readCurriculumList(CourseSchedule schedule, Map<String, Course> courseMap, int curriculumListSize) throws IOException {
            this.readEmptyLine();
            this.readConstantLine("CURRICULA:");
            ArrayList<Curriculum> curriculumList = new ArrayList<Curriculum>(curriculumListSize);
            for (int i = 0; i < curriculumListSize; ++i) {
                Curriculum curriculum = new Curriculum();
                curriculum.setId(Long.valueOf(i));
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpacesOrTabs(line);
                if (lineTokens.length < 2) {
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to contain at least 2 tokens.");
                }
                curriculum.setCode(lineTokens[0]);
                int coursesInCurriculum = Integer.parseInt(lineTokens[1]);
                if (lineTokens.length != coursesInCurriculum + 2) {
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to contain " + (coursesInCurriculum + 2) + " tokens.");
                }
                for (int j = 2; j < lineTokens.length; ++j) {
                    Course course = courseMap.get(lineTokens[j]);
                    if (course == null) {
                        throw new IllegalArgumentException("Read line (" + line + ") uses an unexisting course(" + lineTokens[j] + ").");
                    }
                    course.getCurriculumSet().add(curriculum);
                }
                curriculumList.add(curriculum);
            }
            schedule.setCurriculumList(curriculumList);
        }

        private void readUnavailablePeriodPenaltyList(CourseSchedule schedule, Map<String, Course> courseMap, Map<List<Integer>, Period> periodMap, int unavailablePeriodPenaltyListSize) throws IOException {
            this.readEmptyLine();
            this.readConstantLine("UNAVAILABILITY_CONSTRAINTS:");
            ArrayList<UnavailablePeriodPenalty> penaltyList = new ArrayList<UnavailablePeriodPenalty>(unavailablePeriodPenaltyListSize);
            for (int i = 0; i < unavailablePeriodPenaltyListSize; ++i) {
                UnavailablePeriodPenalty penalty = new UnavailablePeriodPenalty();
                penalty.setId(Long.valueOf(i));
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpacesOrTabs(line, 3);
                penalty.setCourse(courseMap.get(lineTokens[0]));
                int dayIndex = Integer.parseInt(lineTokens[1]);
                int timeslotIndex = Integer.parseInt(lineTokens[2]);
                Period period = periodMap.get(Arrays.asList(dayIndex, timeslotIndex));
                if (period == null) {
                    throw new IllegalArgumentException("Read line (" + line + ") uses an unexisting period(" + dayIndex + " " + timeslotIndex + ").");
                }
                penalty.setPeriod(period);
                penaltyList.add(penalty);
            }
            schedule.setUnavailablePeriodPenaltyList(penaltyList);
        }

        private void createLectureList(CourseSchedule schedule) {
            List<Course> courseList = schedule.getCourseList();
            ArrayList<Lecture> lectureList = new ArrayList<Lecture>(courseList.size());
            long id = 0L;
            for (Course course : courseList) {
                for (int i = 0; i < course.getLectureSize(); ++i) {
                    Lecture lecture = new Lecture();
                    lecture.setId(id);
                    ++id;
                    lecture.setCourse(course);
                    lecture.setLectureIndexInCourse(i);
                    lecture.setPinned(false);
                    lectureList.add(lecture);
                }
            }
            schedule.setLectureList(lectureList);
        }
    }
}

