/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental;

import java.time.Duration;
import java.time.temporal.Temporal;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.optaplanner.core.api.function.PentaFunction;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.examples.common.experimental.api.ConsecutiveInfo;
import org.optaplanner.examples.common.experimental.api.ConsecutiveIntervalInfo;
import org.optaplanner.examples.common.experimental.impl.ConsecutiveSetTree;
import org.optaplanner.examples.common.experimental.impl.Interval;
import org.optaplanner.examples.common.experimental.impl.IntervalTree;

public class ExperimentalConstraintCollectors {
    public static <A> UniConstraintCollector<A, ConsecutiveSetTree<A, Integer, Integer>, ConsecutiveInfo<A, Integer>> consecutive(final ToIntFunction<A> indexMap) {
        return new UniConstraintCollector<A, ConsecutiveSetTree<A, Integer, Integer>, ConsecutiveInfo<A, Integer>>(){

            public Supplier<ConsecutiveSetTree<A, Integer, Integer>> supplier() {
                return () -> new ConsecutiveSetTree<Object, Integer, Integer>(indexMap::applyAsInt, (a, b) -> b - a, Integer::sum, 1, 0);
            }

            public BiFunction<ConsecutiveSetTree<A, Integer, Integer>, A, Runnable> accumulator() {
                return (acc, a) -> {
                    acc.add(a);
                    return () -> acc.remove(a);
                };
            }

            public Function<ConsecutiveSetTree<A, Integer, Integer>, ConsecutiveInfo<A, Integer>> finisher() {
                return tree -> tree;
            }
        };
    }

    public static <A, B, Result> BiConstraintCollector<A, B, ConsecutiveSetTree<Result, Integer, Integer>, ConsecutiveInfo<Result, Integer>> consecutive(final BiFunction<A, B, Result> resultMap, final ToIntFunction<Result> indexMap) {
        return new BiConstraintCollector<A, B, ConsecutiveSetTree<Result, Integer, Integer>, ConsecutiveInfo<Result, Integer>>(){

            public Supplier<ConsecutiveSetTree<Result, Integer, Integer>> supplier() {
                return () -> new ConsecutiveSetTree<Object, Integer, Integer>(indexMap::applyAsInt, (a, b) -> b - a, Integer::sum, 1, 0);
            }

            public TriFunction<ConsecutiveSetTree<Result, Integer, Integer>, A, B, Runnable> accumulator() {
                return (acc, a, b) -> {
                    Object result = resultMap.apply(a, b);
                    acc.add(result);
                    return () -> acc.remove(result);
                };
            }

            public Function<ConsecutiveSetTree<Result, Integer, Integer>, ConsecutiveInfo<Result, Integer>> finisher() {
                return tree -> tree;
            }
        };
    }

    public static <A, B, C, Result> TriConstraintCollector<A, B, C, ConsecutiveSetTree<Result, Integer, Integer>, ConsecutiveInfo<Result, Integer>> consecutive(final TriFunction<A, B, C, Result> resultMap, final ToIntFunction<Result> indexMap) {
        return new TriConstraintCollector<A, B, C, ConsecutiveSetTree<Result, Integer, Integer>, ConsecutiveInfo<Result, Integer>>(){

            public Supplier<ConsecutiveSetTree<Result, Integer, Integer>> supplier() {
                return () -> new ConsecutiveSetTree<Object, Integer, Integer>(indexMap::applyAsInt, (a, b) -> b - a, Integer::sum, 1, 0);
            }

            public QuadFunction<ConsecutiveSetTree<Result, Integer, Integer>, A, B, C, Runnable> accumulator() {
                return (acc, a, b, c) -> {
                    Object result = resultMap.apply(a, b, c);
                    acc.add(result);
                    return () -> acc.remove(result);
                };
            }

            public Function<ConsecutiveSetTree<Result, Integer, Integer>, ConsecutiveInfo<Result, Integer>> finisher() {
                return tree -> tree;
            }
        };
    }

    public static <A, B, C, D, Result> QuadConstraintCollector<A, B, C, D, ConsecutiveSetTree<Result, Integer, Integer>, ConsecutiveInfo<Result, Integer>> consecutive(final QuadFunction<A, B, C, D, Result> resultMap, final ToIntFunction<Result> indexMap) {
        return new QuadConstraintCollector<A, B, C, D, ConsecutiveSetTree<Result, Integer, Integer>, ConsecutiveInfo<Result, Integer>>(){

            public Supplier<ConsecutiveSetTree<Result, Integer, Integer>> supplier() {
                return () -> new ConsecutiveSetTree<Object, Integer, Integer>(indexMap::applyAsInt, (a, b) -> b - a, Integer::sum, 1, 0);
            }

            public PentaFunction<ConsecutiveSetTree<Result, Integer, Integer>, A, B, C, D, Runnable> accumulator() {
                return (acc, a, b, c, d) -> {
                    Object result = resultMap.apply(a, b, c, d);
                    acc.add(result);
                    return () -> acc.remove(result);
                };
            }

            public Function<ConsecutiveSetTree<Result, Integer, Integer>, ConsecutiveInfo<Result, Integer>> finisher() {
                return tree -> tree;
            }
        };
    }

    public static <A, PointType_ extends Comparable<PointType_>, DifferenceType_ extends Comparable<DifferenceType_>> UniConstraintCollector<A, IntervalTree<A, PointType_, DifferenceType_>, ConsecutiveIntervalInfo<A, PointType_, DifferenceType_>> consecutiveIntervals(final Function<A, PointType_> startMap, final Function<A, PointType_> endMap, final BiFunction<PointType_, PointType_, DifferenceType_> differenceFunction) {
        return new UniConstraintCollector<A, IntervalTree<A, PointType_, DifferenceType_>, ConsecutiveIntervalInfo<A, PointType_, DifferenceType_>>(){

            public Supplier<IntervalTree<A, PointType_, DifferenceType_>> supplier() {
                return () -> new IntervalTree(startMap, endMap, differenceFunction);
            }

            public BiFunction<IntervalTree<A, PointType_, DifferenceType_>, A, Runnable> accumulator() {
                return (acc, a) -> {
                    Interval interval = acc.getInterval(a);
                    acc.add(interval);
                    return () -> acc.remove(interval);
                };
            }

            public Function<IntervalTree<A, PointType_, DifferenceType_>, ConsecutiveIntervalInfo<A, PointType_, DifferenceType_>> finisher() {
                return IntervalTree::getConsecutiveIntervalData;
            }
        };
    }

    public static <A, PointType_ extends Temporal & Comparable<PointType_>> UniConstraintCollector<A, IntervalTree<A, PointType_, Duration>, ConsecutiveIntervalInfo<A, PointType_, Duration>> consecutiveTemporalIntervals(Function<A, PointType_> startMap, Function<A, PointType_> endMap) {
        return ExperimentalConstraintCollectors.consecutiveIntervals(startMap, endMap, (PointType_ x$0, PointType_ x$1) -> Duration.between((Temporal)x$0, (Temporal)x$1));
    }

    public static <A> UniConstraintCollector<A, IntervalTree<A, Long, Long>, ConsecutiveIntervalInfo<A, Long, Long>> consecutiveIntervals(ToLongFunction<A> startMap, ToLongFunction<A> endMap) {
        return ExperimentalConstraintCollectors.consecutiveIntervals(startMap::applyAsLong, endMap::applyAsLong, (PointType_ a, PointType_ b) -> b - a);
    }

    public static <A, B, IntervalType_, PointType_ extends Comparable<PointType_>, DifferenceType_ extends Comparable<DifferenceType_>> BiConstraintCollector<A, B, IntervalTree<IntervalType_, PointType_, DifferenceType_>, ConsecutiveIntervalInfo<IntervalType_, PointType_, DifferenceType_>> consecutiveIntervals(final BiFunction<A, B, IntervalType_> intervalMap, final Function<IntervalType_, PointType_> startMap, final Function<IntervalType_, PointType_> endMap, final BiFunction<PointType_, PointType_, DifferenceType_> differenceFunction) {
        return new BiConstraintCollector<A, B, IntervalTree<IntervalType_, PointType_, DifferenceType_>, ConsecutiveIntervalInfo<IntervalType_, PointType_, DifferenceType_>>(){

            public Supplier<IntervalTree<IntervalType_, PointType_, DifferenceType_>> supplier() {
                return () -> new IntervalTree(startMap, endMap, differenceFunction);
            }

            public TriFunction<IntervalTree<IntervalType_, PointType_, DifferenceType_>, A, B, Runnable> accumulator() {
                return (acc, a, b) -> {
                    Object intervalObj = intervalMap.apply(a, b);
                    Interval interval = acc.getInterval(intervalObj);
                    acc.add(interval);
                    return () -> acc.remove(interval);
                };
            }

            public Function<IntervalTree<IntervalType_, PointType_, DifferenceType_>, ConsecutiveIntervalInfo<IntervalType_, PointType_, DifferenceType_>> finisher() {
                return IntervalTree::getConsecutiveIntervalData;
            }
        };
    }

    public static <A, B, IntervalType_, PointType_ extends Temporal & Comparable<PointType_>> BiConstraintCollector<A, B, IntervalTree<IntervalType_, PointType_, Duration>, ConsecutiveIntervalInfo<IntervalType_, PointType_, Duration>> consecutiveTemporalIntervals(BiFunction<A, B, IntervalType_> intervalMap, Function<IntervalType_, PointType_> startMap, Function<IntervalType_, PointType_> endMap) {
        return ExperimentalConstraintCollectors.consecutiveIntervals(intervalMap, startMap, endMap, (PointType_ x$0, PointType_ x$1) -> Duration.between((Temporal)x$0, (Temporal)x$1));
    }

    public static <A, B, IntervalType_> BiConstraintCollector<A, B, IntervalTree<IntervalType_, Long, Long>, ConsecutiveIntervalInfo<IntervalType_, Long, Long>> consecutiveIntervals(BiFunction<A, B, IntervalType_> intervalMap, ToLongFunction<IntervalType_> startMap, ToLongFunction<IntervalType_> endMap) {
        return ExperimentalConstraintCollectors.consecutiveIntervals(intervalMap, startMap::applyAsLong, endMap::applyAsLong, (PointType_ a, PointType_ b) -> b - a);
    }

    public static <A, B, C, IntervalType_, PointType_ extends Comparable<PointType_>, DifferenceType_ extends Comparable<DifferenceType_>> TriConstraintCollector<A, B, C, IntervalTree<IntervalType_, PointType_, DifferenceType_>, ConsecutiveIntervalInfo<IntervalType_, PointType_, DifferenceType_>> consecutiveIntervals(final TriFunction<A, B, C, IntervalType_> intervalMap, final Function<IntervalType_, PointType_> startMap, final Function<IntervalType_, PointType_> endMap, final BiFunction<PointType_, PointType_, DifferenceType_> differenceFunction) {
        return new TriConstraintCollector<A, B, C, IntervalTree<IntervalType_, PointType_, DifferenceType_>, ConsecutiveIntervalInfo<IntervalType_, PointType_, DifferenceType_>>(){

            public Supplier<IntervalTree<IntervalType_, PointType_, DifferenceType_>> supplier() {
                return () -> new IntervalTree(startMap, endMap, differenceFunction);
            }

            public QuadFunction<IntervalTree<IntervalType_, PointType_, DifferenceType_>, A, B, C, Runnable> accumulator() {
                return (acc, a, b, c) -> {
                    Object intervalObj = intervalMap.apply(a, b, c);
                    Interval interval = acc.getInterval(intervalObj);
                    acc.add(interval);
                    return () -> acc.remove(interval);
                };
            }

            public Function<IntervalTree<IntervalType_, PointType_, DifferenceType_>, ConsecutiveIntervalInfo<IntervalType_, PointType_, DifferenceType_>> finisher() {
                return IntervalTree::getConsecutiveIntervalData;
            }
        };
    }

    public static <A, B, C, IntervalType_, PointType_ extends Temporal & Comparable<PointType_>> TriConstraintCollector<A, B, C, IntervalTree<IntervalType_, PointType_, Duration>, ConsecutiveIntervalInfo<IntervalType_, PointType_, Duration>> consecutiveTemporalIntervals(TriFunction<A, B, C, IntervalType_> intervalMap, Function<IntervalType_, PointType_> startMap, Function<IntervalType_, PointType_> endMap) {
        return ExperimentalConstraintCollectors.consecutiveIntervals(intervalMap, startMap, endMap, (PointType_ x$0, PointType_ x$1) -> Duration.between((Temporal)x$0, (Temporal)x$1));
    }

    public static <A, B, C, IntervalType_> TriConstraintCollector<A, B, C, IntervalTree<IntervalType_, Long, Long>, ConsecutiveIntervalInfo<IntervalType_, Long, Long>> consecutiveIntervals(TriFunction<A, B, C, IntervalType_> intervalMap, ToLongFunction<IntervalType_> startMap, ToLongFunction<IntervalType_> endMap) {
        return ExperimentalConstraintCollectors.consecutiveIntervals(intervalMap, startMap::applyAsLong, endMap::applyAsLong, (PointType_ a, PointType_ b) -> b - a);
    }

    public static <A, B, C, D, IntervalType_, PointType_ extends Comparable<PointType_>, DifferenceType_ extends Comparable<DifferenceType_>> QuadConstraintCollector<A, B, C, D, IntervalTree<IntervalType_, PointType_, DifferenceType_>, ConsecutiveIntervalInfo<IntervalType_, PointType_, DifferenceType_>> consecutiveIntervals(final QuadFunction<A, B, C, D, IntervalType_> intervalMap, final Function<IntervalType_, PointType_> startMap, final Function<IntervalType_, PointType_> endMap, final BiFunction<PointType_, PointType_, DifferenceType_> differenceFunction) {
        return new QuadConstraintCollector<A, B, C, D, IntervalTree<IntervalType_, PointType_, DifferenceType_>, ConsecutiveIntervalInfo<IntervalType_, PointType_, DifferenceType_>>(){

            public Supplier<IntervalTree<IntervalType_, PointType_, DifferenceType_>> supplier() {
                return () -> new IntervalTree(startMap, endMap, differenceFunction);
            }

            public PentaFunction<IntervalTree<IntervalType_, PointType_, DifferenceType_>, A, B, C, D, Runnable> accumulator() {
                return (acc, a, b, c, d) -> {
                    Object intervalObj = intervalMap.apply(a, b, c, d);
                    Interval interval = acc.getInterval(intervalObj);
                    acc.add(interval);
                    return () -> acc.remove(interval);
                };
            }

            public Function<IntervalTree<IntervalType_, PointType_, DifferenceType_>, ConsecutiveIntervalInfo<IntervalType_, PointType_, DifferenceType_>> finisher() {
                return IntervalTree::getConsecutiveIntervalData;
            }
        };
    }

    public static <A, B, C, D, IntervalType_, PointType_ extends Temporal & Comparable<PointType_>> QuadConstraintCollector<A, B, C, D, IntervalTree<IntervalType_, PointType_, Duration>, ConsecutiveIntervalInfo<IntervalType_, PointType_, Duration>> consecutiveTemporalIntervals(QuadFunction<A, B, C, D, IntervalType_> intervalMap, Function<IntervalType_, PointType_> startMap, Function<IntervalType_, PointType_> endMap) {
        return ExperimentalConstraintCollectors.consecutiveIntervals(intervalMap, startMap, endMap, (PointType_ x$0, PointType_ x$1) -> Duration.between((Temporal)x$0, (Temporal)x$1));
    }

    public static <A, B, C, D, IntervalType_> QuadConstraintCollector<A, B, C, D, IntervalTree<IntervalType_, Long, Long>, ConsecutiveIntervalInfo<IntervalType_, Long, Long>> consecutiveIntervals(QuadFunction<A, B, C, D, IntervalType_> intervalMap, ToLongFunction<IntervalType_> startMap, ToLongFunction<IntervalType_> endMap) {
        return ExperimentalConstraintCollectors.consecutiveIntervals(intervalMap, startMap::applyAsLong, endMap::applyAsLong, (PointType_ a, PointType_ b) -> b - a);
    }

    private ExperimentalConstraintCollectors() {
    }
}

