/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.domain.solver;

import java.util.Comparator;
import java.util.Objects;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.examination.domain.Topic;

public class TopicConflict
implements Comparable<TopicConflict> {
    private static final Comparator<Topic> TOPIC_COMPARATOR = Comparator.comparingLong(AbstractPersistable::getId);
    private static final Comparator<TopicConflict> COMPARATOR = Comparator.comparing(TopicConflict::getLeftTopic, TOPIC_COMPARATOR).thenComparing(TopicConflict::getRightTopic, TOPIC_COMPARATOR);
    private Topic leftTopic;
    private Topic rightTopic;
    private int studentSize;

    public TopicConflict(Topic leftTopic, Topic rightTopic, int studentSize) {
        this.leftTopic = leftTopic;
        this.rightTopic = rightTopic;
        this.studentSize = studentSize;
    }

    public Topic getLeftTopic() {
        return this.leftTopic;
    }

    public void setLeftTopic(Topic leftTopic) {
        this.leftTopic = leftTopic;
    }

    public Topic getRightTopic() {
        return this.rightTopic;
    }

    public void setRightTopic(Topic rightTopic) {
        this.rightTopic = rightTopic;
    }

    public int getStudentSize() {
        return this.studentSize;
    }

    public void setStudentSize(int studentSize) {
        this.studentSize = studentSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicConflict other = (TopicConflict)o;
        return Objects.equals(this.leftTopic, other.leftTopic) && Objects.equals(this.rightTopic, other.rightTopic);
    }

    public int hashCode() {
        return Objects.hash(this.leftTopic, this.rightTopic);
    }

    @Override
    public int compareTo(TopicConflict other) {
        return COMPARATOR.compare(this, other);
    }

    public String toString() {
        return this.leftTopic + " & " + this.rightTopic + " = " + this.studentSize;
    }
}

