/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.taskassigning.domain.solver;

import java.util.Objects;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.examples.taskassigning.domain.Employee;
import org.optaplanner.examples.taskassigning.domain.Task;
import org.optaplanner.examples.taskassigning.domain.TaskAssigningSolution;

public class StartTimeUpdatingVariableListener
implements VariableListener<TaskAssigningSolution, Task> {
    public void beforeEntityAdded(ScoreDirector<TaskAssigningSolution> scoreDirector, Task task) {
    }

    public void afterEntityAdded(ScoreDirector<TaskAssigningSolution> scoreDirector, Task task) {
        this.updateStartTime(scoreDirector, task);
    }

    public void beforeVariableChanged(ScoreDirector<TaskAssigningSolution> scoreDirector, Task task) {
    }

    public void afterVariableChanged(ScoreDirector<TaskAssigningSolution> scoreDirector, Task task) {
        this.updateStartTime(scoreDirector, task);
    }

    public void beforeEntityRemoved(ScoreDirector<TaskAssigningSolution> scoreDirector, Task task) {
    }

    public void afterEntityRemoved(ScoreDirector<TaskAssigningSolution> scoreDirector, Task task) {
    }

    protected void updateStartTime(ScoreDirector<TaskAssigningSolution> scoreDirector, Task task) {
        Integer startTime = this.calculateStartTime(task);
        if (!Objects.equals(task.getStartTime(), startTime)) {
            scoreDirector.beforeVariableChanged((Object)task, "startTime");
            task.setStartTime(startTime);
            scoreDirector.afterVariableChanged((Object)task, "startTime");
        }
    }

    private Integer calculateStartTime(Task task) {
        Integer previousEndTime;
        Employee employee = task.getEmployee();
        if (employee == null) {
            return null;
        }
        Integer index = task.getIndex();
        Integer n = previousEndTime = index == 0 ? Integer.valueOf(0) : employee.getTasks().get(index - 1).getEndTime();
        if (previousEndTime == null) {
            return null;
        }
        return Math.max(task.getReadyTime(), previousEndTime);
    }
}

