/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import org.optaplanner.examples.common.experimental.api.ConsecutiveIntervalInfo;
import org.optaplanner.examples.common.experimental.api.IntervalBreak;
import org.optaplanner.examples.common.experimental.api.IntervalCluster;
import org.optaplanner.examples.common.experimental.impl.Interval;
import org.optaplanner.examples.common.experimental.impl.IntervalBreakImpl;
import org.optaplanner.examples.common.experimental.impl.IntervalClusterImpl;
import org.optaplanner.examples.common.experimental.impl.IntervalSplitPoint;
import org.optaplanner.examples.common.experimental.impl.MapValuesIterable;

public final class ConsecutiveIntervalInfoImpl<Interval_, Point_ extends Comparable<Point_>, Difference_ extends Comparable<Difference_>>
implements ConsecutiveIntervalInfo<Interval_, Point_, Difference_> {
    private final NavigableMap<IntervalSplitPoint<Interval_, Point_>, IntervalClusterImpl<Interval_, Point_, Difference_>> clusterStartSplitPointToCluster = new TreeMap<IntervalSplitPoint<Interval_, Point_>, IntervalClusterImpl<Interval_, Point_, Difference_>>();
    private final NavigableSet<IntervalSplitPoint<Interval_, Point_>> splitPointSet;
    private final NavigableMap<IntervalSplitPoint<Interval_, Point_>, IntervalBreakImpl<Interval_, Point_, Difference_>> clusterStartSplitPointToNextBreak = new TreeMap<IntervalSplitPoint<Interval_, Point_>, IntervalBreakImpl<Interval_, Point_, Difference_>>();
    private final Iterable<IntervalCluster<Interval_, Point_, Difference_>> intervalClusterIterable = new MapValuesIterable<IntervalSplitPoint<Interval_, Point_>, IntervalClusterImpl<Interval_, Point_, Difference_>>(this.clusterStartSplitPointToCluster);
    private final BiFunction<Point_, Point_, Difference_> differenceFunction;
    private final Iterable<IntervalBreak<Interval_, Point_, Difference_>> breaksIterable = new MapValuesIterable<IntervalSplitPoint<Interval_, Point_>, IntervalBreakImpl<Interval_, Point_, Difference_>>(this.clusterStartSplitPointToNextBreak);

    public ConsecutiveIntervalInfoImpl(TreeSet<IntervalSplitPoint<Interval_, Point_>> splitPointSet, BiFunction<Point_, Point_, Difference_> differenceFunction) {
        this.splitPointSet = splitPointSet;
        this.differenceFunction = differenceFunction;
    }

    void addInterval(Interval<Interval_, Point_> interval) {
        NavigableMap<IntervalSplitPoint<Interval_, Point_>, IntervalClusterImpl<Interval_, Point_, Difference_>> intersectedIntervalClusterMap = this.clusterStartSplitPointToCluster.subMap(Objects.requireNonNullElseGet(this.clusterStartSplitPointToCluster.floorKey(interval.getStartSplitPoint()), interval::getStartSplitPoint), true, interval.getEndSplitPoint(), true);
        if (!intersectedIntervalClusterMap.isEmpty() && intersectedIntervalClusterMap.firstEntry().getValue().getEndSplitPoint().isBefore(interval.getStartSplitPoint())) {
            intersectedIntervalClusterMap = intersectedIntervalClusterMap.subMap((IntervalSplitPoint)intersectedIntervalClusterMap.firstKey(), false, (IntervalSplitPoint)intersectedIntervalClusterMap.lastKey(), true);
        }
        if (intersectedIntervalClusterMap.isEmpty()) {
            this.createNewIntervalCluster(interval);
            return;
        }
        IntervalClusterImpl<Interval_, Point_, Difference_> firstIntersectedIntervalCluster = intersectedIntervalClusterMap.firstEntry().getValue();
        IntervalSplitPoint<Interval_, Point_> oldStartSplitPoint = firstIntersectedIntervalCluster.getStartSplitPoint();
        firstIntersectedIntervalCluster.addInterval(interval);
        intersectedIntervalClusterMap.tailMap(oldStartSplitPoint, false).values().forEach(firstIntersectedIntervalCluster::mergeIntervalCluster);
        intersectedIntervalClusterMap.tailMap(oldStartSplitPoint, false).clear();
        this.removeSpannedBreaksAndUpdateIntersectedBreaks(interval, firstIntersectedIntervalCluster);
        if (oldStartSplitPoint.isAfter(firstIntersectedIntervalCluster.getStartSplitPoint())) {
            this.clusterStartSplitPointToCluster.remove(oldStartSplitPoint);
            this.clusterStartSplitPointToCluster.put(firstIntersectedIntervalCluster.getStartSplitPoint(), firstIntersectedIntervalCluster);
            IntervalBreakImpl nextBreak = (IntervalBreakImpl)this.clusterStartSplitPointToNextBreak.get(firstIntersectedIntervalCluster.getStartSplitPoint());
            if (nextBreak != null) {
                nextBreak.setPreviousCluster(firstIntersectedIntervalCluster);
                nextBreak.setLength((Comparable)this.differenceFunction.apply(nextBreak.getPreviousIntervalClusterEnd(), nextBreak.getNextIntervalClusterStart()));
            }
        }
    }

    private void createNewIntervalCluster(Interval<Interval_, Point_> interval) {
        Map.Entry<IntervalSplitPoint<Interval_, Point_>, IntervalClusterImpl<Interval_, Point_, Difference_>> previousClusterEntry;
        IntervalSplitPoint<Interval_, Point_> startSplitPoint = this.splitPointSet.floor(interval.getStartSplitPoint());
        IntervalClusterImpl<Interval_, Point_, Difference_> newCluster = new IntervalClusterImpl<Interval_, Point_, Difference_>(this.splitPointSet, this.differenceFunction, startSplitPoint);
        this.clusterStartSplitPointToCluster.put(startSplitPoint, newCluster);
        Map.Entry<IntervalSplitPoint<Interval_, Point_>, IntervalClusterImpl<Interval_, Point_, Difference_>> nextClusterEntry = this.clusterStartSplitPointToCluster.higherEntry(startSplitPoint);
        if (nextClusterEntry != null) {
            IntervalClusterImpl<Interval_, Point_, Difference_> nextCluster = nextClusterEntry.getValue();
            Comparable difference = (Comparable)this.differenceFunction.apply(newCluster.getEnd(), nextCluster.getStart());
            IntervalBreakImpl<Interval_, Point_, Comparable> newBreak = new IntervalBreakImpl<Interval_, Point_, Comparable>(newCluster, nextCluster, difference);
            this.clusterStartSplitPointToNextBreak.put(startSplitPoint, newBreak);
        }
        if ((previousClusterEntry = this.clusterStartSplitPointToCluster.lowerEntry(startSplitPoint)) != null) {
            IntervalClusterImpl<Interval_, Point_, Difference_> previousCluster = previousClusterEntry.getValue();
            Comparable difference = (Comparable)this.differenceFunction.apply(previousCluster.getEnd(), newCluster.getStart());
            IntervalBreakImpl<Interval_, Point_, Comparable> newBreak = new IntervalBreakImpl<Interval_, Point_, Comparable>(previousCluster, newCluster, difference);
            this.clusterStartSplitPointToNextBreak.put(previousClusterEntry.getKey(), newBreak);
        }
    }

    private void removeSpannedBreaksAndUpdateIntersectedBreaks(Interval<Interval_, Point_> interval, IntervalClusterImpl<Interval_, Point_, Difference_> intervalCluster) {
        IntervalSplitPoint firstBreakSplitPointBeforeInterval = Objects.requireNonNullElseGet(this.clusterStartSplitPointToNextBreak.floorKey(interval.getStartSplitPoint()), interval::getStartSplitPoint);
        NavigableMap<IntervalSplitPoint<Interval_, Point_>, IntervalBreakImpl<Interval_, Point_, Difference_>> intersectedIntervalBreakMap = this.clusterStartSplitPointToNextBreak.subMap(firstBreakSplitPointBeforeInterval, true, interval.getEndSplitPoint(), true);
        if (intersectedIntervalBreakMap.isEmpty()) {
            return;
        }
        IntervalClusterImpl clusterBeforeFirstIntersectedBreak = (IntervalClusterImpl)intersectedIntervalBreakMap.firstEntry().getValue().getPreviousIntervalCluster();
        IntervalClusterImpl clusterAfterFinalIntersectedBreak = (IntervalClusterImpl)intersectedIntervalBreakMap.lastEntry().getValue().getNextIntervalCluster();
        if (!interval.getStartSplitPoint().isAfter(clusterBeforeFirstIntersectedBreak.getEndSplitPoint())) {
            if (!interval.getEndSplitPoint().isBefore(clusterAfterFinalIntersectedBreak.getStartSplitPoint())) {
                intersectedIntervalBreakMap.clear();
            } else {
                IntervalBreakImpl<Interval_, Point_, Difference_> finalBreak = intersectedIntervalBreakMap.lastEntry().getValue();
                finalBreak.setPreviousCluster(intervalCluster);
                finalBreak.setLength((Comparable)this.differenceFunction.apply(finalBreak.getPreviousIntervalClusterEnd(), finalBreak.getNextIntervalClusterStart()));
                intersectedIntervalBreakMap.clear();
                this.clusterStartSplitPointToNextBreak.put(intervalCluster.getStartSplitPoint(), finalBreak);
            }
        } else if (!interval.getEndSplitPoint().isBefore(clusterAfterFinalIntersectedBreak.getStartSplitPoint())) {
            Map.Entry<IntervalSplitPoint<Interval_, Point_>, IntervalBreakImpl<Interval_, Point_, Difference_>> previousBreakEntry = intersectedIntervalBreakMap.firstEntry();
            IntervalBreakImpl<Interval_, Point_, Difference_> previousBreak = previousBreakEntry.getValue();
            previousBreak.setNextCluster(intervalCluster);
            previousBreak.setLength((Comparable)this.differenceFunction.apply(previousBreak.getPreviousIntervalClusterEnd(), intervalCluster.getStart()));
            intersectedIntervalBreakMap.clear();
            this.clusterStartSplitPointToNextBreak.put(((IntervalClusterImpl)previousBreak.getPreviousIntervalCluster()).getStartSplitPoint(), previousBreak);
        } else {
            IntervalBreakImpl<Interval_, Point_, Comparable> finalBreak = intersectedIntervalBreakMap.lastEntry().getValue();
            finalBreak.setLength((Comparable)this.differenceFunction.apply(finalBreak.getPreviousIntervalClusterEnd(), finalBreak.getNextIntervalClusterStart()));
            Map.Entry<IntervalSplitPoint<Interval_, Point_>, IntervalBreakImpl<Interval_, Point_, Difference_>> previousBreakEntry = intersectedIntervalBreakMap.firstEntry();
            IntervalBreakImpl<Interval_, Point_, Difference_> previousBreak = previousBreakEntry.getValue();
            previousBreak.setNextCluster(intervalCluster);
            previousBreak.setLength((Comparable)this.differenceFunction.apply(previousBreak.getPreviousIntervalClusterEnd(), intervalCluster.getStart()));
            intersectedIntervalBreakMap.clear();
            this.clusterStartSplitPointToNextBreak.put(previousBreakEntry.getKey(), previousBreak);
            this.clusterStartSplitPointToNextBreak.put(intervalCluster.getStartSplitPoint(), finalBreak);
        }
    }

    void removeInterval(Interval<Interval_, Point_> interval) {
        Map.Entry<IntervalSplitPoint<Interval_, Point_>, IntervalClusterImpl<Interval_, Point_, Difference_>> intervalClusterEntry = this.clusterStartSplitPointToCluster.floorEntry(interval.getStartSplitPoint());
        IntervalClusterImpl<Interval_, Point_, Difference_> intervalCluster = intervalClusterEntry.getValue();
        this.clusterStartSplitPointToCluster.remove(intervalClusterEntry.getKey());
        Map.Entry<IntervalSplitPoint<Interval_, Point_>, IntervalBreakImpl<Interval_, Point_, Difference_>> previousBreakEntry = this.clusterStartSplitPointToNextBreak.lowerEntry(intervalClusterEntry.getKey());
        Map.Entry<IntervalSplitPoint<Interval_, Point_>, IntervalClusterImpl<Interval_, Point_, Difference_>> nextIntervalClusterEntry = this.clusterStartSplitPointToCluster.higherEntry(intervalClusterEntry.getKey());
        this.clusterStartSplitPointToNextBreak.remove(intervalClusterEntry.getKey());
        IntervalBreakImpl<Interval_, Point_, Object> previousBreak = previousBreakEntry != null ? previousBreakEntry.getValue() : null;
        IntervalClusterImpl<Interval_, Point_, Difference_> previousIntervalCluster = previousBreak != null ? (IntervalClusterImpl<Interval_, Point_, Difference_>)previousBreak.getPreviousIntervalCluster() : null;
        for (IntervalClusterImpl<Interval_, Point_, Difference_> newIntervalCluster : intervalCluster.removeInterval(interval)) {
            if (previousBreak != null) {
                previousBreak.setNextCluster(newIntervalCluster);
                previousBreak.setLength((Comparable)this.differenceFunction.apply(previousBreak.getPreviousIntervalCluster().getEnd(), newIntervalCluster.getStart()));
                this.clusterStartSplitPointToNextBreak.put(((IntervalClusterImpl)previousBreak.getPreviousIntervalCluster()).getStartSplitPoint(), previousBreak);
            }
            previousBreak = new IntervalBreakImpl<Interval_, Point_, Object>(newIntervalCluster, null, null);
            previousIntervalCluster = newIntervalCluster;
            this.clusterStartSplitPointToCluster.put(newIntervalCluster.getStartSplitPoint(), newIntervalCluster);
        }
        if (nextIntervalClusterEntry != null && previousBreak != null) {
            previousBreak.setNextCluster((IntervalCluster)nextIntervalClusterEntry.getValue());
            previousBreak.setLength((Comparable)this.differenceFunction.apply(previousIntervalCluster.getEnd(), nextIntervalClusterEntry.getValue().getStart()));
            this.clusterStartSplitPointToNextBreak.put(previousIntervalCluster.getStartSplitPoint(), previousBreak);
        } else if (previousBreakEntry != null && previousBreak == previousBreakEntry.getValue()) {
            this.clusterStartSplitPointToNextBreak.remove(previousBreakEntry.getKey());
        }
    }

    @Override
    public Iterable<IntervalCluster<Interval_, Point_, Difference_>> getIntervalClusters() {
        return this.intervalClusterIterable;
    }

    @Override
    public Iterable<IntervalBreak<Interval_, Point_, Difference_>> getBreaks() {
        return this.breaksIterable;
    }

    public String toString() {
        return "Clusters {intervalClusters=" + this.intervalClusterIterable + ", breaks=" + this.breaksIterable + "}";
    }
}

