/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.swingui.realtime;

import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaplanner.core.api.solver.change.ProblemChangeDirector;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;

public class AddProcessProblemChange
implements ProblemChange<CloudBalance> {
    private final CloudProcess process;

    public AddProcessProblemChange(CloudProcess process) {
        this.process = process;
    }

    public void doChange(CloudBalance cloudBalance, ProblemChangeDirector problemChangeDirector) {
        long nextProcessId = 0L;
        for (CloudProcess otherProcess : cloudBalance.getProcessList()) {
            if (nextProcessId > otherProcess.getId()) continue;
            nextProcessId = otherProcess.getId() + 1L;
        }
        this.process.setId(nextProcessId);
        problemChangeDirector.addEntity((Object)this.process, cloudBalance.getProcessList()::add);
    }
}

