/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.swingui.timetable;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.optaplanner.examples.common.swingui.timetable.TimeTableLayoutConstraints;

public class TimeTableLayout
implements LayoutManager2 {
    public static final int FILL_COLLISIONS_FLAG = -1;
    private List<Column> columns;
    private List<Row> rows;
    private List<List<Cell>> cells;
    private Map<Component, ComponentSpan> spanMap;
    private boolean stale;
    private int totalColumnWidth;
    private int totalRowHeight;

    public TimeTableLayout() {
        this.reset();
    }

    public void reset() {
        this.columns = new ArrayList<Column>();
        this.rows = new ArrayList<Row>();
        this.cells = new ArrayList<List<Cell>>();
        this.spanMap = new HashMap<Component, ComponentSpan>();
        this.stale = false;
        this.totalColumnWidth = 0;
        this.totalRowHeight = 0;
    }

    public int addColumn() {
        return this.addColumn(true, 0);
    }

    public int addColumn(int baseWidth) {
        if (baseWidth < 0) {
            throw new IllegalArgumentException("Invalid baseWidth (" + baseWidth + ").");
        }
        return this.addColumn(false, baseWidth);
    }

    private int addColumn(boolean autoWidth, int baseWidth) {
        if (this.rows.size() > 0) {
            throw new IllegalStateException("Add all columns before adding rows");
        }
        this.stale = true;
        int index = this.columns.size();
        Column column = new Column(index, autoWidth, baseWidth);
        this.columns.add(column);
        this.cells.add(new ArrayList());
        return index;
    }

    public int addRow() {
        return this.addRow(true, 0);
    }

    public int addRow(int baseHeight) {
        if (baseHeight < 0) {
            throw new IllegalArgumentException("Invalid baseHeight (" + baseHeight + ").");
        }
        return this.addRow(false, baseHeight);
    }

    public int addRow(boolean autoHeight, int baseHeight) {
        this.stale = true;
        int index = this.rows.size();
        Row row = new Row(index, autoHeight, baseHeight);
        this.rows.add(row);
        for (int i = 0; i < this.columns.size(); ++i) {
            Column column = this.columns.get(i);
            this.cells.get(i).add(new Cell(column, row));
        }
        return index;
    }

    @Override
    public void addLayoutComponent(Component component, Object o) {
        TimeTableLayoutConstraints c = (TimeTableLayoutConstraints)o;
        if (c.getXEnd() > this.columns.size()) {
            throw new IllegalArgumentException("The xEnd (" + c.getXEnd() + ") is > columnsSize (" + this.columns.size() + ").");
        }
        if (c.getYEnd() > this.rows.size()) {
            throw new IllegalArgumentException("The yEnd (" + c.getYEnd() + ") is > rowsSize (" + this.rows.size() + ").");
        }
        this.stale = true;
        ComponentSpan span = new ComponentSpan(component);
        this.spanMap.put(component, span);
        span.topLeftCell = this.cells.get(c.getX()).get(c.getY());
        span.bottomRightCell = this.cells.get(c.getXEnd() - 1).get(c.getYEnd() - 1);
        HashSet<Integer> occupiedCollisionIndexes = new HashSet<Integer>();
        for (int i = c.getX(); i < c.getXEnd(); ++i) {
            for (int j = c.getY(); j < c.getYEnd(); ++j) {
                Cell cell = this.cells.get(i).get(j);
                cell.column.stale = true;
                cell.row.stale = true;
                cell.spans.add(span);
                span.cells.add(cell);
                occupiedCollisionIndexes.addAll(cell.occupiedCollisionIndexes);
            }
        }
        Integer collisionIndex = 0;
        while (occupiedCollisionIndexes.contains(collisionIndex)) {
            Integer n = collisionIndex;
            Integer n2 = collisionIndex = Integer.valueOf(collisionIndex + 1);
        }
        if (c.isFillCollisions()) {
            if (collisionIndex != 0 || occupiedCollisionIndexes.contains(-1)) {
                throw new IllegalArgumentException("There is a collision in the cell range (" + (Serializable)(c.getX() == c.getXEnd() - 1 ? Integer.valueOf(c.getX()) : c.getX() + "-" + (c.getXEnd() - 1)) + ", " + (Serializable)(c.getY() == c.getYEnd() - 1 ? Integer.valueOf(c.getY()) : c.getY() + "-" + (c.getYEnd() - 1)) + ").");
            }
            collisionIndex = -1;
        }
        span.collisionIndex = collisionIndex;
        for (Cell cell : span.cells) {
            cell.occupiedCollisionIndexes.add(collisionIndex);
        }
    }

    @Override
    public void addLayoutComponent(String name, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.stale = true;
        ComponentSpan span = this.spanMap.remove(component);
        for (Cell cell : span.cells) {
            cell.spans.remove(span);
            cell.column.stale = true;
            cell.row.stale = true;
            cell.occupiedCollisionIndexes.remove(span.collisionIndex);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        this.update();
        return new Dimension(this.totalColumnWidth, this.totalRowHeight);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        this.update();
        return new Dimension(this.totalColumnWidth, this.totalRowHeight);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        this.update();
        return new Dimension(this.totalColumnWidth, this.totalRowHeight);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        this.update();
        Object object = parent.getTreeLock();
        synchronized (object) {
            for (ComponentSpan span : this.spanMap.values()) {
                int x1 = span.topLeftCell.column.boundX;
                int collisionIndexStart = span.collisionIndex == -1 ? 0 : span.collisionIndex;
                int y1 = span.topLeftCell.row.boundY + collisionIndexStart * span.topLeftCell.row.baseHeight;
                int x2 = span.bottomRightCell.column.boundX + span.bottomRightCell.column.baseWidth;
                int collisionIndexEnd = span.collisionIndex == -1 ? span.bottomRightCell.row.collisionCount : span.collisionIndex + 1;
                int y2 = span.bottomRightCell.row.boundY + collisionIndexEnd * span.bottomRightCell.row.baseHeight;
                span.component.setBounds(x1, y1, x2 - x1, y2 - y1);
            }
        }
    }

    public void update() {
        if (!this.stale) {
            return;
        }
        this.refreshColumns();
        this.refreshRows();
        this.stale = false;
    }

    private void refreshColumns() {
        for (Column column : this.columns) {
            if (!column.stale) continue;
            if (column.autoWidth) {
                column.baseWidth = this.getMaxCellWidth(column);
            }
            column.stale = false;
        }
        this.refreshColumnsBoundX();
    }

    private int getMaxCellWidth(Column column) {
        int maxCellWidth = 0;
        for (int i = 0; i < this.rows.size(); ++i) {
            Cell cell = this.cells.get(column.index).get(i);
            for (ComponentSpan span : cell.spans) {
                int width = span.getPreferredWidthPerCell();
                if (width <= maxCellWidth) continue;
                maxCellWidth = width;
            }
        }
        return maxCellWidth;
    }

    private void refreshColumnsBoundX() {
        int nextColumnBoundX = 0;
        for (Column column : this.columns) {
            column.boundX = nextColumnBoundX;
            nextColumnBoundX += column.baseWidth;
        }
        this.totalColumnWidth = nextColumnBoundX;
    }

    private void refreshRows() {
        for (Row row : this.rows) {
            if (row.stale) {
                if (row.autoHeight) {
                    row.baseHeight = this.getMaxCellHeight(row);
                }
                row.collisionCount = this.getMaxCollisionCount(row);
            }
            row.stale = false;
        }
        this.freshRowsBoundY();
    }

    private int getMaxCellHeight(Row row) {
        int maxCellHeight = 0;
        for (int i = 0; i < this.columns.size(); ++i) {
            Cell cell = this.cells.get(i).get(row.index);
            for (ComponentSpan span : cell.spans) {
                int height = span.getPreferredHeightPerCell();
                if (height <= maxCellHeight) continue;
                maxCellHeight = height;
            }
        }
        return maxCellHeight;
    }

    private int getMaxCollisionCount(Row row) {
        int maxCollisionCount = 1;
        for (int i = 0; i < this.columns.size(); ++i) {
            Cell cell = this.cells.get(i).get(row.index);
            if (cell.occupiedCollisionIndexes.size() <= maxCollisionCount) continue;
            maxCollisionCount = cell.occupiedCollisionIndexes.size();
        }
        return maxCollisionCount;
    }

    private void freshRowsBoundY() {
        int nextRowBoundY = 0;
        for (Row row : this.rows) {
            row.boundY = nextRowBoundY;
            nextRowBoundY += row.baseHeight * row.collisionCount;
        }
        this.totalRowHeight = nextRowBoundY;
    }

    private static class ComponentSpan {
        private Component component;
        private Set<Cell> cells = new HashSet<Cell>();
        private Cell topLeftCell;
        private Cell bottomRightCell;
        private Integer collisionIndex;

        private ComponentSpan(Component component) {
            this.component = component;
        }

        public int getPreferredWidthPerCell() {
            int width = this.component.getPreferredSize().width;
            int horizontalCellSize = this.bottomRightCell.column.index - this.topLeftCell.column.index + 1;
            return (width + (horizontalCellSize - 1)) / horizontalCellSize;
        }

        public int getPreferredHeightPerCell() {
            int height = this.component.getPreferredSize().height;
            int verticalCellSize = this.bottomRightCell.row.index - this.topLeftCell.row.index + 1;
            return (height + (verticalCellSize - 1)) / verticalCellSize;
        }
    }

    private static class Cell {
        private Column column;
        private Row row;
        private Set<ComponentSpan> spans = new HashSet<ComponentSpan>();
        private Set<Integer> occupiedCollisionIndexes = new HashSet<Integer>();

        private Cell(Column column, Row row) {
            this.column = column;
            this.row = row;
        }
    }

    private static class Row {
        private final int index;
        private final boolean autoHeight;
        private boolean stale;
        private int baseHeight;
        private int collisionCount = 1;
        private int boundY = -1;

        private Row(int index, boolean autoHeight, int baseHeight) {
            this.index = index;
            this.autoHeight = autoHeight;
            this.stale = true;
            this.baseHeight = baseHeight;
        }
    }

    private static class Column {
        private final int index;
        private final boolean autoWidth;
        private boolean stale;
        private int baseWidth;
        private int boundX = -1;

        private Column(int index, boolean autoWidth, int baseWidth) {
            this.index = index;
            this.autoWidth = autoWidth;
            this.stale = true;
            this.baseWidth = baseWidth;
        }
    }
}

