/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.persistence;

import java.io.IOException;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionExporter;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.TspSolution;
import org.optaplanner.examples.tsp.domain.Visit;
import org.optaplanner.examples.tsp.domain.location.Location;

public abstract class AbstractSvgTspOutputBuilder
extends AbstractTxtSolutionExporter.TxtOutputBuilder<TspSolution> {
    double width = 0.0;
    double height = 0.0;
    double offsetX = 0.0;
    double offsetY = 0.0;

    void writeSvgHeader() throws IOException {
        this.bufferedWriter.write("<?xml version='1.0'?>\n");
        this.bufferedWriter.write("<svg xmlns='http://www.w3.org/2000/svg' version='1.2' baseProfile='tiny' \n");
        this.bufferedWriter.write("width='" + (this.width + this.offsetX) + "px' height='" + (this.height + this.offsetY) + "px'>\n");
    }

    void determineSizeAndOffset(TspSolution solution) {
        AbstractPersistable standstill = solution.getDomicile();
        while (standstill != null) {
            Location location = standstill.getLocation();
            if (location.getLongitude() > this.width) {
                this.width = location.getLongitude();
            }
            if (location.getLatitude() > this.height) {
                this.height = location.getLatitude();
            }
            if (location.getLongitude() < this.offsetX) {
                this.offsetX = location.getLongitude();
            }
            if (location.getLatitude() < this.offsetY) {
                this.offsetY = location.getLatitude();
            }
            standstill = this.findNextVisit((Standstill)((Object)standstill));
        }
        this.height *= 1.05;
        this.width *= 1.05;
        this.offsetY = -this.offsetY;
        this.offsetX = -this.offsetX;
    }

    Visit findNextVisit(Standstill standstill) {
        for (Visit visit : ((TspSolution)this.solution).getVisitList()) {
            if (visit.getPreviousStandstill() != standstill) continue;
            return visit;
        }
        return null;
    }
}

