/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.score;

import java.util.Objects;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceConstraintConfiguration;
import org.optaplanner.examples.conferencescheduling.domain.Speaker;
import org.optaplanner.examples.conferencescheduling.domain.Talk;

public final class ConferenceSchedulingConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory factory) {
        return new Constraint[]{this.roomUnavailableTimeslot(factory), this.roomConflict(factory), this.speakerUnavailableTimeslot(factory), this.speakerConflict(factory), this.talkPrerequisiteTalks(factory), this.talkMutuallyExclusiveTalksTags(factory), this.consecutiveTalksPause(factory), this.crowdControl(factory), this.speakerRequiredTimeslotTags(factory), this.speakerProhibitedTimeslotTags(factory), this.talkRequiredTimeslotTags(factory), this.talkProhibitedTimeslotTags(factory), this.speakerRequiredRoomTags(factory), this.speakerProhibitedRoomTags(factory), this.talkRequiredRoomTags(factory), this.talkProhibitedRoomTags(factory), this.publishedTimeslot(factory), this.publishedRoom(factory), this.themeTrackConflict(factory), this.themeTrackRoomStability(factory), this.sectorConflict(factory), this.audienceTypeDiversity(factory), this.audienceTypeThemeTrackConflict(factory), this.audienceLevelDiversity(factory), this.contentAudienceLevelFlowViolation(factory), this.contentConflict(factory), this.languageDiversity(factory), this.sameDayTalks(factory), this.popularTalks(factory), this.speakerPreferredTimeslotTags(factory), this.speakerUndesiredTimeslotTags(factory), this.talkPreferredTimeslotTags(factory), this.talkUndesiredTimeslotTags(factory), this.speakerPreferredRoomTags(factory), this.speakerUndesiredRoomTags(factory), this.talkPreferredRoomTags(factory), this.talkUndesiredRoomTags(factory)};
    }

    protected Constraint roomUnavailableTimeslot(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(Talk::hasUnavailableRoom).penalizeConfigurable("Room unavailable timeslot", Talk::getDurationInMinutes);
    }

    protected Constraint roomConflict(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.equal(Talk::getRoom), Joiners.overlapping(t -> t.getTimeslot().getStartDateTime(), t -> t.getTimeslot().getEndDateTime())).penalizeConfigurable("Room conflict", Talk::overlappingDurationInMinutes);
    }

    protected Constraint speakerUnavailableTimeslot(ConstraintFactory factory) {
        return factory.forEachIncludingNullVars(Talk.class).filter(talk -> talk.getTimeslot() != null).join(Speaker.class, Joiners.filtering((talk, speaker) -> talk.hasSpeaker((Speaker)speaker) && speaker.getUnavailableTimeslotSet().contains(talk.getTimeslot()))).penalizeConfigurable("Speaker unavailable timeslot", (talk, speaker) -> talk.getDurationInMinutes());
    }

    protected Constraint speakerConflict(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.overlapping(t -> t.getTimeslot().getStartDateTime(), t -> t.getTimeslot().getEndDateTime())).join(Speaker.class, Joiners.filtering((talk1, talk2, speaker) -> talk1.hasSpeaker((Speaker)speaker) && talk2.hasSpeaker((Speaker)speaker))).penalizeConfigurable("Speaker conflict", (talk1, talk2, speaker) -> talk2.overlappingDurationInMinutes((Talk)talk1));
    }

    protected Constraint talkPrerequisiteTalks(ConstraintFactory factory) {
        return factory.forEach(Talk.class).join(Talk.class, Joiners.greaterThan(t -> t.getTimeslot().getEndDateTime(), t -> t.getTimeslot().getStartDateTime()), Joiners.filtering((talk1, talk2) -> talk2.getPrerequisiteTalkSet().contains(talk1))).penalizeConfigurable("Talk prerequisite talks", Talk::combinedDurationInMinutes);
    }

    protected Constraint talkMutuallyExclusiveTalksTags(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.overlapping(t -> t.getTimeslot().getStartDateTime(), t -> t.getTimeslot().getEndDateTime()), Joiners.filtering((talk1, talk2) -> talk2.overlappingMutuallyExclusiveTalksTagCount((Talk)talk1) > 0)).penalizeConfigurable("Talk mutually-exclusive-talks tags", (talk1, talk2) -> talk1.overlappingMutuallyExclusiveTalksTagCount((Talk)talk2) * talk1.overlappingDurationInMinutes((Talk)talk2));
    }

    protected Constraint consecutiveTalksPause(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.filtering((talk1, talk2) -> talk2.hasMutualSpeaker((Talk)talk1))).ifExists(ConferenceConstraintConfiguration.class, Joiners.filtering((talk1, talk2, config) -> !talk1.getTimeslot().pauseExists(talk2.getTimeslot(), config.getMinimumConsecutiveTalksPauseInMinutes()))).penalizeConfigurable("Consecutive talks pause", Talk::combinedDurationInMinutes);
    }

    protected Constraint crowdControl(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.getCrowdControlRisk() > 0).join(Talk.class, Joiners.equal(Talk::getTimeslot)).filter((talk1, talk2) -> !Objects.equals(talk1, talk2) && talk2.getCrowdControlRisk() > 0).groupBy((talk1, talk2) -> talk1, ConstraintCollectors.countBi()).filter((talk, count) -> count != 1).penalizeConfigurable("Crowd control", (talk, count) -> talk.getDurationInMinutes());
    }

    protected Constraint speakerRequiredTimeslotTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.missingSpeakerRequiredTimeslotTagCount() > 0).penalizeConfigurable("Speaker required timeslot tags", talk -> talk.missingSpeakerRequiredTimeslotTagCount() * talk.getDurationInMinutes());
    }

    protected Constraint speakerProhibitedTimeslotTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.prevailingSpeakerProhibitedTimeslotTagCount() > 0).penalizeConfigurable("Speaker prohibited timeslot tags", talk -> talk.prevailingSpeakerProhibitedTimeslotTagCount() * talk.getDurationInMinutes());
    }

    protected Constraint talkRequiredTimeslotTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.missingRequiredTimeslotTagCount() > 0).penalizeConfigurable("Talk required timeslot tags", talk -> talk.missingRequiredTimeslotTagCount() * talk.getDurationInMinutes());
    }

    protected Constraint talkProhibitedTimeslotTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.prevailingProhibitedTimeslotTagCount() > 0).penalizeConfigurable("Talk prohibited timeslot tags", talk -> talk.prevailingProhibitedTimeslotTagCount() * talk.getDurationInMinutes());
    }

    protected Constraint speakerRequiredRoomTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.missingSpeakerRequiredRoomTagCount() > 0).penalizeConfigurable("Speaker required room tags", talk -> talk.missingSpeakerRequiredRoomTagCount() * talk.getDurationInMinutes());
    }

    protected Constraint speakerProhibitedRoomTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.prevailingSpeakerProhibitedRoomTagCount() > 0).penalizeConfigurable("Speaker prohibited room tags", talk -> talk.prevailingSpeakerProhibitedRoomTagCount() * talk.getDurationInMinutes());
    }

    protected Constraint talkRequiredRoomTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.missingRequiredRoomTagCount() > 0).penalizeConfigurable("Talk required room tags", talk -> talk.missingRequiredRoomTagCount() * talk.getDurationInMinutes());
    }

    protected Constraint talkProhibitedRoomTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.prevailingProhibitedRoomTagCount() > 0).penalizeConfigurable("Talk prohibited room tags", talk -> talk.prevailingProhibitedRoomTagCount() * talk.getDurationInMinutes());
    }

    protected Constraint publishedTimeslot(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.getPublishedTimeslot() != null && talk.getTimeslot() != talk.getPublishedTimeslot()).penalizeConfigurable("Published timeslot");
    }

    protected Constraint publishedRoom(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.getPublishedRoom() != null && talk.getRoom() != talk.getPublishedRoom()).penalizeConfigurable("Published room");
    }

    protected Constraint themeTrackConflict(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.overlapping(t -> t.getTimeslot().getStartDateTime(), t -> t.getTimeslot().getEndDateTime()), Joiners.filtering((talk1, talk2) -> talk2.overlappingThemeTrackCount((Talk)talk1) > 0)).penalizeConfigurable("Theme track conflict", (talk1, talk2) -> talk1.overlappingThemeTrackCount((Talk)talk2) * talk1.overlappingDurationInMinutes((Talk)talk2));
    }

    protected Constraint themeTrackRoomStability(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.equal(talk -> talk.getTimeslot().getStartDateTime().toLocalDate()), Joiners.filtering((talk1, talk2) -> talk2.overlappingThemeTrackCount((Talk)talk1) > 0)).filter((talk1, talk2) -> talk1.getRoom() != talk2.getRoom()).penalizeConfigurable("Theme track room stability", (talk1, talk2) -> talk1.overlappingThemeTrackCount((Talk)talk2) * talk1.combinedDurationInMinutes((Talk)talk2));
    }

    protected Constraint sectorConflict(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.overlapping(t -> t.getTimeslot().getStartDateTime(), t -> t.getTimeslot().getEndDateTime()), Joiners.filtering((talk1, talk2) -> talk2.overlappingSectorCount((Talk)talk1) > 0)).penalizeConfigurable("Sector conflict", (talk1, talk2) -> talk1.overlappingSectorCount((Talk)talk2) * talk1.overlappingDurationInMinutes((Talk)talk2));
    }

    protected Constraint audienceTypeDiversity(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.equal(Talk::getTimeslot), Joiners.filtering((talk1, talk2) -> talk2.overlappingAudienceTypeCount((Talk)talk1) > 0)).rewardConfigurable("Audience type diversity", (talk1, talk2) -> talk1.overlappingAudienceTypeCount((Talk)talk2) * talk1.getTimeslot().getDurationInMinutes());
    }

    protected Constraint audienceTypeThemeTrackConflict(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.overlapping(t -> t.getTimeslot().getStartDateTime(), t -> t.getTimeslot().getEndDateTime()), Joiners.filtering((talk1, talk2) -> talk2.overlappingThemeTrackCount((Talk)talk1) > 0), Joiners.filtering((talk1, talk2) -> talk2.overlappingAudienceTypeCount((Talk)talk1) > 0)).penalizeConfigurable("Audience type theme track conflict", (talk1, talk2) -> talk1.overlappingThemeTrackCount((Talk)talk2) * talk1.overlappingAudienceTypeCount((Talk)talk2) * talk1.overlappingDurationInMinutes((Talk)talk2));
    }

    protected Constraint audienceLevelDiversity(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.equal(Talk::getTimeslot)).filter((talk1, talk2) -> talk1.getAudienceLevel() != talk2.getAudienceLevel()).rewardConfigurable("Audience level diversity", (talk1, talk2) -> talk1.getTimeslot().getDurationInMinutes());
    }

    protected Constraint contentAudienceLevelFlowViolation(ConstraintFactory factory) {
        return factory.forEach(Talk.class).join(Talk.class, Joiners.lessThan(Talk::getAudienceLevel), Joiners.greaterThan(talk1 -> talk1.getTimeslot().getEndDateTime(), talk2 -> talk2.getTimeslot().getStartDateTime()), Joiners.filtering((talk1, talk2) -> talk2.overlappingContentCount((Talk)talk1) > 0)).penalizeConfigurable("Content audience level flow violation", (talk1, talk2) -> talk1.overlappingContentCount((Talk)talk2) * talk1.combinedDurationInMinutes((Talk)talk2));
    }

    protected Constraint contentConflict(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.overlapping(t -> t.getTimeslot().getStartDateTime(), t -> t.getTimeslot().getEndDateTime()), Joiners.filtering((talk1, talk2) -> talk2.overlappingContentCount((Talk)talk1) > 0)).penalizeConfigurable("Content conflict", (talk1, talk2) -> talk1.overlappingContentCount((Talk)talk2) * talk1.overlappingDurationInMinutes((Talk)talk2));
    }

    protected Constraint languageDiversity(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.equal(Talk::getTimeslot)).filter((talk1, talk2) -> !talk1.getLanguage().equals(talk2.getLanguage())).rewardConfigurable("Language diversity", (talk1, talk2) -> talk1.getTimeslot().getDurationInMinutes());
    }

    protected Constraint sameDayTalks(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class).filter((talk1, talk2) -> !talk1.getTimeslot().isOnSameDayAs(talk2.getTimeslot()) && (talk1.overlappingContentCount((Talk)talk2) > 0 || talk1.overlappingThemeTrackCount((Talk)talk2) > 0)).penalizeConfigurable("Same day talks", (talk1, talk2) -> (talk2.overlappingThemeTrackCount((Talk)talk1) + talk2.overlappingContentCount((Talk)talk1)) * talk1.combinedDurationInMinutes((Talk)talk2));
    }

    protected Constraint popularTalks(ConstraintFactory factory) {
        return factory.forEach(Talk.class).join(Talk.class, Joiners.lessThan(Talk::getFavoriteCount), Joiners.greaterThan(talk -> talk.getRoom().getCapacity())).penalizeConfigurable("Popular talks", Talk::combinedDurationInMinutes);
    }

    protected Constraint speakerPreferredTimeslotTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.missingSpeakerPreferredTimeslotTagCount() > 0).penalizeConfigurable("Speaker preferred timeslot tags", talk -> talk.missingSpeakerPreferredTimeslotTagCount() * talk.getDurationInMinutes());
    }

    protected Constraint speakerUndesiredTimeslotTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.prevailingSpeakerUndesiredTimeslotTagCount() > 0).penalizeConfigurable("Speaker undesired timeslot tags", talk -> talk.prevailingSpeakerUndesiredTimeslotTagCount() * talk.getDurationInMinutes());
    }

    protected Constraint talkPreferredTimeslotTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.missingPreferredTimeslotTagCount() > 0).penalizeConfigurable("Talk preferred timeslot tags", talk -> talk.missingPreferredTimeslotTagCount() * talk.getDurationInMinutes());
    }

    protected Constraint talkUndesiredTimeslotTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.prevailingUndesiredTimeslotTagCount() > 0).penalizeConfigurable("Talk undesired timeslot tags", talk -> talk.prevailingUndesiredTimeslotTagCount() * talk.getDurationInMinutes());
    }

    protected Constraint speakerPreferredRoomTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.missingSpeakerPreferredRoomTagCount() > 0).penalizeConfigurable("Speaker preferred room tags", talk -> talk.missingSpeakerPreferredRoomTagCount() * talk.getDurationInMinutes());
    }

    protected Constraint speakerUndesiredRoomTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.prevailingSpeakerUndesiredRoomTagCount() > 0).penalizeConfigurable("Speaker undesired room tags", talk -> talk.prevailingSpeakerUndesiredRoomTagCount() * talk.getDurationInMinutes());
    }

    protected Constraint talkPreferredRoomTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.missingPreferredRoomTagCount() > 0).penalizeConfigurable("Talk preferred room tags", talk -> talk.missingPreferredRoomTagCount() * talk.getDurationInMinutes());
    }

    protected Constraint talkUndesiredRoomTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.prevailingUndesiredRoomTagCount() > 0).penalizeConfigurable("Talk undesired room tags", talk -> talk.prevailingUndesiredRoomTagCount() * talk.getDurationInMinutes());
    }
}

