/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.optional.score;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.calculator.EasyScoreCalculator;
import org.optaplanner.examples.cheaptime.domain.CheapTimeSolution;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.cheaptime.domain.Period;
import org.optaplanner.examples.cheaptime.domain.TaskAssignment;
import org.optaplanner.examples.cheaptime.optional.score.MachinePeriodPart;
import org.optaplanner.examples.cheaptime.score.CheapTimeCostCalculator;

public class CheapTimeEasyScoreCalculator
implements EasyScoreCalculator<CheapTimeSolution, HardMediumSoftLongScore> {
    public HardMediumSoftLongScore calculateScore(CheapTimeSolution solution) {
        if (solution.getGlobalPeriodRangeFrom() != 0) {
            throw new IllegalStateException("The globalPeriodRangeFrom (" + solution.getGlobalPeriodRangeFrom() + ") should be 0.");
        }
        int globalPeriodRangeTo = solution.getGlobalPeriodRangeTo();
        List<Machine> machineList = solution.getMachineList();
        LinkedHashMap machinePeriodListMap = new LinkedHashMap(machineList.size());
        for (Machine machine : machineList) {
            ArrayList<MachinePeriodPart> machinePeriodList = new ArrayList<MachinePeriodPart>(globalPeriodRangeTo);
            for (int period = 0; period < globalPeriodRangeTo; ++period) {
                machinePeriodList.add(new MachinePeriodPart(machine, period, Collections.emptyList()));
            }
            machinePeriodListMap.put(machine, machinePeriodList);
        }
        long mediumScore = 0L;
        long softScore = 0L;
        List<Period> periodList = solution.getPeriodList();
        for (TaskAssignment taskAssignment : solution.getTaskAssignmentList()) {
            Machine machine = taskAssignment.getMachine();
            Integer startPeriod = taskAssignment.getStartPeriod();
            if (machine == null || startPeriod == null) continue;
            List machinePeriodList = (List)machinePeriodListMap.get(machine);
            int endPeriod = taskAssignment.getEndPeriod();
            for (int period = startPeriod.intValue(); period < endPeriod; ++period) {
                MachinePeriodPart machinePeriodPart = (MachinePeriodPart)machinePeriodList.get(period);
                machinePeriodPart.addTaskAssignment(taskAssignment);
                Period powerPrice = periodList.get(period);
                mediumScore -= CheapTimeCostCalculator.multiplyTwoMicros(taskAssignment.getTask().getPowerConsumptionMicros(), powerPrice.getPowerPriceMicros());
            }
            softScore -= (long)startPeriod.intValue();
        }
        long hardScore = 0L;
        for (Map.Entry entry : machinePeriodListMap.entrySet()) {
            Machine machine = (Machine)entry.getKey();
            List machinePeriodList = (List)entry.getValue();
            MachinePeriodStatus previousStatus = MachinePeriodStatus.OFF;
            long idleCostMicros = 0L;
            for (Period period : solution.getPeriodList()) {
                MachinePeriodPart machinePeriodPart = (MachinePeriodPart)machinePeriodList.get(period.getIndex());
                boolean active = machinePeriodPart.isActive();
                if (active) {
                    if (previousStatus == MachinePeriodStatus.OFF) {
                        mediumScore -= machine.getSpinUpDownCostMicros();
                    } else if (previousStatus == MachinePeriodStatus.IDLE) {
                        mediumScore -= idleCostMicros;
                        idleCostMicros = 0L;
                    }
                    hardScore += (long)machinePeriodPart.getResourceInShortTotal();
                    mediumScore -= CheapTimeCostCalculator.multiplyTwoMicros(machine.getPowerConsumptionMicros(), period.getPowerPriceMicros());
                    previousStatus = MachinePeriodStatus.ACTIVE;
                    continue;
                }
                if (previousStatus == MachinePeriodStatus.OFF) continue;
                if ((idleCostMicros += CheapTimeCostCalculator.multiplyTwoMicros(machine.getPowerConsumptionMicros(), period.getPowerPriceMicros())) > machine.getSpinUpDownCostMicros()) {
                    idleCostMicros = 0L;
                    previousStatus = MachinePeriodStatus.OFF;
                    continue;
                }
                previousStatus = MachinePeriodStatus.IDLE;
            }
        }
        return HardMediumSoftLongScore.of((long)hardScore, (long)mediumScore, (long)softScore);
    }

    private static enum MachinePeriodStatus {
        OFF,
        IDLE,
        ACTIVE;

    }
}

