/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.coachshuttlegathering.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.ShadowVariable;
import org.optaplanner.examples.coachshuttlegathering.domain.Bus;
import org.optaplanner.examples.coachshuttlegathering.domain.BusStop;
import org.optaplanner.examples.coachshuttlegathering.domain.StopOrHub;
import org.optaplanner.examples.coachshuttlegathering.domain.location.RoadLocation;
import org.optaplanner.examples.coachshuttlegathering.domain.solver.DepotAngleBusStopDifficultyWeightFactory;
import org.optaplanner.examples.coachshuttlegathering.domain.solver.ShuttlePassengerCountTotalUpdatingVariableListener;

@PlanningEntity(difficultyWeightFactoryClass=DepotAngleBusStopDifficultyWeightFactory.class)
@XStreamAlias(value="CsgShuttle")
public class Shuttle
extends Bus {
    protected int setupCost;
    protected StopOrHub destination;

    @Override
    public int getSetupCost() {
        return this.setupCost;
    }

    public void setSetupCost(int setupCost) {
        this.setupCost = setupCost;
    }

    @Override
    @PlanningVariable(valueRangeProviderRefs={"stopRange", "hubRange"})
    public StopOrHub getDestination() {
        return this.destination;
    }

    public void setDestination(StopOrHub destination) {
        this.destination = destination;
    }

    @Override
    @ShadowVariable.List(value={@ShadowVariable(variableListenerClass=ShuttlePassengerCountTotalUpdatingVariableListener.class, sourceEntityClass=BusStop.class, sourceVariableName="bus"), @ShadowVariable(variableListenerClass=ShuttlePassengerCountTotalUpdatingVariableListener.class, sourceEntityClass=Shuttle.class, sourceVariableName="destination")})
    public Integer getPassengerQuantityTotal() {
        return super.getPassengerQuantityTotal();
    }

    @Override
    public int getDistanceFromTo(RoadLocation sourceLocation, RoadLocation targetLocation) {
        return sourceLocation.getShuttleDistanceTo(targetLocation);
    }

    @Override
    public int getDurationFromTo(RoadLocation sourceLocation, RoadLocation targetLocation) {
        return sourceLocation.getShuttleDurationTo(targetLocation);
    }

    public Bus getDestinationBus() {
        if (this.destination == null) {
            return null;
        }
        if (!(this.destination instanceof BusStop)) {
            return null;
        }
        return ((BusStop)this.destination).getBus();
    }
}

