/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.meetingscheduling.domain;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Comparator;
import java.util.Objects;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.swingui.components.Labeled;
import org.optaplanner.examples.meetingscheduling.domain.Day;

public class TimeGrain
extends AbstractPersistable
implements Comparable<TimeGrain>,
Labeled {
    private static final Comparator<TimeGrain> COMPARATOR = Comparator.comparing(TimeGrain::getDay).thenComparingInt(TimeGrain::getStartingMinuteOfDay);
    public static final int GRAIN_LENGTH_IN_MINUTES = 15;
    private int grainIndex;
    private Day day;
    private int startingMinuteOfDay;

    public int getGrainIndex() {
        return this.grainIndex;
    }

    public void setGrainIndex(int grainIndex) {
        this.grainIndex = grainIndex;
    }

    public Day getDay() {
        return this.day;
    }

    public void setDay(Day day) {
        this.day = day;
    }

    public int getStartingMinuteOfDay() {
        return this.startingMinuteOfDay;
    }

    public void setStartingMinuteOfDay(int startingMinuteOfDay) {
        this.startingMinuteOfDay = startingMinuteOfDay;
    }

    public LocalDate getDate() {
        return this.day.toDate();
    }

    public LocalTime getTime() {
        return LocalTime.of(this.startingMinuteOfDay / 60, this.startingMinuteOfDay % 60);
    }

    public LocalDateTime getDateTime() {
        return LocalDateTime.of(this.getDate(), this.getTime());
    }

    public String getTimeString() {
        int hourOfDay = this.startingMinuteOfDay / 60;
        int minuteOfHour = this.startingMinuteOfDay % 60;
        return (hourOfDay < 10 ? "0" : "") + hourOfDay + ":" + (minuteOfHour < 10 ? "0" : "") + minuteOfHour;
    }

    public String getDateTimeString() {
        return this.day.getDateString() + " " + this.getTimeString();
    }

    @Override
    public String getLabel() {
        return this.getTimeString();
    }

    @Override
    public String toString() {
        return this.grainIndex + "(" + this.getDateTimeString() + ")";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TimeGrain timeGrain = (TimeGrain)other;
        if (this.startingMinuteOfDay != timeGrain.startingMinuteOfDay) {
            return false;
        }
        return Objects.equals(this.day, timeGrain.day);
    }

    public int hashCode() {
        int result = this.day != null ? this.day.hashCode() : 0;
        result = 31 * result + this.startingMinuteOfDay;
        return result;
    }

    @Override
    public int compareTo(TimeGrain other) {
        return COMPARATOR.compare(this, other);
    }
}

