/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.rocktour.domain;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.NavigableSet;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.AnchorShadowVariable;
import org.optaplanner.core.api.domain.variable.PiggybackShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableGraphType;
import org.optaplanner.core.api.domain.variable.ShadowVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.rocktour.domain.RockBus;
import org.optaplanner.examples.rocktour.domain.RockLocation;
import org.optaplanner.examples.rocktour.domain.RockStandstill;
import org.optaplanner.examples.rocktour.domain.RockTimeOfDay;
import org.optaplanner.examples.rocktour.domain.solver.RockShowVariableListener;

@PlanningEntity
public class RockShow
extends AbstractPersistable
implements RockStandstill {
    private String venueName;
    private RockLocation location;
    private int durationInHalfDay;
    private int revenueOpportunity;
    private boolean required;
    private NavigableSet<LocalDate> availableDateSet;
    @PlanningVariable(valueRangeProviderRefs={"busRange", "showRange"}, graphType=PlanningVariableGraphType.CHAINED)
    private RockStandstill previousStandstill;
    private RockShow nextShow;
    @AnchorShadowVariable(sourceVariableName="previousStandstill")
    private RockBus bus;
    @ShadowVariable.List(value={@ShadowVariable(variableListenerClass=RockShowVariableListener.class, sourceVariableName="previousStandstill"), @ShadowVariable(variableListenerClass=RockShowVariableListener.class, sourceVariableName="bus")})
    private LocalDate date;
    @PiggybackShadowVariable(shadowVariableName="date")
    private RockTimeOfDay timeOfDay;
    @PiggybackShadowVariable(shadowVariableName="date")
    private RockStandstill hosWeekStart;
    @PiggybackShadowVariable(shadowVariableName="date")
    private Long hosWeekDrivingSecondsTotal;

    @Override
    public RockLocation getDepartureLocation() {
        return this.location;
    }

    @Override
    public LocalDate getDepartureDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.plusDays((this.durationInHalfDay - 1) / 2);
    }

    @Override
    public RockTimeOfDay getDepartureTimeOfDay() {
        return this.durationInHalfDay % 2 == 0 ? RockTimeOfDay.LATE : this.timeOfDay;
    }

    @Override
    public RockLocation getArrivalLocation() {
        return this.location;
    }

    public long getDrivingTimeFromPreviousStandstill() {
        return this.previousStandstill.getDepartureLocation().getDrivingTimeTo(this.location);
    }

    public long getDrivingTimeToBusArrivalLocation() {
        return this.location.getDrivingTimeTo(this.bus.getArrivalLocation());
    }

    public long getDaysAfterBusDeparture() {
        return ChronoUnit.DAYS.between(this.bus.getDepartureDate(), this.date);
    }

    @Override
    public String toString() {
        return this.venueName;
    }

    public String getVenueName() {
        return this.venueName;
    }

    public void setVenueName(String venueName) {
        this.venueName = venueName;
    }

    public RockLocation getLocation() {
        return this.location;
    }

    public void setLocation(RockLocation location) {
        this.location = location;
    }

    public int getDurationInHalfDay() {
        return this.durationInHalfDay;
    }

    public void setDurationInHalfDay(int durationInHalfDay) {
        this.durationInHalfDay = durationInHalfDay;
    }

    public int getRevenueOpportunity() {
        return this.revenueOpportunity;
    }

    public void setRevenueOpportunity(int revenueOpportunity) {
        this.revenueOpportunity = revenueOpportunity;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public NavigableSet<LocalDate> getAvailableDateSet() {
        return this.availableDateSet;
    }

    public void setAvailableDateSet(NavigableSet<LocalDate> availableDateSet) {
        this.availableDateSet = availableDateSet;
    }

    public RockStandstill getPreviousStandstill() {
        return this.previousStandstill;
    }

    public void setPreviousStandstill(RockStandstill previousStandstill) {
        this.previousStandstill = previousStandstill;
    }

    @Override
    public RockShow getNextShow() {
        return this.nextShow;
    }

    @Override
    public void setNextShow(RockShow nextShow) {
        this.nextShow = nextShow;
    }

    public RockBus getBus() {
        return this.bus;
    }

    public void setBus(RockBus bus) {
        this.bus = bus;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public RockTimeOfDay getTimeOfDay() {
        return this.timeOfDay;
    }

    public void setTimeOfDay(RockTimeOfDay timeOfDay) {
        this.timeOfDay = timeOfDay;
    }

    @Override
    public RockStandstill getHosWeekStart() {
        return this.hosWeekStart;
    }

    public void setHosWeekStart(RockStandstill hosWeekStart) {
        this.hosWeekStart = hosWeekStart;
    }

    @Override
    public Long getHosWeekDrivingSecondsTotal() {
        return this.hosWeekDrivingSecondsTotal;
    }

    public void setHosWeekDrivingSecondsTotal(Long hosWeekDrivingSecondsTotal) {
        this.hosWeekDrivingSecondsTotal = hosWeekDrivingSecondsTotal;
    }
}

