/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.rocktour.domain;

import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.examples.common.domain.AbstractPersistable;

@ConstraintConfiguration(constraintPackage="org.optaplanner.examples.rocktour.score")
public class RockTourConstraintConfiguration
extends AbstractPersistable {
    public static final String EARLY_LATE_BREAK_DRIVING_SECONDS = "Early late break driving seconds budget";
    public static final String NIGHT_DRIVING_SECONDS = "Night driving seconds budget";
    public static final String HOS_WEEK_DRIVING_SECONDS_BUDGET = "HOS week driving seconds budget";
    public static final String HOS_WEEK_CONSECUTIVE_DRIVING_DAYS_BUDGET = "HOS week consecutive driving days budget";
    public static final String HOS_WEEK_REST_DAYS = "HOS week rest days";
    public static final String REQUIRED_SHOW = "Required show";
    public static final String UNASSIGNED_SHOW = "Unassigned show";
    public static final String REVENUE_OPPORTUNITY = "Revenue opportunity";
    public static final String DRIVING_TIME_TO_SHOW_PER_SECOND = "Driving time to show per second";
    public static final String DRIVING_TIME_TO_BUS_ARRIVAL_PER_SECOND = "Driving time to bus arrival per second";
    public static final String DELAY_SHOW_COST_PER_DAY = "Delay show cost per day";
    public static final String SHORTEN_DRIVING_TIME_PER_MILLISECOND_SQUARED = "Shorten driving time per millisecond squared";
    private long earlyLateBreakDrivingSecondsBudget = 3600L;
    private long nightDrivingSecondsBudget = 25200L;
    private long hosWeekDrivingSecondsBudget = 180000L;
    private int hosWeekConsecutiveDrivingDaysBudget = 7;
    private int hosWeekRestDays = 2;
    @ConstraintWeight(value="Required show")
    private HardMediumSoftLongScore requiredShow = HardMediumSoftLongScore.ofHard((long)1000L);
    @ConstraintWeight(value="Unassigned show")
    private HardMediumSoftLongScore unassignedShow = HardMediumSoftLongScore.ofHard((long)1L);
    @ConstraintWeight(value="Revenue opportunity")
    private HardMediumSoftLongScore revenueOpportunity = HardMediumSoftLongScore.ofMedium((long)1L);
    @ConstraintWeight(value="Driving time to show per second")
    private HardMediumSoftLongScore drivingTimeToShowPerSecond = HardMediumSoftLongScore.ofMedium((long)1L);
    @ConstraintWeight(value="Driving time to bus arrival per second")
    private HardMediumSoftLongScore drivingTimeToBusArrivalPerSecond = HardMediumSoftLongScore.ZERO;
    @ConstraintWeight(value="Delay show cost per day")
    private HardMediumSoftLongScore delayShowCostPerDay = HardMediumSoftLongScore.ofMedium((long)30L);
    @ConstraintWeight(value="Shorten driving time per millisecond squared")
    private HardMediumSoftLongScore shortenDrivingTimePerMillisecondSquared = HardMediumSoftLongScore.ofSoft((long)1L);

    public RockTourConstraintConfiguration() {
    }

    public RockTourConstraintConfiguration(long id) {
        super(id);
    }

    public long getEarlyLateBreakDrivingSecondsBudget() {
        return this.earlyLateBreakDrivingSecondsBudget;
    }

    public void setEarlyLateBreakDrivingSecondsBudget(long earlyLateBreakDrivingSecondsBudget) {
        this.earlyLateBreakDrivingSecondsBudget = earlyLateBreakDrivingSecondsBudget;
    }

    public long getNightDrivingSecondsBudget() {
        return this.nightDrivingSecondsBudget;
    }

    public void setNightDrivingSecondsBudget(long nightDrivingSecondsBudget) {
        this.nightDrivingSecondsBudget = nightDrivingSecondsBudget;
    }

    public long getHosWeekDrivingSecondsBudget() {
        return this.hosWeekDrivingSecondsBudget;
    }

    public void setHosWeekDrivingSecondsBudget(long hosWeekDrivingSecondsBudget) {
        this.hosWeekDrivingSecondsBudget = hosWeekDrivingSecondsBudget;
    }

    public int getHosWeekConsecutiveDrivingDaysBudget() {
        return this.hosWeekConsecutiveDrivingDaysBudget;
    }

    public void setHosWeekConsecutiveDrivingDaysBudget(int hosWeekConsecutiveDrivingDaysBudget) {
        this.hosWeekConsecutiveDrivingDaysBudget = hosWeekConsecutiveDrivingDaysBudget;
    }

    public int getHosWeekRestDays() {
        return this.hosWeekRestDays;
    }

    public void setHosWeekRestDays(int hosWeekRestDays) {
        this.hosWeekRestDays = hosWeekRestDays;
    }

    public HardMediumSoftLongScore getRequiredShow() {
        return this.requiredShow;
    }

    public void setRequiredShow(HardMediumSoftLongScore requiredShow) {
        this.requiredShow = requiredShow;
    }

    public HardMediumSoftLongScore getUnassignedShow() {
        return this.unassignedShow;
    }

    public void setUnassignedShow(HardMediumSoftLongScore unassignedShow) {
        this.unassignedShow = unassignedShow;
    }

    public HardMediumSoftLongScore getRevenueOpportunity() {
        return this.revenueOpportunity;
    }

    public void setRevenueOpportunity(HardMediumSoftLongScore revenueOpportunity) {
        this.revenueOpportunity = revenueOpportunity;
    }

    public HardMediumSoftLongScore getDrivingTimeToShowPerSecond() {
        return this.drivingTimeToShowPerSecond;
    }

    public void setDrivingTimeToShowPerSecond(HardMediumSoftLongScore drivingTimeToShowPerSecond) {
        this.drivingTimeToShowPerSecond = drivingTimeToShowPerSecond;
    }

    public HardMediumSoftLongScore getDrivingTimeToBusArrivalPerSecond() {
        return this.drivingTimeToBusArrivalPerSecond;
    }

    public void setDrivingTimeToBusArrivalPerSecond(HardMediumSoftLongScore drivingTimeToBusArrivalPerSecond) {
        this.drivingTimeToBusArrivalPerSecond = drivingTimeToBusArrivalPerSecond;
    }

    public HardMediumSoftLongScore getDelayShowCostPerDay() {
        return this.delayShowCostPerDay;
    }

    public void setDelayShowCostPerDay(HardMediumSoftLongScore delayShowCostPerDay) {
        this.delayShowCostPerDay = delayShowCostPerDay;
    }

    public HardMediumSoftLongScore getShortenDrivingTimePerMillisecondSquared() {
        return this.shortenDrivingTimePerMillisecondSquared;
    }

    public void setShortenDrivingTimePerMillisecondSquared(HardMediumSoftLongScore shortenDrivingTimePerMillisecondSquared) {
        this.shortenDrivingTimePerMillisecondSquared = shortenDrivingTimePerMillisecondSquared;
    }
}

