/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.timewindowed.solver;

import java.util.Objects;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedDepot;

public class ArrivalTimeUpdatingVariableListener
implements VariableListener<VehicleRoutingSolution, Customer> {
    public void beforeEntityAdded(ScoreDirector<VehicleRoutingSolution> scoreDirector, Customer customer) {
    }

    public void afterEntityAdded(ScoreDirector<VehicleRoutingSolution> scoreDirector, Customer customer) {
        if (customer instanceof TimeWindowedCustomer) {
            this.updateArrivalTime(scoreDirector, (TimeWindowedCustomer)customer);
        }
    }

    public void beforeVariableChanged(ScoreDirector<VehicleRoutingSolution> scoreDirector, Customer customer) {
    }

    public void afterVariableChanged(ScoreDirector<VehicleRoutingSolution> scoreDirector, Customer customer) {
        if (customer instanceof TimeWindowedCustomer) {
            this.updateArrivalTime(scoreDirector, (TimeWindowedCustomer)customer);
        }
    }

    public void beforeEntityRemoved(ScoreDirector<VehicleRoutingSolution> scoreDirector, Customer customer) {
    }

    public void afterEntityRemoved(ScoreDirector<VehicleRoutingSolution> scoreDirector, Customer customer) {
    }

    protected void updateArrivalTime(ScoreDirector<VehicleRoutingSolution> scoreDirector, TimeWindowedCustomer sourceCustomer) {
        TimeWindowedCustomer shadowCustomer;
        if (sourceCustomer.getVehicle() == null) {
            if (sourceCustomer.getArrivalTime() != null) {
                scoreDirector.beforeVariableChanged((Object)sourceCustomer, "arrivalTime");
                sourceCustomer.setArrivalTime(null);
                scoreDirector.afterVariableChanged((Object)sourceCustomer, "arrivalTime");
            }
            return;
        }
        Customer previousCustomer = sourceCustomer.getPreviousCustomer();
        Long departureTime = previousCustomer == null ? Long.valueOf(((TimeWindowedDepot)sourceCustomer.getVehicle().getDepot()).getReadyTime()) : ((TimeWindowedCustomer)previousCustomer).getDepartureTime();
        Long arrivalTime = this.calculateArrivalTime(shadowCustomer, departureTime);
        for (shadowCustomer = sourceCustomer; shadowCustomer != null && !Objects.equals(shadowCustomer.getArrivalTime(), arrivalTime); shadowCustomer = (TimeWindowedCustomer)shadowCustomer.getNextCustomer()) {
            scoreDirector.beforeVariableChanged((Object)shadowCustomer, "arrivalTime");
            shadowCustomer.setArrivalTime(arrivalTime);
            scoreDirector.afterVariableChanged((Object)shadowCustomer, "arrivalTime");
            departureTime = shadowCustomer.getDepartureTime();
            arrivalTime = this.calculateArrivalTime(shadowCustomer, departureTime);
        }
    }

    private Long calculateArrivalTime(TimeWindowedCustomer customer, Long previousDepartureTime) {
        if (customer == null || previousDepartureTime == null) {
            return null;
        }
        return previousDepartureTime + customer.getDistanceFromPreviousStandstill();
    }
}

