/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JTabbedPane;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.AirLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedDepot;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedVehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.swingui.VehicleRoutingWorldPanel;

public class VehicleRoutingPanel
extends SolutionPanel<VehicleRoutingSolution> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/vehiclerouting/swingui/vehicleRoutingLogo.png";
    private final VehicleRoutingWorldPanel vehicleRoutingWorldPanel;
    private final Random demandRandom = new Random(37L);
    private Long nextLocationId = null;

    public VehicleRoutingPanel() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        this.vehicleRoutingWorldPanel = new VehicleRoutingWorldPanel(this);
        this.vehicleRoutingWorldPanel.setPreferredSize(PREFERRED_SCROLLABLE_VIEWPORT_SIZE);
        tabbedPane.add("World", this.vehicleRoutingWorldPanel);
        this.add((Component)tabbedPane, "Center");
    }

    @Override
    public boolean isWrapInScrollPane() {
        return false;
    }

    @Override
    public void resetPanel(VehicleRoutingSolution solution) {
        this.vehicleRoutingWorldPanel.resetPanel(solution);
        this.resetNextLocationId();
    }

    private void resetNextLocationId() {
        long highestLocationId = 0L;
        for (Location location : ((VehicleRoutingSolution)this.getSolution()).getLocationList()) {
            if (highestLocationId >= location.getId()) continue;
            highestLocationId = location.getId();
        }
        this.nextLocationId = highestLocationId + 1L;
    }

    @Override
    public void updatePanel(VehicleRoutingSolution solution) {
        this.vehicleRoutingWorldPanel.updatePanel(solution);
    }

    public void insertLocationAndCustomer(double longitude, double latitude) {
        AirLocation newLocation;
        switch (((VehicleRoutingSolution)this.getSolution()).getDistanceType()) {
            case AIR_DISTANCE: {
                newLocation = new AirLocation();
                break;
            }
            case ROAD_DISTANCE: {
                this.logger.warn("Adding locations for a road distance dataset is not supported.");
                return;
            }
            case SEGMENTED_ROAD_DISTANCE: {
                this.logger.warn("Adding locations for a segmented road distance dataset is not supported.");
                return;
            }
            default: {
                throw new IllegalStateException("The distanceType (" + ((VehicleRoutingSolution)this.getSolution()).getDistanceType() + ") is not implemented.");
            }
        }
        newLocation.setId(this.nextLocationId);
        Long l = this.nextLocationId;
        Long l2 = this.nextLocationId = Long.valueOf(this.nextLocationId + 1L);
        newLocation.setLongitude(longitude);
        newLocation.setLatitude(latitude);
        this.logger.info("Scheduling insertion of newLocation ({}).", (Object)newLocation);
        this.doProblemChange((vehicleRoutingSolution, problemChangeDirector) -> {
            vehicleRoutingSolution.setLocationList(new ArrayList<Location>(vehicleRoutingSolution.getLocationList()));
            problemChangeDirector.addProblemFact((Object)newLocation, vehicleRoutingSolution.getLocationList()::add);
            Customer newCustomer = this.createCustomer((VehicleRoutingSolution)vehicleRoutingSolution, newLocation);
            problemChangeDirector.addProblemFact((Object)newCustomer, vehicleRoutingSolution.getCustomerList()::add);
        });
    }

    protected Customer createCustomer(VehicleRoutingSolution solution, Location newLocation) {
        Customer newCustomer;
        if (solution instanceof TimeWindowedVehicleRoutingSolution) {
            TimeWindowedCustomer newTimeWindowedCustomer = new TimeWindowedCustomer();
            TimeWindowedDepot timeWindowedDepot = (TimeWindowedDepot)solution.getDepotList().get(0);
            long windowTime = (timeWindowedDepot.getDueTime() - timeWindowedDepot.getReadyTime()) / 4L;
            long readyTime = this.demandRandom.longs(0L, windowTime * 3L).findAny().orElseThrow();
            newTimeWindowedCustomer.setReadyTime(readyTime);
            newTimeWindowedCustomer.setDueTime(readyTime + windowTime);
            newTimeWindowedCustomer.setServiceDuration(Math.min(10000L, windowTime / 2L));
            newCustomer = newTimeWindowedCustomer;
        } else {
            newCustomer = new Customer();
        }
        newCustomer.setId(newLocation.getId());
        newCustomer.setLocation(newLocation);
        newCustomer.setDemand(this.demandRandom.nextInt(10) + 1);
        return newCustomer;
    }
}

