/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.location.segmented;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.HubSegmentLocationKeyDeserializer;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.HubSegmentLocationKeySerializer;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.RoadSegmentLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.RoadSegmentLocationKeyDeserializer;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.RoadSegmentLocationKeySerializer;

public class HubSegmentLocation
extends Location {
    protected Map<RoadSegmentLocation, Double> nearbyTravelDistanceMap;
    protected Map<HubSegmentLocation, Double> hubTravelDistanceMap;

    public HubSegmentLocation() {
    }

    public HubSegmentLocation(long id) {
        super(id);
    }

    public HubSegmentLocation(long id, double latitude, double longitude) {
        super(id, latitude, longitude);
    }

    @JsonSerialize(keyUsing=RoadSegmentLocationKeySerializer.class)
    @JsonDeserialize(keyUsing=RoadSegmentLocationKeyDeserializer.class)
    public Map<RoadSegmentLocation, Double> getNearbyTravelDistanceMap() {
        return this.nearbyTravelDistanceMap;
    }

    public void setNearbyTravelDistanceMap(Map<RoadSegmentLocation, Double> nearbyTravelDistanceMap) {
        this.nearbyTravelDistanceMap = nearbyTravelDistanceMap;
    }

    @JsonSerialize(keyUsing=HubSegmentLocationKeySerializer.class)
    @JsonDeserialize(keyUsing=HubSegmentLocationKeyDeserializer.class)
    public Map<HubSegmentLocation, Double> getHubTravelDistanceMap() {
        return this.hubTravelDistanceMap;
    }

    public void setHubTravelDistanceMap(Map<HubSegmentLocation, Double> hubTravelDistanceMap) {
        this.hubTravelDistanceMap = hubTravelDistanceMap;
    }

    @Override
    public long getDistanceTo(Location location) {
        double distance = location instanceof RoadSegmentLocation ? this.getDistanceDouble((RoadSegmentLocation)location) : this.hubTravelDistanceMap.get((HubSegmentLocation)location).doubleValue();
        return (long)(distance * 1000.0 + 0.5);
    }

    public double getDistanceDouble(RoadSegmentLocation location) {
        Double distance = this.nearbyTravelDistanceMap.get(location);
        if (distance == null) {
            distance = this.getShortestDistanceDoubleThroughOtherHub(location);
        }
        return distance;
    }

    protected double getShortestDistanceDoubleThroughOtherHub(RoadSegmentLocation location) {
        double shortestDistance = Double.MAX_VALUE;
        for (Map.Entry<HubSegmentLocation, Double> otherHubEntry : this.hubTravelDistanceMap.entrySet()) {
            double distance;
            HubSegmentLocation otherHub = otherHubEntry.getKey();
            Double otherHubNearbyDistance = otherHub.nearbyTravelDistanceMap.get(location);
            if (otherHubNearbyDistance == null || !((distance = otherHubEntry.getValue() + otherHubNearbyDistance) < shortestDistance)) continue;
            shortestDistance = distance;
        }
        return shortestDistance;
    }
}

