/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.domain;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.jackson.JacksonUniqueIdGenerator;
import org.optaplanner.examples.common.swingui.components.Labeled;
import org.optaplanner.examples.examination.domain.FollowingExam;
import org.optaplanner.examples.examination.domain.LeadingExam;
import org.optaplanner.examples.examination.domain.Period;
import org.optaplanner.examples.examination.domain.Room;
import org.optaplanner.examples.examination.domain.Topic;
import org.optaplanner.examples.examination.domain.solver.ExamDifficultyWeightFactory;
import org.optaplanner.examples.examination.domain.solver.RoomStrengthWeightFactory;

@PlanningEntity(difficultyWeightFactoryClass=ExamDifficultyWeightFactory.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonSubTypes(value={@JsonSubTypes.Type(value=LeadingExam.class, name="leading"), @JsonSubTypes.Type(value=FollowingExam.class, name="following")})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonIdentityInfo(generator=JacksonUniqueIdGenerator.class)
public abstract class Exam
extends AbstractPersistable
implements Labeled {
    protected Topic topic;
    protected Room room;

    public Topic getTopic() {
        return this.topic;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }

    @PlanningVariable(valueRangeProviderRefs={"roomRange"}, strengthWeightFactoryClass=RoomStrengthWeightFactory.class)
    public Room getRoom() {
        return this.room;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    public abstract Period getPeriod();

    @JsonIgnore
    public int getTopicDuration() {
        return this.getTopic().getDuration();
    }

    @JsonIgnore
    public int getTopicStudentSize() {
        return this.getTopic().getStudentSize();
    }

    @JsonIgnore
    public int getDayIndex() {
        Period period = this.getPeriod();
        if (period == null) {
            return Integer.MIN_VALUE;
        }
        return period.getDayIndex();
    }

    @JsonIgnore
    public int getPeriodIndex() {
        Period period = this.getPeriod();
        if (period == null) {
            return Integer.MIN_VALUE;
        }
        return period.getPeriodIndex();
    }

    @JsonIgnore
    public int getPeriodDuration() {
        Period period = this.getPeriod();
        if (period == null) {
            return Integer.MIN_VALUE;
        }
        return period.getDuration();
    }

    @JsonIgnore
    public boolean isTopicFrontLoadLarge() {
        return this.topic.isFrontLoadLarge();
    }

    @JsonIgnore
    public boolean isPeriodFrontLoadLast() {
        Period period = this.getPeriod();
        if (period == null) {
            return false;
        }
        return period.isFrontLoadLast();
    }

    @Override
    public String getLabel() {
        return Long.toString(this.topic.getId());
    }

    @Override
    public String toString() {
        return this.topic.toString();
    }
}

