/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.text.WordUtils;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.examples.common.swingui.latitudelongitude.LatitudeLongitudeTranslator;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.TspSolution;
import org.optaplanner.examples.tsp.domain.Visit;
import org.optaplanner.examples.tsp.domain.location.AirLocation;
import org.optaplanner.examples.tsp.domain.location.DistanceType;
import org.optaplanner.examples.tsp.domain.location.Location;
import org.optaplanner.examples.tsp.swingui.TspPanel;
import org.optaplanner.swing.impl.TangoColorFactory;

public class TspWorldPanel
extends JPanel {
    private static final int TEXT_SIZE = 12;
    private static final int LOCATION_NAME_TEXT_SIZE = 8;
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("#,##0.00");
    private final TspPanel tspPanel;
    private BufferedImage canvas = null;
    private LatitudeLongitudeTranslator translator = null;
    private Standstill dragSourceStandstill = null;
    private Standstill dragTargetStandstill = null;
    private final ImageIcon europaBackground;

    public TspWorldPanel(TspPanel tspPanel) {
        this.tspPanel = tspPanel;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TspSolution tspSolution = (TspSolution)TspWorldPanel.this.tspPanel.getSolution();
                if (tspSolution != null) {
                    TspWorldPanel.this.resetPanel(tspSolution);
                }
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (TspWorldPanel.this.translator == null) {
                    return;
                }
                double longitude = TspWorldPanel.this.translator.translateXToLongitude(e.getX());
                double latitude = TspWorldPanel.this.translator.translateYToLatitude(e.getY());
                if (TspWorldPanel.isLeftClick(e)) {
                    TspWorldPanel.this.dragSourceStandstill = TspWorldPanel.this.tspPanel.findNearestStandstill(new AirLocation(-1L, latitude, longitude));
                    TspSolution tspSolution = (TspSolution)TspWorldPanel.this.tspPanel.getSolution();
                    TspWorldPanel.this.dragTargetStandstill = tspSolution.getDomicile();
                    TspWorldPanel.this.resetPanel(tspSolution);
                } else if (TspWorldPanel.isRightClick(e)) {
                    TspWorldPanel.this.tspPanel.insertLocationAndVisit(longitude, latitude);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TspWorldPanel.this.translator != null && TspWorldPanel.this.dragSourceStandstill != null) {
                    double longitude = TspWorldPanel.this.translator.translateXToLongitude(e.getX());
                    double latitude = TspWorldPanel.this.translator.translateYToLatitude(e.getY());
                    TspWorldPanel.this.dragTargetStandstill = TspWorldPanel.this.tspPanel.findNearestStandstill(new AirLocation(-1L, latitude, longitude));
                    TspSolution tspSolution = (TspSolution)TspWorldPanel.this.tspPanel.getSolution();
                    if (TspWorldPanel.this.dragSourceStandstill.getLocation().getId() == TspWorldPanel.this.dragTargetStandstill.getLocation().getId()) {
                        TspWorldPanel.this.dragTargetStandstill = tspSolution.getDomicile();
                    }
                    TspWorldPanel.this.resetPanel(tspSolution);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TspWorldPanel.this.translator == null || !TspWorldPanel.isLeftClick(e)) {
                    return;
                }
                double longitude = TspWorldPanel.this.translator.translateXToLongitude(e.getX());
                double latitude = TspWorldPanel.this.translator.translateYToLatitude(e.getY());
                TspWorldPanel.this.dragTargetStandstill = TspWorldPanel.this.tspPanel.findNearestStandstill(new AirLocation(-1L, latitude, longitude));
                TspSolution tspSolution = (TspSolution)TspWorldPanel.this.tspPanel.getSolution();
                if (TspWorldPanel.this.dragSourceStandstill.getLocation().getId() == TspWorldPanel.this.dragTargetStandstill.getLocation().getId()) {
                    TspWorldPanel.this.dragTargetStandstill = tspSolution.getDomicile();
                }
                Standstill sourceStandstill = TspWorldPanel.this.dragSourceStandstill;
                Standstill targetStandstill = TspWorldPanel.this.dragTargetStandstill;
                TspWorldPanel.this.dragSourceStandstill = null;
                TspWorldPanel.this.dragTargetStandstill = null;
                TspWorldPanel.this.tspPanel.connectStandstills(sourceStandstill, targetStandstill);
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.europaBackground = new ImageIcon(this.getClass().getResource("europaBackground.png"));
    }

    private static boolean isLeftClick(MouseEvent e) {
        return SwingUtilities.isLeftMouseButton(e) && !e.isControlDown();
    }

    private static boolean isRightClick(MouseEvent e) {
        return SwingUtilities.isRightMouseButton(e) || e.isControlDown();
    }

    public void resetPanel(TspSolution tspSolution) {
        this.translator = new LatitudeLongitudeTranslator();
        for (Location location : tspSolution.getLocationList()) {
            this.translator.addCoordinates(location.getLatitude(), location.getLongitude());
        }
        Dimension size = this.getSize();
        double width = size.getWidth();
        double height = size.getHeight();
        this.translator.prepareFor(width, height);
        Graphics2D g = this.createCanvas(width, height);
        if (tspSolution.getName().startsWith("europe")) {
            g.drawImage(this.europaBackground.getImage(), 0, 0, this.translator.getImageWidth(), this.translator.getImageHeight(), this);
        }
        g.setFont(g.getFont().deriveFont(8.0f));
        g.setColor(TangoColorFactory.PLUM_2);
        List<Visit> visitList = tspSolution.getVisitList();
        for (Visit visit : visitList) {
            Location location = visit.getLocation();
            int x = this.translator.translateLongitudeToX(location.getLongitude());
            int y = this.translator.translateLatitudeToY(location.getLatitude());
            g.fillRect(x - 1, y - 1, 3, 3);
            if (location.getName() == null || visitList.size() > 500) continue;
            g.drawString(WordUtils.abbreviate((String)location.getName(), (int)20, (int)-1, (String)"..."), x + 3, y - 3);
        }
        g.setColor(TangoColorFactory.ALUMINIUM_4);
        Domicile domicile = tspSolution.getDomicile();
        Location domicileLocation = domicile.getLocation();
        int domicileX = this.translator.translateLongitudeToX(domicileLocation.getLongitude());
        int domicileY = this.translator.translateLatitudeToY(domicileLocation.getLatitude());
        g.fillRect(domicileX - 2, domicileY - 2, 5, 5);
        if (domicileLocation.getName() != null && visitList.size() <= 500) {
            g.drawString(domicileLocation.getName(), domicileX + 3, domicileY - 3);
        }
        HashSet<Visit> needsBackToDomicileLineSet = new HashSet<Visit>(visitList);
        for (Visit trailingVisit : visitList) {
            if (!(trailingVisit.getPreviousStandstill() instanceof Visit)) continue;
            needsBackToDomicileLineSet.remove(trailingVisit.getPreviousStandstill());
        }
        g.setColor(TangoColorFactory.CHOCOLATE_1);
        for (Visit visit : visitList) {
            if (visit.getPreviousStandstill() == null) continue;
            Location previousLocation = visit.getPreviousStandstill().getLocation();
            Location location = visit.getLocation();
            this.translator.drawRoute(g, previousLocation.getLongitude(), previousLocation.getLatitude(), location.getLongitude(), location.getLatitude(), location instanceof AirLocation, false);
            if (!needsBackToDomicileLineSet.contains(visit)) continue;
            this.translator.drawRoute(g, location.getLongitude(), location.getLatitude(), domicileLocation.getLongitude(), domicileLocation.getLatitude(), location instanceof AirLocation, true);
        }
        if (this.dragSourceStandstill != null) {
            g.setColor(TangoColorFactory.CHOCOLATE_2);
            Location sourceLocation = this.dragSourceStandstill.getLocation();
            Location targetLocation = this.dragTargetStandstill.getLocation();
            this.translator.drawRoute(g, sourceLocation.getLongitude(), sourceLocation.getLatitude(), targetLocation.getLongitude(), targetLocation.getLatitude(), sourceLocation instanceof AirLocation, this.dragTargetStandstill instanceof Domicile);
        }
        g.setColor(TangoColorFactory.ALUMINIUM_4);
        g.fillRect(5, (int)height - 15 - 12, 5, 5);
        g.drawString("Domicile", 15, (int)height - 10 - 12);
        g.setColor(TangoColorFactory.PLUM_2);
        g.fillRect(6, (int)height - 9, 3, 3);
        g.drawString("Visit", 15, (int)height - 5);
        g.setColor(TangoColorFactory.ALUMINIUM_5);
        String locationsSizeString = tspSolution.getLocationList().size() + " locations";
        g.drawString(locationsSizeString, ((int)width - g.getFontMetrics().stringWidth(locationsSizeString)) / 2, (int)height - 5);
        if (tspSolution.getDistanceType() == DistanceType.AIR_DISTANCE) {
            String leftClickString = "Left click and drag between 2 locations to connect them.";
            g.drawString(leftClickString, (int)width - 5 - g.getFontMetrics().stringWidth(leftClickString), (int)height - 10 - 12);
            String rightClickString = "Right click anywhere on the map to add a visit.";
            g.drawString(rightClickString, (int)width - 5 - g.getFontMetrics().stringWidth(rightClickString), (int)height - 5);
        }
        g.setColor(TangoColorFactory.ORANGE_3);
        SimpleLongScore score = tspSolution.getScore();
        if (score != null) {
            String distanceString = tspSolution.getDistanceString(NUMBER_FORMAT);
            g.setFont(g.getFont().deriveFont(1, 24.0f));
            g.drawString(distanceString, (int)width - g.getFontMetrics().stringWidth(distanceString) - 10, (int)height - 15 - 24);
        }
        this.repaint();
    }

    public void updatePanel(TspSolution tspSolution) {
        this.resetPanel(tspSolution);
    }

    private Graphics2D createCanvas(double width, double height) {
        int canvasWidth = (int)Math.ceil(width) + 1;
        int canvasHeight = (int)Math.ceil(height) + 1;
        this.canvas = new BufferedImage(canvasWidth, canvasHeight, 1);
        Graphics2D g = this.canvas.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, canvasWidth, canvasHeight);
        return g;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.canvas != null) {
            g.drawImage(this.canvas, 0, 0, this);
        }
    }
}

