/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.nurserostering.domain.ShiftDate;

public class NurseRosterParametrization
extends AbstractPersistable {
    private ShiftDate firstShiftDate;
    private ShiftDate lastShiftDate;
    private ShiftDate planningWindowStart;

    public NurseRosterParametrization() {
    }

    public NurseRosterParametrization(long id, ShiftDate firstShiftDate, ShiftDate lastShiftDate, ShiftDate planningWindowStart) {
        super(id);
        this.firstShiftDate = firstShiftDate;
        this.lastShiftDate = lastShiftDate;
        this.planningWindowStart = planningWindowStart;
    }

    public ShiftDate getFirstShiftDate() {
        return this.firstShiftDate;
    }

    public void setFirstShiftDate(ShiftDate firstShiftDate) {
        this.firstShiftDate = firstShiftDate;
    }

    public ShiftDate getLastShiftDate() {
        return this.lastShiftDate;
    }

    public void setLastShiftDate(ShiftDate lastShiftDate) {
        this.lastShiftDate = lastShiftDate;
    }

    @JsonIgnore
    public int getFirstShiftDateDayIndex() {
        return this.firstShiftDate.getDayIndex();
    }

    @JsonIgnore
    public int getLastShiftDateDayIndex() {
        return this.lastShiftDate.getDayIndex();
    }

    public ShiftDate getPlanningWindowStart() {
        return this.planningWindowStart;
    }

    public void setPlanningWindowStart(ShiftDate planningWindowStart) {
        this.planningWindowStart = planningWindowStart;
    }

    public boolean isInPlanningWindow(ShiftDate shiftDate) {
        return this.planningWindowStart.getDayIndex() <= shiftDate.getDayIndex();
    }

    @Override
    public String toString() {
        return this.firstShiftDate + " - " + this.lastShiftDate;
    }
}

