/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.optional.score;

import java.util.Comparator;
import java.util.Objects;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.machinereassignment.domain.MrMachine;
import org.optaplanner.examples.machinereassignment.domain.MrMachineCapacity;
import org.optaplanner.examples.machinereassignment.domain.MrResource;

public class MrMachineTransientUsage
implements Comparable<MrMachineTransientUsage> {
    private static final Comparator<MrMachineTransientUsage> COMPARATOR = Comparator.comparing(transientUsage -> transientUsage.getClass().getName()).thenComparing(transientUsage -> transientUsage.machineCapacity, Comparator.comparingLong(AbstractPersistable::getId)).thenComparingLong(transientUsage -> transientUsage.usage);
    private MrMachineCapacity machineCapacity;
    private long usage;

    public MrMachineTransientUsage(MrMachineCapacity machineCapacity, long usage) {
        this.machineCapacity = machineCapacity;
        this.usage = usage;
    }

    public MrMachineCapacity getMachineCapacity() {
        return this.machineCapacity;
    }

    public long getUsage() {
        return this.usage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MrMachineTransientUsage other = (MrMachineTransientUsage)o;
        return Objects.equals(this.machineCapacity, other.machineCapacity) && this.usage == other.usage;
    }

    public int hashCode() {
        return Objects.hash(this.machineCapacity, this.usage);
    }

    public MrMachine getMachine() {
        return this.machineCapacity.getMachine();
    }

    public MrResource getResource() {
        return this.machineCapacity.getResource();
    }

    public String toString() {
        return this.getMachine() + "-" + this.getResource() + "=" + this.usage;
    }

    @Override
    public int compareTo(MrMachineTransientUsage o) {
        return COMPARATOR.compare(this, o);
    }
}

