/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.bi.DefaultBiConstraintCollector;
import org.optaplanner.core.impl.score.stream.quad.DefaultQuadConstraintCollector;
import org.optaplanner.core.impl.score.stream.tri.DefaultTriConstraintCollector;
import org.optaplanner.core.impl.score.stream.uni.DefaultUniConstraintCollector;
import org.optaplanner.examples.common.experimental.api.ConsecutiveInfo;
import org.optaplanner.examples.common.experimental.impl.ConsecutiveIntervalDataImpl;
import org.optaplanner.examples.common.experimental.impl.ConsecutiveSetTree;
import org.optaplanner.examples.common.experimental.impl.IntervalTree;

public class ExperimentalConstraintCollectors {
    public static <A> UniConstraintCollector<A, ConsecutiveSetTree<A, Integer, Integer>, ConsecutiveInfo<A, Integer>> consecutive(ToIntFunction<A> indexMap) {
        return new DefaultUniConstraintCollector(() -> new ConsecutiveSetTree<Object, Integer, Integer>(indexMap::applyAsInt, (a, b) -> b - a, Integer::sum, 1, 0), (acc, a) -> {
            acc.add(a);
            return () -> acc.remove(a);
        }, ConsecutiveSetTree::getConsecutiveData);
    }

    public static <A, B, Result> BiConstraintCollector<A, B, ConsecutiveSetTree<Result, Integer, Integer>, ConsecutiveInfo<Result, Integer>> consecutive(BiFunction<A, B, Result> resultMap, ToIntFunction<Result> indexMap) {
        return new DefaultBiConstraintCollector(() -> new ConsecutiveSetTree<Object, Integer, Integer>(indexMap::applyAsInt, (a, b) -> b - a, Integer::sum, 1, 0), (acc, a, b) -> {
            Object result = resultMap.apply(a, b);
            acc.add(result);
            return () -> acc.remove(result);
        }, ConsecutiveSetTree::getConsecutiveData);
    }

    public static <A, B, C, Result> TriConstraintCollector<A, B, C, ConsecutiveSetTree<Result, Integer, Integer>, ConsecutiveInfo<Result, Integer>> consecutive(TriFunction<A, B, C, Result> resultMap, ToIntFunction<Result> indexMap) {
        return new DefaultTriConstraintCollector(() -> new ConsecutiveSetTree<Object, Integer, Integer>(indexMap::applyAsInt, (a, b) -> b - a, Integer::sum, 1, 0), (acc, a, b, c) -> {
            Object result = resultMap.apply(a, b, c);
            acc.add(result);
            return () -> acc.remove(result);
        }, ConsecutiveSetTree::getConsecutiveData);
    }

    public static <A, B, C, D, Result> QuadConstraintCollector<A, B, C, D, ConsecutiveSetTree<Result, Integer, Integer>, ConsecutiveInfo<Result, Integer>> consecutive(QuadFunction<A, B, C, D, Result> resultMap, ToIntFunction<Result> indexMap) {
        return new DefaultQuadConstraintCollector(() -> new ConsecutiveSetTree<Object, Integer, Integer>(indexMap::applyAsInt, (a, b) -> b - a, Integer::sum, 1, 0), (acc, a, b, c, d) -> {
            Object result = resultMap.apply(a, b, c, d);
            acc.add(result);
            return () -> acc.remove(result);
        }, ConsecutiveSetTree::getConsecutiveData);
    }

    public static <A, C extends Comparable<C>> UniConstraintCollector<A, IntervalTree<A, C>, ConsecutiveIntervalDataImpl<A, C>> consecutiveIntervals(Function<A, C> startMap, Function<A, C> endMap) {
        return new DefaultUniConstraintCollector(() -> new IntervalTree(startMap, endMap), (acc, a) -> {
            acc.add(a);
            return () -> acc.remove(a);
        }, IntervalTree::getConsecutiveIntervalData);
    }

    public static <A, B, T, C extends Comparable<C>> BiConstraintCollector<A, B, IntervalTree<T, C>, ConsecutiveIntervalDataImpl<T, C>> consecutiveIntervals(BiFunction<A, B, T> intervalMap, Function<T, C> startMap, Function<T, C> endMap) {
        return new DefaultBiConstraintCollector(() -> new IntervalTree(startMap, endMap), (acc, a, b) -> {
            Object interval = intervalMap.apply(a, b);
            acc.add(interval);
            return () -> acc.remove(interval);
        }, IntervalTree::getConsecutiveIntervalData);
    }

    public static <A, B, C, T, I extends Comparable<I>> TriConstraintCollector<A, B, C, IntervalTree<T, I>, ConsecutiveIntervalDataImpl<T, I>> consecutiveIntervals(TriFunction<A, B, C, T> intervalMap, Function<T, I> startMap, Function<T, I> endMap) {
        return new DefaultTriConstraintCollector(() -> new IntervalTree(startMap, endMap), (acc, a, b, c) -> {
            Object interval = intervalMap.apply(a, b, c);
            acc.add(interval);
            return () -> acc.remove(interval);
        }, IntervalTree::getConsecutiveIntervalData);
    }

    public static <A, B, C, D, T, I extends Comparable<I>> QuadConstraintCollector<A, B, C, D, IntervalTree<T, I>, ConsecutiveIntervalDataImpl<T, I>> consecutiveIntervals(QuadFunction<A, B, C, D, T> intervalMap, Function<T, I> startMap, Function<T, I> endMap) {
        return new DefaultQuadConstraintCollector(() -> new IntervalTree(startMap, endMap), (acc, a, b, c, d) -> {
            Object interval = intervalMap.apply(a, b, c, d);
            acc.add(interval);
            return () -> acc.remove(interval);
        }, IntervalTree::getConsecutiveIntervalData);
    }

    private ExperimentalConstraintCollectors() {
    }
}

