/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.optaplanner.examples.common.experimental.api.Break;
import org.optaplanner.examples.common.experimental.api.ConsecutiveInfo;
import org.optaplanner.examples.common.experimental.api.Sequence;
import org.optaplanner.examples.common.experimental.impl.ConsecutiveSetTree;

class ConsecutiveDataImpl<ValueType_, DifferenceType_ extends Comparable<DifferenceType_>>
implements ConsecutiveInfo<ValueType_, DifferenceType_> {
    private final ConsecutiveSetTree<ValueType_, ?, DifferenceType_> sourceTree;

    protected ConsecutiveDataImpl(ConsecutiveSetTree<ValueType_, ?, DifferenceType_> sourceTree) {
        this.sourceTree = sourceTree;
    }

    @Override
    public Iterable<Sequence<ValueType_, DifferenceType_>> getConsecutiveSequences() {
        return this.sourceTree.getConsecutiveSequences();
    }

    @Override
    public Iterable<Break<ValueType_, DifferenceType_>> getBreaks() {
        return this.sourceTree.getBreaks();
    }

    public String toString() {
        Stream.Builder<Sequence<ValueType_, DifferenceType_>> streamBuilder = Stream.builder();
        for (Sequence<ValueType_, DifferenceType_> sequence : this.getConsecutiveSequences()) {
            streamBuilder.add(sequence);
        }
        return streamBuilder.build().map(Object::toString).collect(Collectors.joining("; ", "ConsecutiveData [", "]"));
    }
}

