/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.Iterator;
import java.util.TreeSet;
import java.util.function.Function;
import org.optaplanner.examples.common.experimental.impl.ConsecutiveIntervalDataImpl;
import org.optaplanner.examples.common.experimental.impl.Interval;
import org.optaplanner.examples.common.experimental.impl.IntervalSplitPoint;
import org.optaplanner.examples.common.experimental.impl.IntervalTreeIterator;

public class IntervalTree<IntervalValue_, PointValue_ extends Comparable<PointValue_>> {
    final TreeSet<IntervalSplitPoint<IntervalValue_, PointValue_>> splitPointSet;
    final Function<IntervalValue_, PointValue_> startMapping;
    final Function<IntervalValue_, PointValue_> endMapping;
    final ConsecutiveIntervalDataImpl<IntervalValue_, PointValue_> consecutiveIntervalData;

    public IntervalTree(Function<IntervalValue_, PointValue_> startMapping, Function<IntervalValue_, PointValue_> endMapping) {
        this.startMapping = startMapping;
        this.endMapping = endMapping;
        this.splitPointSet = new TreeSet();
        this.consecutiveIntervalData = new ConsecutiveIntervalDataImpl<IntervalValue_, PointValue_>(this.splitPointSet);
    }

    private Interval<IntervalValue_, PointValue_> getInterval(IntervalValue_ intervalValue) {
        return new Interval<IntervalValue_, PointValue_>(intervalValue, this.startMapping, this.endMapping);
    }

    public boolean isEmpty() {
        return this.splitPointSet.isEmpty();
    }

    public boolean contains(IntervalValue_ o) {
        if (null == o || this.splitPointSet.isEmpty()) {
            return false;
        }
        Interval<IntervalValue_, PointValue_> interval = this.getInterval(o);
        IntervalSplitPoint<IntervalValue_, PointValue_> floorStartSplitPoint = this.splitPointSet.floor(interval.getStartSplitPoint());
        if (floorStartSplitPoint == null) {
            return false;
        }
        return floorStartSplitPoint.containsIntervalStarting(interval);
    }

    public Iterator<IntervalValue_> iterator() {
        return new IntervalTreeIterator<IntervalValue_, PointValue_>(this.splitPointSet);
    }

    public boolean add(IntervalValue_ o) {
        boolean isChanged;
        Interval<IntervalValue_, PointValue_> interval = this.getInterval(o);
        IntervalSplitPoint<IntervalValue_, PointValue_> startSplitPoint = interval.getStartSplitPoint();
        IntervalSplitPoint<IntervalValue_, PointValue_> endSplitPoint = interval.getEndSplitPoint();
        IntervalSplitPoint<IntervalValue_, PointValue_> flooredStartSplitPoint = this.splitPointSet.floor(startSplitPoint);
        IntervalSplitPoint<IntervalValue_, PointValue_> ceilingEndSplitPoint = this.splitPointSet.ceiling(endSplitPoint);
        if (flooredStartSplitPoint == null || !flooredStartSplitPoint.equals(startSplitPoint)) {
            this.splitPointSet.add(startSplitPoint);
            startSplitPoint.createCollections();
            isChanged = startSplitPoint.addIntervalStartingAtSplitPoint(interval);
        } else {
            isChanged = flooredStartSplitPoint.addIntervalStartingAtSplitPoint(interval);
        }
        if (ceilingEndSplitPoint == null || !ceilingEndSplitPoint.equals(endSplitPoint)) {
            this.splitPointSet.add(endSplitPoint);
            endSplitPoint.createCollections();
            endSplitPoint.addIntervalEndingAtSplitPoint(interval);
        } else {
            ceilingEndSplitPoint.addIntervalEndingAtSplitPoint(interval);
        }
        if (isChanged) {
            this.consecutiveIntervalData.addInterval(interval);
        }
        return true;
    }

    public boolean remove(IntervalValue_ o) {
        if (null == o) {
            return false;
        }
        Interval<IntervalValue_, PointValue_> interval = this.getInterval(o);
        IntervalSplitPoint<IntervalValue_, PointValue_> startSplitPoint = interval.getStartSplitPoint();
        IntervalSplitPoint<IntervalValue_, PointValue_> endSplitPoint = interval.getEndSplitPoint();
        IntervalSplitPoint<IntervalValue_, PointValue_> flooredStartSplitPoint = this.splitPointSet.floor(startSplitPoint);
        if (flooredStartSplitPoint == null || !flooredStartSplitPoint.containsIntervalStarting(interval)) {
            return false;
        }
        flooredStartSplitPoint.removeIntervalStartingAtSplitPoint(interval);
        if (flooredStartSplitPoint.isEmpty()) {
            this.splitPointSet.remove(flooredStartSplitPoint);
        }
        IntervalSplitPoint<IntervalValue_, PointValue_> ceilEndSplitPoint = this.splitPointSet.ceiling(endSplitPoint);
        ceilEndSplitPoint.removeIntervalEndingAtSplitPoint(interval);
        if (ceilEndSplitPoint.isEmpty()) {
            this.splitPointSet.remove(ceilEndSplitPoint);
        }
        this.consecutiveIntervalData.removalInterval(interval);
        return true;
    }

    public ConsecutiveIntervalDataImpl<IntervalValue_, PointValue_> getConsecutiveIntervalData() {
        return this.consecutiveIntervalData;
    }
}

