/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.optional.score;

import java.util.Comparator;
import java.util.Objects;
import org.optaplanner.examples.nurserostering.domain.Employee;

public class EmployeeWeekendSequence
implements Comparable<EmployeeWeekendSequence> {
    private static final Comparator<EmployeeWeekendSequence> COMPARATOR = Comparator.comparing(EmployeeWeekendSequence::getEmployee).thenComparingInt(EmployeeWeekendSequence::getFirstSundayIndex).thenComparingInt(EmployeeWeekendSequence::getLastSundayIndex);
    private Employee employee;
    private int firstSundayIndex;
    private int lastSundayIndex;

    public EmployeeWeekendSequence(Employee employee, int firstSundayIndex, int lastSundayIndex) {
        this.employee = employee;
        this.firstSundayIndex = firstSundayIndex;
        this.lastSundayIndex = lastSundayIndex;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public int getFirstSundayIndex() {
        return this.firstSundayIndex;
    }

    public void setFirstSundayIndex(int firstSundayIndex) {
        this.firstSundayIndex = firstSundayIndex;
    }

    public int getLastSundayIndex() {
        return this.lastSundayIndex;
    }

    public void setLastSundayIndex(int lastSundayIndex) {
        this.lastSundayIndex = lastSundayIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmployeeWeekendSequence other = (EmployeeWeekendSequence)o;
        return Objects.equals(this.employee, other.employee) && this.firstSundayIndex == other.firstSundayIndex && this.lastSundayIndex == other.lastSundayIndex;
    }

    public int hashCode() {
        return Objects.hash(this.employee, this.firstSundayIndex, this.lastSundayIndex);
    }

    @Override
    public int compareTo(EmployeeWeekendSequence other) {
        return COMPARATOR.compare(this, other);
    }

    public String toString() {
        return this.employee + " is working the weekend of " + this.firstSundayIndex + " - " + this.lastSundayIndex;
    }

    public int getWeekendLength() {
        return (this.lastSundayIndex - this.firstSundayIndex) / 7 + 1;
    }
}

