/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.optional.score;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.calculator.EasyScoreCalculator;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedVehicleRoutingSolution;

public class VehicleRoutingEasyScoreCalculator
implements EasyScoreCalculator<VehicleRoutingSolution, HardSoftLongScore> {
    public HardSoftLongScore calculateScore(VehicleRoutingSolution solution) {
        boolean timeWindowed = solution instanceof TimeWindowedVehicleRoutingSolution;
        List<Customer> customerList = solution.getCustomerList();
        List<Vehicle> vehicleList = solution.getVehicleList();
        HashMap<Vehicle, Integer> vehicleDemandMap = new HashMap<Vehicle, Integer>(vehicleList.size());
        for (Vehicle vehicle : vehicleList) {
            vehicleDemandMap.put(vehicle, 0);
        }
        long hardScore = 0L;
        long softScore = 0L;
        for (Customer customer : customerList) {
            Long arrivalTime;
            TimeWindowedCustomer timeWindowedCustomer;
            long dueTime;
            Vehicle vehicle = customer.getVehicle();
            if (vehicle == null) continue;
            vehicleDemandMap.put(vehicle, (Integer)vehicleDemandMap.get(vehicle) + customer.getDemand());
            softScore -= customer.getDistanceFromPreviousStandstill();
            if (customer.getNextCustomer() == null) {
                softScore -= customer.getLocation().getDistanceTo(vehicle.getLocation());
            }
            if (!timeWindowed || (dueTime = (timeWindowedCustomer = (TimeWindowedCustomer)customer).getDueTime()) >= (arrivalTime = timeWindowedCustomer.getArrivalTime())) continue;
            hardScore -= arrivalTime - dueTime;
        }
        for (Map.Entry entry : vehicleDemandMap.entrySet()) {
            int capacity = ((Vehicle)entry.getKey()).getCapacity();
            int demand = (Integer)entry.getValue();
            if (demand <= capacity) continue;
            hardScore -= (long)(demand - capacity);
        }
        return HardSoftLongScore.of((long)hardScore, (long)softScore);
    }
}

