/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.components.LabeledComboBoxRenderer;
import org.optaplanner.examples.common.swingui.timetable.TimeTablePanel;
import org.optaplanner.examples.pas.domain.AdmissionPart;
import org.optaplanner.examples.pas.domain.Bed;
import org.optaplanner.examples.pas.domain.BedDesignation;
import org.optaplanner.examples.pas.domain.Department;
import org.optaplanner.examples.pas.domain.Gender;
import org.optaplanner.examples.pas.domain.GenderLimitation;
import org.optaplanner.examples.pas.domain.Night;
import org.optaplanner.examples.pas.domain.Patient;
import org.optaplanner.examples.pas.domain.PatientAdmissionSchedule;
import org.optaplanner.examples.pas.domain.RequiredPatientEquipment;
import org.optaplanner.examples.pas.domain.Room;
import org.optaplanner.examples.pas.domain.RoomEquipment;
import org.optaplanner.swing.impl.SwingUtils;
import org.optaplanner.swing.impl.TangoColorFactory;

public class PatientAdmissionSchedulePanel
extends SolutionPanel<PatientAdmissionSchedule> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/pas/swingui/pasLogo.png";
    private final ImageIcon anyGenderIcon = new ImageIcon(this.getClass().getResource("anyGender.png"));
    private final ImageIcon maleIcon = new ImageIcon(this.getClass().getResource("male.png"));
    private final ImageIcon femaleIcon = new ImageIcon(this.getClass().getResource("female.png"));
    private final ImageIcon sameGenderIcon = new ImageIcon(this.getClass().getResource("sameGender.png"));
    private TimeTablePanel<Night, Bed> timeTablePanel;
    private TangoColorFactory equipmentTangoColorFactory;

    public PatientAdmissionSchedulePanel() {
        this.setLayout(new BorderLayout());
        this.timeTablePanel = new TimeTablePanel();
        this.add(this.timeTablePanel, "Center");
    }

    @Override
    public void resetPanel(PatientAdmissionSchedule patientAdmissionSchedule) {
        this.timeTablePanel.reset();
        this.equipmentTangoColorFactory = new TangoColorFactory();
        this.defineGrid(patientAdmissionSchedule);
        this.fillCells(patientAdmissionSchedule);
        this.repaint();
    }

    private void defineGrid(PatientAdmissionSchedule patientAdmissionSchedule) {
        JButton footprint = SwingUtils.makeSmallButton((JButton)new JButton("Patient9999"));
        int footprintWidth = footprint.getPreferredSize().width;
        this.timeTablePanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP2);
        this.timeTablePanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1);
        this.timeTablePanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN);
        for (Night night : patientAdmissionSchedule.getNightList()) {
            this.timeTablePanel.defineColumnHeader(night, footprintWidth);
        }
        this.timeTablePanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW);
        this.timeTablePanel.defineRowHeader(null);
        for (Bed bed : patientAdmissionSchedule.getBedList()) {
            this.timeTablePanel.defineRowHeader(bed);
        }
    }

    private void fillCells(PatientAdmissionSchedule patientAdmissionSchedule) {
        this.timeTablePanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP2, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel("Department")));
        this.timeTablePanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel("Room")));
        this.timeTablePanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel("Bed")));
        this.fillNightCells(patientAdmissionSchedule);
        this.fillBedCells(patientAdmissionSchedule);
        this.fillBedDesignationCells(patientAdmissionSchedule);
    }

    private void fillNightCells(PatientAdmissionSchedule patientAdmissionSchedule) {
        for (Night night : patientAdmissionSchedule.getNightList()) {
            this.timeTablePanel.addColumnHeader(night, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel(night.getLabel(), 0)));
        }
    }

    private void fillBedCells(PatientAdmissionSchedule patientAdmissionSchedule) {
        this.timeTablePanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP2, null, TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, null, this.createHeaderPanel(new JLabel("Unassigned")));
        for (Department department : patientAdmissionSchedule.getDepartmentList()) {
            List<Room> roomList = department.getRoomList();
            List<Bed> firstRoomBedList = roomList.get(0).getBedList();
            List<Bed> lastRoomBedList = roomList.get(roomList.size() - 1).getBedList();
            this.timeTablePanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP2, firstRoomBedList.get(0), TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP2, lastRoomBedList.get(lastRoomBedList.size() - 1), this.createHeaderPanel(new JLabel(department.getLabel())));
            for (Room room : roomList) {
                List<Bed> bedList = room.getBedList();
                JLabel roomLabel = new JLabel(room.getLabel(), new PatientOrRoomIcon(room), 4);
                this.timeTablePanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, bedList.get(0), TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, bedList.get(bedList.size() - 1), this.createHeaderPanel(roomLabel));
                for (Bed bed : bedList) {
                    this.timeTablePanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, bed, this.createHeaderPanel(new JLabel(bed.getLabelInRoom(), 4)));
                }
            }
        }
    }

    private void fillBedDesignationCells(PatientAdmissionSchedule patientAdmissionSchedule) {
        for (BedDesignation bedDesignation : patientAdmissionSchedule.getBedDesignationList()) {
            JButton button = SwingUtils.makeSmallButton((JButton)new JButton(new BedDesignationAction(bedDesignation)));
            AdmissionPart admissionPart = bedDesignation.getAdmissionPart();
            this.timeTablePanel.addCell(admissionPart.getFirstNight(), bedDesignation.getBed(), admissionPart.getLastNight(), bedDesignation.getBed(), button);
        }
    }

    private JPanel createHeaderPanel(JLabel label) {
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add((Component)label, "North");
        headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(TangoColorFactory.ALUMINIUM_5), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        return headerPanel;
    }

    private ImageIcon determineRoomGenderIcon(GenderLimitation genderLimitation) {
        switch (genderLimitation) {
            case ANY_GENDER: {
                return this.anyGenderIcon;
            }
            case MALE_ONLY: {
                return this.maleIcon;
            }
            case FEMALE_ONLY: {
                return this.femaleIcon;
            }
            case SAME_GENDER: {
                return this.sameGenderIcon;
            }
        }
        throw new IllegalStateException("The genderLimitation (" + genderLimitation + ") is not implemented.");
    }

    private ImageIcon determinePatientGenderIcon(Gender gender) {
        switch (gender) {
            case MALE: {
                return this.maleIcon;
            }
            case FEMALE: {
                return this.femaleIcon;
            }
        }
        throw new IllegalStateException("The gender (" + gender + ") is not implemented.");
    }

    private class PatientOrRoomIcon
    implements Icon {
        private static final int EQUIPMENT_ICON_WIDTH = 8;
        private final ImageIcon genderIcon;
        private final List<Color> equipmentColorList;

        private PatientOrRoomIcon(Patient patient) {
            this.genderIcon = PatientAdmissionSchedulePanel.this.determinePatientGenderIcon(patient.getGender());
            List<RequiredPatientEquipment> equipmentList = patient.getRequiredPatientEquipmentList();
            this.equipmentColorList = new ArrayList<Color>(equipmentList.size());
            for (RequiredPatientEquipment equipment : equipmentList) {
                this.equipmentColorList.add(PatientAdmissionSchedulePanel.this.equipmentTangoColorFactory.pickColor((Object)equipment.getEquipment()));
            }
        }

        private PatientOrRoomIcon(Room room) {
            this.genderIcon = PatientAdmissionSchedulePanel.this.determineRoomGenderIcon(room.getGenderLimitation());
            List<RoomEquipment> equipmentList = room.getRoomEquipmentList();
            this.equipmentColorList = new ArrayList<Color>(equipmentList.size());
            for (RoomEquipment equipment : equipmentList) {
                this.equipmentColorList.add(PatientAdmissionSchedulePanel.this.equipmentTangoColorFactory.pickColor((Object)equipment.getEquipment()));
            }
        }

        @Override
        public int getIconWidth() {
            return this.genderIcon.getIconWidth() + this.equipmentColorList.size() * 8;
        }

        @Override
        public int getIconHeight() {
            return this.genderIcon.getIconHeight();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.genderIcon.paintIcon(c, g, x, y);
            int innerX = x + this.genderIcon.getIconWidth();
            int equipmentIconHeight = this.genderIcon.getIconHeight();
            for (int i = 0; i < this.equipmentColorList.size(); ++i) {
                g.setColor(this.equipmentColorList.get(i));
                g.fillRect(innerX + 1, y + 1, 6, equipmentIconHeight - 2);
                g.setColor(TangoColorFactory.ALUMINIUM_5);
                g.drawRect(innerX + 1, y + 1, 6, equipmentIconHeight - 2);
                innerX += 8;
            }
        }
    }

    private class BedDesignationAction
    extends AbstractAction {
        private final BedDesignation bedDesignation;

        public BedDesignationAction(BedDesignation bedDesignation) {
            super(bedDesignation.getAdmissionPart().getPatient().getName(), new PatientOrRoomIcon(bedDesignation.getAdmissionPart().getPatient()));
            this.bedDesignation = bedDesignation;
            Patient patient = bedDesignation.getPatient();
            this.putValue("ShortDescription", "<html>Patient: " + patient.getName() + "<br/>Gender: " + patient.getGender().getCode() + " (see icon)<br/>Age: " + patient.getAge() + "<br/>Preferred maximum room capacity: " + patient.getPreferredMaximumRoomCapacity() + "<br/>Requires " + patient.getRequiredPatientEquipmentList().size() + " equipments (shown as rectangles)<br/>Prefers " + patient.getPreferredPatientEquipmentList().size() + " equipments</html>");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel listFieldsPanel = new JPanel(new GridLayout(2, 1));
            List<Bed> bedList = ((PatientAdmissionSchedule)PatientAdmissionSchedulePanel.this.getSolution()).getBedList();
            JComboBox<Object> bedListField = new JComboBox<Object>(bedList.toArray(new Object[bedList.size() + 1]));
            LabeledComboBoxRenderer.applyToComboBox(bedListField);
            bedListField.setSelectedItem(this.bedDesignation.getBed());
            listFieldsPanel.add(bedListField);
            int result = JOptionPane.showConfirmDialog(PatientAdmissionSchedulePanel.this.getRootPane(), listFieldsPanel, "Select bed for " + this.bedDesignation.getAdmissionPart().getPatient().getName(), 2);
            if (result == 0) {
                Bed toBed = (Bed)bedListField.getSelectedItem();
                PatientAdmissionSchedulePanel.this.doProblemChange((workingSolution, problemChangeDirector) -> problemChangeDirector.changeVariable((Object)this.bedDesignation, "bed", bd -> bd.setBed(toBed)));
                PatientAdmissionSchedulePanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }
}

